// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationdiscoveryservice.model



public class ListConfigurationsRequest private constructor(builder: Builder) {
    /**
     * A valid configuration identified by Application Discovery Service.
     */
    public val configurationType: aws.sdk.kotlin.services.applicationdiscoveryservice.model.ConfigurationItemType? = builder.configurationType
    /**
     * You can filter the request using various logical operators and a *key*-*value* format. For example:
     *
     * `{"key": "serverType", "value": "webServer"}`
     *
     * For a complete list of filter options and guidance about using them with this action, see [Using the ListConfigurations Action](https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#ListConfigurations) in the *Amazon Web Services Application Discovery Service User Guide*.
     */
    public val filters: List<Filter>? = builder.filters
    /**
     * The total number of items to return. The maximum value is 100.
     */
    public val maxResults: kotlin.Int = builder.maxResults
    /**
     * Token to retrieve the next set of results. For example, if a previous call to ListConfigurations returned 100 items, but you set `ListConfigurationsRequest$maxResults` to 10, you received a set of 10 results along with a token. Use that token in this query to get the next set of 10.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * Certain filter criteria return output that can be sorted in ascending or descending order. For a list of output characteristics for each filter, see [Using the ListConfigurations Action](https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#ListConfigurations) in the *Amazon Web Services Application Discovery Service User Guide*.
     */
    public val orderBy: List<OrderByElement>? = builder.orderBy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.applicationdiscoveryservice.model.ListConfigurationsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListConfigurationsRequest(")
        append("configurationType=$configurationType,")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("orderBy=$orderBy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configurationType?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (maxResults)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (orderBy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListConfigurationsRequest

        if (configurationType != other.configurationType) return false
        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (orderBy != other.orderBy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.applicationdiscoveryservice.model.ListConfigurationsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A valid configuration identified by Application Discovery Service.
         */
        public var configurationType: aws.sdk.kotlin.services.applicationdiscoveryservice.model.ConfigurationItemType? = null
        /**
         * You can filter the request using various logical operators and a *key*-*value* format. For example:
         *
         * `{"key": "serverType", "value": "webServer"}`
         *
         * For a complete list of filter options and guidance about using them with this action, see [Using the ListConfigurations Action](https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#ListConfigurations) in the *Amazon Web Services Application Discovery Service User Guide*.
         */
        public var filters: List<Filter>? = null
        /**
         * The total number of items to return. The maximum value is 100.
         */
        public var maxResults: kotlin.Int = 0
        /**
         * Token to retrieve the next set of results. For example, if a previous call to ListConfigurations returned 100 items, but you set `ListConfigurationsRequest$maxResults` to 10, you received a set of 10 results along with a token. Use that token in this query to get the next set of 10.
         */
        public var nextToken: kotlin.String? = null
        /**
         * Certain filter criteria return output that can be sorted in ascending or descending order. For a list of output characteristics for each filter, see [Using the ListConfigurations Action](https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#ListConfigurations) in the *Amazon Web Services Application Discovery Service User Guide*.
         */
        public var orderBy: List<OrderByElement>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.applicationdiscoveryservice.model.ListConfigurationsRequest) : this() {
            this.configurationType = x.configurationType
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.orderBy = x.orderBy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.applicationdiscoveryservice.model.ListConfigurationsRequest = ListConfigurationsRequest(this)

        internal fun correctErrors(): Builder {
            if (configurationType == null) configurationType = ConfigurationItemType.SdkUnknown("no value provided")
            return this
        }
    }
}
