// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationdiscoveryservice.model



/**
 * Information about agents or connectors that were instructed to start collecting data.
 * Information includes the agent/connector ID, a description of the operation, and whether the
 * agent/connector configuration was updated.
 */
class AgentConfigurationStatus private constructor(builder: BuilderImpl) {
    /**
     * The agent/connector ID.
     */
    val agentId: String? = builder.agentId
    /**
     * A description of the operation performed.
     */
    val description: String? = builder.description
    /**
     * Information about the status of the StartDataCollection and
     * StopDataCollection operations. The system has recorded the data collection
     * operation. The agent/connector receives this command the next time it polls for a new command.
     */
    val operationSucceeded: Boolean = builder.operationSucceeded

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AgentConfigurationStatus = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AgentConfigurationStatus(")
        append("agentId=$agentId,")
        append("description=$description,")
        append("operationSucceeded=$operationSucceeded)")
    }

    override fun hashCode(): kotlin.Int {
        var result = agentId?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (operationSucceeded.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AgentConfigurationStatus

        if (agentId != other.agentId) return false
        if (description != other.description) return false
        if (operationSucceeded != other.operationSucceeded) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AgentConfigurationStatus = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AgentConfigurationStatus
        /**
         * The agent/connector ID.
         */
        fun agentId(agentId: String): FluentBuilder
        /**
         * A description of the operation performed.
         */
        fun description(description: String): FluentBuilder
        /**
         * Information about the status of the StartDataCollection and
         * StopDataCollection operations. The system has recorded the data collection
         * operation. The agent/connector receives this command the next time it polls for a new command.
         */
        fun operationSucceeded(operationSucceeded: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The agent/connector ID.
         */
        var agentId: String?
        /**
         * A description of the operation performed.
         */
        var description: String?
        /**
         * Information about the status of the StartDataCollection and
         * StopDataCollection operations. The system has recorded the data collection
         * operation. The agent/connector receives this command the next time it polls for a new command.
         */
        var operationSucceeded: Boolean

        fun build(): AgentConfigurationStatus
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var agentId: String? = null
        override var description: String? = null
        override var operationSucceeded: Boolean = false

        constructor(x: AgentConfigurationStatus) : this() {
            this.agentId = x.agentId
            this.description = x.description
            this.operationSucceeded = x.operationSucceeded
        }

        override fun build(): AgentConfigurationStatus = AgentConfigurationStatus(this)
        override fun agentId(agentId: String): FluentBuilder = apply { this.agentId = agentId }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun operationSucceeded(operationSucceeded: Boolean): FluentBuilder = apply { this.operationSucceeded = operationSucceeded }
    }
}
