// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationdiscoveryservice.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information regarding the export status of discovered data. The value is an array of
 * objects.
 */
class ExportInfo private constructor(builder: BuilderImpl) {
    /**
     * A URL for an Amazon S3 bucket where you can review the exported data. The URL is
     * displayed only if the export succeeded.
     */
    val configurationsDownloadUrl: String? = builder.configurationsDownloadUrl
    /**
     * A unique identifier used to query an export.
     */
    val exportId: String? = builder.exportId
    /**
     * The time that the data export was initiated.
     */
    val exportRequestTime: Instant? = builder.exportRequestTime
    /**
     * The status of the data export job.
     */
    val exportStatus: ExportStatus? = builder.exportStatus
    /**
     * If true, the export of agent information exceeded the size limit for a single export
     * and the exported data is incomplete for the requested time range. To address this, select a
     * smaller time range for the export by using startDate and
     * endDate.
     */
    val isTruncated: Boolean = builder.isTruncated
    /**
     * The endTime used in the StartExportTask request. If no
     * endTime was requested, this result does not appear in
     * ExportInfo.
     */
    val requestedEndTime: Instant? = builder.requestedEndTime
    /**
     * The value of startTime parameter in the StartExportTask
     * request. If no startTime was requested, this result does not appear in
     * ExportInfo.
     */
    val requestedStartTime: Instant? = builder.requestedStartTime
    /**
     * A status message provided for API callers.
     */
    val statusMessage: String? = builder.statusMessage

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ExportInfo = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ExportInfo(")
        append("configurationsDownloadUrl=$configurationsDownloadUrl,")
        append("exportId=$exportId,")
        append("exportRequestTime=$exportRequestTime,")
        append("exportStatus=$exportStatus,")
        append("isTruncated=$isTruncated,")
        append("requestedEndTime=$requestedEndTime,")
        append("requestedStartTime=$requestedStartTime,")
        append("statusMessage=$statusMessage)")
    }

    override fun hashCode(): kotlin.Int {
        var result = configurationsDownloadUrl?.hashCode() ?: 0
        result = 31 * result + (exportId?.hashCode() ?: 0)
        result = 31 * result + (exportRequestTime?.hashCode() ?: 0)
        result = 31 * result + (exportStatus?.hashCode() ?: 0)
        result = 31 * result + (isTruncated.hashCode())
        result = 31 * result + (requestedEndTime?.hashCode() ?: 0)
        result = 31 * result + (requestedStartTime?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ExportInfo

        if (configurationsDownloadUrl != other.configurationsDownloadUrl) return false
        if (exportId != other.exportId) return false
        if (exportRequestTime != other.exportRequestTime) return false
        if (exportStatus != other.exportStatus) return false
        if (isTruncated != other.isTruncated) return false
        if (requestedEndTime != other.requestedEndTime) return false
        if (requestedStartTime != other.requestedStartTime) return false
        if (statusMessage != other.statusMessage) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ExportInfo = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ExportInfo
        /**
         * A URL for an Amazon S3 bucket where you can review the exported data. The URL is
         * displayed only if the export succeeded.
         */
        fun configurationsDownloadUrl(configurationsDownloadUrl: String): FluentBuilder
        /**
         * A unique identifier used to query an export.
         */
        fun exportId(exportId: String): FluentBuilder
        /**
         * The time that the data export was initiated.
         */
        fun exportRequestTime(exportRequestTime: Instant): FluentBuilder
        /**
         * The status of the data export job.
         */
        fun exportStatus(exportStatus: ExportStatus): FluentBuilder
        /**
         * If true, the export of agent information exceeded the size limit for a single export
         * and the exported data is incomplete for the requested time range. To address this, select a
         * smaller time range for the export by using startDate and
         * endDate.
         */
        fun isTruncated(isTruncated: Boolean): FluentBuilder
        /**
         * The endTime used in the StartExportTask request. If no
         * endTime was requested, this result does not appear in
         * ExportInfo.
         */
        fun requestedEndTime(requestedEndTime: Instant): FluentBuilder
        /**
         * The value of startTime parameter in the StartExportTask
         * request. If no startTime was requested, this result does not appear in
         * ExportInfo.
         */
        fun requestedStartTime(requestedStartTime: Instant): FluentBuilder
        /**
         * A status message provided for API callers.
         */
        fun statusMessage(statusMessage: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A URL for an Amazon S3 bucket where you can review the exported data. The URL is
         * displayed only if the export succeeded.
         */
        var configurationsDownloadUrl: String?
        /**
         * A unique identifier used to query an export.
         */
        var exportId: String?
        /**
         * The time that the data export was initiated.
         */
        var exportRequestTime: Instant?
        /**
         * The status of the data export job.
         */
        var exportStatus: ExportStatus?
        /**
         * If true, the export of agent information exceeded the size limit for a single export
         * and the exported data is incomplete for the requested time range. To address this, select a
         * smaller time range for the export by using startDate and
         * endDate.
         */
        var isTruncated: Boolean
        /**
         * The endTime used in the StartExportTask request. If no
         * endTime was requested, this result does not appear in
         * ExportInfo.
         */
        var requestedEndTime: Instant?
        /**
         * The value of startTime parameter in the StartExportTask
         * request. If no startTime was requested, this result does not appear in
         * ExportInfo.
         */
        var requestedStartTime: Instant?
        /**
         * A status message provided for API callers.
         */
        var statusMessage: String?

        fun build(): ExportInfo
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var configurationsDownloadUrl: String? = null
        override var exportId: String? = null
        override var exportRequestTime: Instant? = null
        override var exportStatus: ExportStatus? = null
        override var isTruncated: Boolean = false
        override var requestedEndTime: Instant? = null
        override var requestedStartTime: Instant? = null
        override var statusMessage: String? = null

        constructor(x: ExportInfo) : this() {
            this.configurationsDownloadUrl = x.configurationsDownloadUrl
            this.exportId = x.exportId
            this.exportRequestTime = x.exportRequestTime
            this.exportStatus = x.exportStatus
            this.isTruncated = x.isTruncated
            this.requestedEndTime = x.requestedEndTime
            this.requestedStartTime = x.requestedStartTime
            this.statusMessage = x.statusMessage
        }

        override fun build(): ExportInfo = ExportInfo(this)
        override fun configurationsDownloadUrl(configurationsDownloadUrl: String): FluentBuilder = apply { this.configurationsDownloadUrl = configurationsDownloadUrl }
        override fun exportId(exportId: String): FluentBuilder = apply { this.exportId = exportId }
        override fun exportRequestTime(exportRequestTime: Instant): FluentBuilder = apply { this.exportRequestTime = exportRequestTime }
        override fun exportStatus(exportStatus: ExportStatus): FluentBuilder = apply { this.exportStatus = exportStatus }
        override fun isTruncated(isTruncated: Boolean): FluentBuilder = apply { this.isTruncated = isTruncated }
        override fun requestedEndTime(requestedEndTime: Instant): FluentBuilder = apply { this.requestedEndTime = requestedEndTime }
        override fun requestedStartTime(requestedStartTime: Instant): FluentBuilder = apply { this.requestedStartTime = requestedStartTime }
        override fun statusMessage(statusMessage: String): FluentBuilder = apply { this.statusMessage = statusMessage }
    }
}
