// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationdiscoveryservice.model



/**
 * Details about neighboring servers.
 */
class NeighborConnectionDetail private constructor(builder: BuilderImpl) {
    /**
     * The number of open network connections with the neighboring server.
     */
    val connectionsCount: Long = builder.connectionsCount
    /**
     * The destination network port for the connection.
     */
    val destinationPort: Int? = builder.destinationPort
    /**
     * The ID of the server that accepted the network connection.
     */
    val destinationServerId: String? = builder.destinationServerId
    /**
     * The ID of the server that opened the network connection.
     */
    val sourceServerId: String? = builder.sourceServerId
    /**
     * The network protocol used for the connection.
     */
    val transportProtocol: String? = builder.transportProtocol

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): NeighborConnectionDetail = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("NeighborConnectionDetail(")
        append("connectionsCount=$connectionsCount,")
        append("destinationPort=$destinationPort,")
        append("destinationServerId=$destinationServerId,")
        append("sourceServerId=$sourceServerId,")
        append("transportProtocol=$transportProtocol)")
    }

    override fun hashCode(): kotlin.Int {
        var result = connectionsCount.hashCode()
        result = 31 * result + (destinationPort ?: 0)
        result = 31 * result + (destinationServerId?.hashCode() ?: 0)
        result = 31 * result + (sourceServerId?.hashCode() ?: 0)
        result = 31 * result + (transportProtocol?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as NeighborConnectionDetail

        if (connectionsCount != other.connectionsCount) return false
        if (destinationPort != other.destinationPort) return false
        if (destinationServerId != other.destinationServerId) return false
        if (sourceServerId != other.sourceServerId) return false
        if (transportProtocol != other.transportProtocol) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): NeighborConnectionDetail = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): NeighborConnectionDetail
        /**
         * The number of open network connections with the neighboring server.
         */
        fun connectionsCount(connectionsCount: Long): FluentBuilder
        /**
         * The destination network port for the connection.
         */
        fun destinationPort(destinationPort: Int): FluentBuilder
        /**
         * The ID of the server that accepted the network connection.
         */
        fun destinationServerId(destinationServerId: String): FluentBuilder
        /**
         * The ID of the server that opened the network connection.
         */
        fun sourceServerId(sourceServerId: String): FluentBuilder
        /**
         * The network protocol used for the connection.
         */
        fun transportProtocol(transportProtocol: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The number of open network connections with the neighboring server.
         */
        var connectionsCount: Long
        /**
         * The destination network port for the connection.
         */
        var destinationPort: Int?
        /**
         * The ID of the server that accepted the network connection.
         */
        var destinationServerId: String?
        /**
         * The ID of the server that opened the network connection.
         */
        var sourceServerId: String?
        /**
         * The network protocol used for the connection.
         */
        var transportProtocol: String?

        fun build(): NeighborConnectionDetail
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var connectionsCount: Long = 0L
        override var destinationPort: Int? = null
        override var destinationServerId: String? = null
        override var sourceServerId: String? = null
        override var transportProtocol: String? = null

        constructor(x: NeighborConnectionDetail) : this() {
            this.connectionsCount = x.connectionsCount
            this.destinationPort = x.destinationPort
            this.destinationServerId = x.destinationServerId
            this.sourceServerId = x.sourceServerId
            this.transportProtocol = x.transportProtocol
        }

        override fun build(): NeighborConnectionDetail = NeighborConnectionDetail(this)
        override fun connectionsCount(connectionsCount: Long): FluentBuilder = apply { this.connectionsCount = connectionsCount }
        override fun destinationPort(destinationPort: Int): FluentBuilder = apply { this.destinationPort = destinationPort }
        override fun destinationServerId(destinationServerId: String): FluentBuilder = apply { this.destinationServerId = destinationServerId }
        override fun sourceServerId(sourceServerId: String): FluentBuilder = apply { this.sourceServerId = sourceServerId }
        override fun transportProtocol(transportProtocol: String): FluentBuilder = apply { this.transportProtocol = transportProtocol }
    }
}
