// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationdiscoveryservice.model



/**
 * A filter that can use conditional operators.
 * For more information about filters, see <a href="https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html">Querying Discovered
 * Configuration Items in the AWS Application Discovery Service User
 * Guide.
 */
class Filter private constructor(builder: BuilderImpl) {
    /**
     * A conditional operator. The following operators are valid: EQUALS, NOT_EQUALS,
     * CONTAINS, NOT_CONTAINS. If you specify multiple filters, the system utilizes all filters as
     * though concatenated by AND. If you specify multiple values for a
     * particular filter, the system differentiates the values using OR. Calling
     * either DescribeConfigurations or ListConfigurations
     * returns attributes of matching configuration items.
     */
    val condition: String? = builder.condition
    /**
     * The name of the filter.
     */
    val name: String? = builder.name
    /**
     * A string value on which to filter. For example, if you choose the
     * destinationServer.osVersion filter name, you could specify Ubuntu
     * for the value.
     */
    val values: List<String>? = builder.values

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Filter = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Filter(")
        append("condition=$condition,")
        append("name=$name,")
        append("values=$values)")
    }

    override fun hashCode(): kotlin.Int {
        var result = condition?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (values?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Filter

        if (condition != other.condition) return false
        if (name != other.name) return false
        if (values != other.values) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Filter = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Filter
        /**
         * A conditional operator. The following operators are valid: EQUALS, NOT_EQUALS,
         * CONTAINS, NOT_CONTAINS. If you specify multiple filters, the system utilizes all filters as
         * though concatenated by AND. If you specify multiple values for a
         * particular filter, the system differentiates the values using OR. Calling
         * either DescribeConfigurations or ListConfigurations
         * returns attributes of matching configuration items.
         */
        fun condition(condition: String): FluentBuilder
        /**
         * The name of the filter.
         */
        fun name(name: String): FluentBuilder
        /**
         * A string value on which to filter. For example, if you choose the
         * destinationServer.osVersion filter name, you could specify Ubuntu
         * for the value.
         */
        fun values(values: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A conditional operator. The following operators are valid: EQUALS, NOT_EQUALS,
         * CONTAINS, NOT_CONTAINS. If you specify multiple filters, the system utilizes all filters as
         * though concatenated by AND. If you specify multiple values for a
         * particular filter, the system differentiates the values using OR. Calling
         * either DescribeConfigurations or ListConfigurations
         * returns attributes of matching configuration items.
         */
        var condition: String?
        /**
         * The name of the filter.
         */
        var name: String?
        /**
         * A string value on which to filter. For example, if you choose the
         * destinationServer.osVersion filter name, you could specify Ubuntu
         * for the value.
         */
        var values: List<String>?

        fun build(): Filter
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var condition: String? = null
        override var name: String? = null
        override var values: List<String>? = null

        constructor(x: Filter) : this() {
            this.condition = x.condition
            this.name = x.name
            this.values = x.values
        }

        override fun build(): Filter = Filter(this)
        override fun condition(condition: String): FluentBuilder = apply { this.condition = condition }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun values(values: List<String>): FluentBuilder = apply { this.values = values }
    }
}
