// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationdiscoveryservice.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Tags for a configuration item. Tags are metadata that help you categorize IT
 * assets.
 */
class ConfigurationTag private constructor(builder: BuilderImpl) {
    /**
     * The configuration ID for the item to tag. You can specify a list of keys and
     * values.
     */
    val configurationId: String? = builder.configurationId
    /**
     * A type of IT asset to tag.
     */
    val configurationType: ConfigurationItemType? = builder.configurationType
    /**
     * A type of tag on which to filter. For example,
     * serverType.
     */
    val key: String? = builder.key
    /**
     * The time the configuration tag was created in Coordinated Universal Time
     * (UTC).
     */
    val timeOfCreation: Instant? = builder.timeOfCreation
    /**
     * A value on which to filter. For example key = serverType and
     * value = web server.
     */
    val value: String? = builder.value

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ConfigurationTag = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ConfigurationTag(")
        append("configurationId=$configurationId,")
        append("configurationType=$configurationType,")
        append("key=$key,")
        append("timeOfCreation=$timeOfCreation,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = configurationId?.hashCode() ?: 0
        result = 31 * result + (configurationType?.hashCode() ?: 0)
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (timeOfCreation?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ConfigurationTag

        if (configurationId != other.configurationId) return false
        if (configurationType != other.configurationType) return false
        if (key != other.key) return false
        if (timeOfCreation != other.timeOfCreation) return false
        if (value != other.value) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ConfigurationTag = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ConfigurationTag
        /**
         * The configuration ID for the item to tag. You can specify a list of keys and
         * values.
         */
        fun configurationId(configurationId: String): FluentBuilder
        /**
         * A type of IT asset to tag.
         */
        fun configurationType(configurationType: ConfigurationItemType): FluentBuilder
        /**
         * A type of tag on which to filter. For example,
         * serverType.
         */
        fun key(key: String): FluentBuilder
        /**
         * The time the configuration tag was created in Coordinated Universal Time
         * (UTC).
         */
        fun timeOfCreation(timeOfCreation: Instant): FluentBuilder
        /**
         * A value on which to filter. For example key = serverType and
         * value = web server.
         */
        fun value(value: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The configuration ID for the item to tag. You can specify a list of keys and
         * values.
         */
        var configurationId: String?
        /**
         * A type of IT asset to tag.
         */
        var configurationType: ConfigurationItemType?
        /**
         * A type of tag on which to filter. For example,
         * serverType.
         */
        var key: String?
        /**
         * The time the configuration tag was created in Coordinated Universal Time
         * (UTC).
         */
        var timeOfCreation: Instant?
        /**
         * A value on which to filter. For example key = serverType and
         * value = web server.
         */
        var value: String?

        fun build(): ConfigurationTag
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var configurationId: String? = null
        override var configurationType: ConfigurationItemType? = null
        override var key: String? = null
        override var timeOfCreation: Instant? = null
        override var value: String? = null

        constructor(x: ConfigurationTag) : this() {
            this.configurationId = x.configurationId
            this.configurationType = x.configurationType
            this.key = x.key
            this.timeOfCreation = x.timeOfCreation
            this.value = x.value
        }

        override fun build(): ConfigurationTag = ConfigurationTag(this)
        override fun configurationId(configurationId: String): FluentBuilder = apply { this.configurationId = configurationId }
        override fun configurationType(configurationType: ConfigurationItemType): FluentBuilder = apply { this.configurationType = configurationType }
        override fun key(key: String): FluentBuilder = apply { this.key = key }
        override fun timeOfCreation(timeOfCreation: Instant): FluentBuilder = apply { this.timeOfCreation = timeOfCreation }
        override fun value(value: String): FluentBuilder = apply { this.value = value }
    }
}
