// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationdiscoveryservice

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.client.AwsClientConfig
import aws.sdk.kotlin.runtime.config.AwsClientConfigLoadOptions
import aws.sdk.kotlin.runtime.config.fromEnvironment
import aws.sdk.kotlin.runtime.endpoint.EndpointResolver
import aws.sdk.kotlin.services.applicationdiscoveryservice.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * <fullname>AWS Application Discovery Service</fullname>
 * AWS Application Discovery Service helps you plan application migration projects. It
 * automatically identifies servers, virtual machines (VMs), and network dependencies in your
 * on-premises data centers. For more information, see the <a href="http://aws.amazon.com/application-discovery/faqs/">AWS Application Discovery Service
 * FAQ. Application Discovery Service offers three ways of performing discovery and
 * collecting data about your on-premises servers:
 * Agentless discovery is recommended for environments
 * that use VMware vCenter Server. This mode doesn't require you to install an agent on each
 * host. It does not work in non-VMware environments.
 * Agentless discovery gathers server information regardless of the operating
 * systems, which minimizes the time required for initial on-premises infrastructure
 * assessment.
 * Agentless discovery doesn't collect information about network dependencies, only
 * agent-based discovery collects that information.
 * Agent-based discovery collects a richer set of data
 * than agentless discovery by using the AWS Application Discovery Agent, which you install
 * on one or more hosts in your data center.
 * The agent captures infrastructure and application information, including an
 * inventory of running processes, system performance information, resource utilization,
 * and network dependencies.
 * The information collected by agents is secured at rest and in transit to the
 * Application Discovery Service database in the cloud.
 * AWS Partner Network (APN) solutions integrate with
 * Application Discovery Service, enabling you to import details of your on-premises
 * environment directly into Migration Hub without using the discovery connector or discovery
 * agent.
 * Third-party application discovery tools can query AWS Application Discovery
 * Service, and they can write to the Application Discovery Service database using the
 * public API.
 * In this way, you can import data into Migration Hub and view it, so that you can
 * associate applications with servers and track migrations.
 * Recommendations
 * We recommend that you use agent-based discovery for non-VMware environments, and
 * whenever you want to collect information about network dependencies. You can run agent-based
 * and agentless discovery simultaneously. Use agentless discovery to complete the initial
 * infrastructure assessment quickly, and then install agents on select hosts to collect
 * additional information.
 * Working With This Guide
 * This API reference provides descriptions, syntax, and usage examples for each of the
 * actions and data types for Application Discovery Service. The topic for each action shows the
 * API request parameters and the response. Alternatively, you can use one of the AWS SDKs to
 * access an API that is tailored to the programming language or platform that you're using. For
 * more information, see <a href="http://aws.amazon.com/tools/#SDKs">AWS
 * SDKs.
 * Remember that you must set your Migration Hub home region before you call any of
 * these APIs.
 * You must make API calls for write actions (create, notify, associate, disassociate,
 * import, or put) while in your home region, or a HomeRegionNotSetException
 * error is returned.
 * API calls for read actions (list, describe, stop, and delete) are permitted outside
 * of your home region.
 * Although it is unlikely, the Migration Hub home region could change. If you call
 * APIs outside the home region, an InvalidInputException is returned.
 * You must call GetHomeRegion to obtain the latest Migration Hub home
 * region.
 * This guide is intended for use with the <a href="http://docs.aws.amazon.com/application-discovery/latest/userguide/">AWS Application
 * Discovery Service User Guide.
 * All data is handled according to the <a href="http://aws.amazon.com/privacy/">AWS
 * Privacy Policy. You can operate Application Discovery Service offline to inspect
 * collected data before it is shared with the service.
 */
interface ApplicationDiscoveryClient : SdkClient {

    override val serviceName: String
        get() = "Application Discovery Service"
    /**
     * ApplicationDiscoveryClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(sharedConfig: AwsClientConfig? = null, block: Config.DslBuilder.() -> Unit = {}): ApplicationDiscoveryClient {
            val config = Config.BuilderImpl().apply {
                region = sharedConfig?.region
                credentialsProvider = sharedConfig?.credentialsProvider
            }.apply(block).build()
            return DefaultApplicationDiscoveryClient(config)
        }

        operator fun invoke(config: Config): ApplicationDiscoveryClient = DefaultApplicationDiscoveryClient(config)

        /**
         * Construct a [ApplicationDiscoveryClient] by resolving the configuration from the current environment.
         * NOTE: If you are using multiple AWS service clients you may wish to share the configuration among them
         * by constructing a [aws.sdk.kotlin.runtime.client.AwsClientConfig] and passing it to each client at construction.
         */
        suspend fun fromEnvironment(block: AwsClientConfigLoadOptions.() -> Unit = {}): ApplicationDiscoveryClient {
            val sharedConfig = AwsClientConfig.fromEnvironment(block)
            return ApplicationDiscoveryClient(sharedConfig)
        }
    }

    class Config private constructor(builder: BuilderImpl): AwsClientConfig, HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider()
        val endpointResolver: EndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            @JvmStatic
            fun fluentBuilder(): FluentBuilder = BuilderImpl()

            operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Config = BuilderImpl().apply(block).build()
        }

        interface FluentBuilder {
            fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder
            fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder
            fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder
            fun idempotencyTokenProvider(idempotencyTokenProvider: IdempotencyTokenProvider): FluentBuilder
            fun region(region: String): FluentBuilder
            fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder
            fun build(): Config
        }

        interface DslBuilder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider?

            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: EndpointResolver?

            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine?

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider?

            /**
             * AWS region to make requests to
             */
            var region: String?

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode

        }

        internal class BuilderImpl() : FluentBuilder, DslBuilder {
            override var credentialsProvider: CredentialsProvider? = null
            override var endpointResolver: EndpointResolver? = null
            override var httpClientEngine: HttpClientEngine? = null
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            override var region: String? = null
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default

            override fun build(): Config = Config(this)
            override fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder = apply { this.credentialsProvider = credentialsProvider }
            override fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder = apply { this.endpointResolver = endpointResolver }
            override fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder = apply { this.httpClientEngine = httpClientEngine }
            override fun idempotencyTokenProvider(idempotencyTokenProvider: IdempotencyTokenProvider): FluentBuilder = apply { this.idempotencyTokenProvider = idempotencyTokenProvider }
            override fun region(region: String): FluentBuilder = apply { this.region = region }
            override fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder = apply { this.sdkLogMode = sdkLogMode }
        }
    }

    /**
     * Associates one or more configuration items with an application.
     */
    suspend fun associateConfigurationItemsToApplication(input: AssociateConfigurationItemsToApplicationRequest): AssociateConfigurationItemsToApplicationResponse

    /**
     * Associates one or more configuration items with an application.
     */
    suspend fun associateConfigurationItemsToApplication(block: AssociateConfigurationItemsToApplicationRequest.DslBuilder.() -> Unit) = associateConfigurationItemsToApplication(AssociateConfigurationItemsToApplicationRequest.builder().apply(block).build())

    /**
     * Deletes one or more import tasks, each identified by their import ID. Each import task has
     * a number of records that can identify servers or applications.
     * AWS Application Discovery Service has built-in matching logic that will identify when
     * discovered servers match existing entries that you've previously discovered, the information
     * for the already-existing discovered server is updated. When you delete an import task that
     * contains records that were used to match, the information in those matched records that comes
     * from the deleted records will also be deleted.
     */
    suspend fun batchDeleteImportData(input: BatchDeleteImportDataRequest): BatchDeleteImportDataResponse

    /**
     * Deletes one or more import tasks, each identified by their import ID. Each import task has
     * a number of records that can identify servers or applications.
     * AWS Application Discovery Service has built-in matching logic that will identify when
     * discovered servers match existing entries that you've previously discovered, the information
     * for the already-existing discovered server is updated. When you delete an import task that
     * contains records that were used to match, the information in those matched records that comes
     * from the deleted records will also be deleted.
     */
    suspend fun batchDeleteImportData(block: BatchDeleteImportDataRequest.DslBuilder.() -> Unit) = batchDeleteImportData(BatchDeleteImportDataRequest.builder().apply(block).build())

    /**
     * Creates an application with the given name and description.
     */
    suspend fun createApplication(input: CreateApplicationRequest): CreateApplicationResponse

    /**
     * Creates an application with the given name and description.
     */
    suspend fun createApplication(block: CreateApplicationRequest.DslBuilder.() -> Unit) = createApplication(CreateApplicationRequest.builder().apply(block).build())

    /**
     * Creates one or more tags for configuration items. Tags are metadata that help you
     * categorize IT assets. This API accepts a list of multiple configuration items.
     */
    suspend fun createTags(input: CreateTagsRequest): CreateTagsResponse

    /**
     * Creates one or more tags for configuration items. Tags are metadata that help you
     * categorize IT assets. This API accepts a list of multiple configuration items.
     */
    suspend fun createTags(block: CreateTagsRequest.DslBuilder.() -> Unit) = createTags(CreateTagsRequest.builder().apply(block).build())

    /**
     * Deletes a list of applications and their associations with configuration
     * items.
     */
    suspend fun deleteApplications(input: DeleteApplicationsRequest): DeleteApplicationsResponse

    /**
     * Deletes a list of applications and their associations with configuration
     * items.
     */
    suspend fun deleteApplications(block: DeleteApplicationsRequest.DslBuilder.() -> Unit) = deleteApplications(DeleteApplicationsRequest.builder().apply(block).build())

    /**
     * Deletes the association between configuration items and one or more tags. This API
     * accepts a list of multiple configuration items.
     */
    suspend fun deleteTags(input: DeleteTagsRequest): DeleteTagsResponse

    /**
     * Deletes the association between configuration items and one or more tags. This API
     * accepts a list of multiple configuration items.
     */
    suspend fun deleteTags(block: DeleteTagsRequest.DslBuilder.() -> Unit) = deleteTags(DeleteTagsRequest.builder().apply(block).build())

    /**
     * Lists agents or connectors as specified by ID or other filters. All agents/connectors
     * associated with your user account can be listed if you call DescribeAgents as is
     * without passing any parameters.
     */
    suspend fun describeAgents(input: DescribeAgentsRequest): DescribeAgentsResponse

    /**
     * Lists agents or connectors as specified by ID or other filters. All agents/connectors
     * associated with your user account can be listed if you call DescribeAgents as is
     * without passing any parameters.
     */
    suspend fun describeAgents(block: DescribeAgentsRequest.DslBuilder.() -> Unit) = describeAgents(DescribeAgentsRequest.builder().apply(block).build())

    /**
     * Retrieves attributes for a list of configuration item IDs.
     * All of the supplied IDs must be for the same asset type from one of the
     * following:
     * server
     * application
     * process
     * connection
     * Output fields are specific to the asset type specified. For example, the output for a
     * server configuration item includes a list of attributes about the
     * server, such as host name, operating system, number of network cards, etc.
     * For a complete list of outputs for each asset type, see <a href="https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#DescribeConfigurations">Using the DescribeConfigurations Action in the AWS Application
     * Discovery Service User Guide.
     */
    suspend fun describeConfigurations(input: DescribeConfigurationsRequest): DescribeConfigurationsResponse

    /**
     * Retrieves attributes for a list of configuration item IDs.
     * All of the supplied IDs must be for the same asset type from one of the
     * following:
     * server
     * application
     * process
     * connection
     * Output fields are specific to the asset type specified. For example, the output for a
     * server configuration item includes a list of attributes about the
     * server, such as host name, operating system, number of network cards, etc.
     * For a complete list of outputs for each asset type, see <a href="https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#DescribeConfigurations">Using the DescribeConfigurations Action in the AWS Application
     * Discovery Service User Guide.
     */
    suspend fun describeConfigurations(block: DescribeConfigurationsRequest.DslBuilder.() -> Unit) = describeConfigurations(DescribeConfigurationsRequest.builder().apply(block).build())

    /**
     * Lists exports as specified by ID. All continuous exports associated with your user
     * account can be listed if you call DescribeContinuousExports as is without passing
     * any parameters.
     */
    suspend fun describeContinuousExports(input: DescribeContinuousExportsRequest): DescribeContinuousExportsResponse

    /**
     * Lists exports as specified by ID. All continuous exports associated with your user
     * account can be listed if you call DescribeContinuousExports as is without passing
     * any parameters.
     */
    suspend fun describeContinuousExports(block: DescribeContinuousExportsRequest.DslBuilder.() -> Unit) = describeContinuousExports(DescribeContinuousExportsRequest.builder().apply(block).build())

    /**
     * DescribeExportConfigurations is deprecated. Use <a href="https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeExportTasks.html">DescribeImportTasks, instead.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun describeExportConfigurations(input: DescribeExportConfigurationsRequest): DescribeExportConfigurationsResponse

    /**
     * DescribeExportConfigurations is deprecated. Use <a href="https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeExportTasks.html">DescribeImportTasks, instead.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun describeExportConfigurations(block: DescribeExportConfigurationsRequest.DslBuilder.() -> Unit) = describeExportConfigurations(DescribeExportConfigurationsRequest.builder().apply(block).build())

    /**
     * Retrieve status of one or more export tasks. You can retrieve the status of up to 100
     * export tasks.
     */
    suspend fun describeExportTasks(input: DescribeExportTasksRequest): DescribeExportTasksResponse

    /**
     * Retrieve status of one or more export tasks. You can retrieve the status of up to 100
     * export tasks.
     */
    suspend fun describeExportTasks(block: DescribeExportTasksRequest.DslBuilder.() -> Unit) = describeExportTasks(DescribeExportTasksRequest.builder().apply(block).build())

    /**
     * Returns an array of import tasks for your account, including status information, times,
     * IDs, the Amazon S3 Object URL for the import file, and more.
     */
    suspend fun describeImportTasks(input: DescribeImportTasksRequest): DescribeImportTasksResponse

    /**
     * Returns an array of import tasks for your account, including status information, times,
     * IDs, the Amazon S3 Object URL for the import file, and more.
     */
    suspend fun describeImportTasks(block: DescribeImportTasksRequest.DslBuilder.() -> Unit) = describeImportTasks(DescribeImportTasksRequest.builder().apply(block).build())

    /**
     * Retrieves a list of configuration items that have tags as specified by the key-value
     * pairs, name and value, passed to the optional parameter filters.
     * There are three valid tag filter names:
     * tagKey
     * tagValue
     * configurationId
     * Also, all configuration items associated with your user account that have tags can be
     * listed if you call DescribeTags as is without passing any parameters.
     */
    suspend fun describeTags(input: DescribeTagsRequest): DescribeTagsResponse

    /**
     * Retrieves a list of configuration items that have tags as specified by the key-value
     * pairs, name and value, passed to the optional parameter filters.
     * There are three valid tag filter names:
     * tagKey
     * tagValue
     * configurationId
     * Also, all configuration items associated with your user account that have tags can be
     * listed if you call DescribeTags as is without passing any parameters.
     */
    suspend fun describeTags(block: DescribeTagsRequest.DslBuilder.() -> Unit) = describeTags(DescribeTagsRequest.builder().apply(block).build())

    /**
     * Disassociates one or more configuration items from an application.
     */
    suspend fun disassociateConfigurationItemsFromApplication(input: DisassociateConfigurationItemsFromApplicationRequest): DisassociateConfigurationItemsFromApplicationResponse

    /**
     * Disassociates one or more configuration items from an application.
     */
    suspend fun disassociateConfigurationItemsFromApplication(block: DisassociateConfigurationItemsFromApplicationRequest.DslBuilder.() -> Unit) = disassociateConfigurationItemsFromApplication(DisassociateConfigurationItemsFromApplicationRequest.builder().apply(block).build())

    /**
     * Deprecated. Use StartExportTask instead.
     * Exports all discovered configuration data to an Amazon S3 bucket or an application that
     * enables you to view and evaluate the data. Data includes tags and tag associations, processes,
     * connections, servers, and system performance. This API returns an export ID that you can query
     * using the DescribeExportConfigurations API. The system imposes a limit of
     * two configuration exports in six hours.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun exportConfigurations(input: ExportConfigurationsRequest): ExportConfigurationsResponse

    /**
     * Deprecated. Use StartExportTask instead.
     * Exports all discovered configuration data to an Amazon S3 bucket or an application that
     * enables you to view and evaluate the data. Data includes tags and tag associations, processes,
     * connections, servers, and system performance. This API returns an export ID that you can query
     * using the DescribeExportConfigurations API. The system imposes a limit of
     * two configuration exports in six hours.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun exportConfigurations(block: ExportConfigurationsRequest.DslBuilder.() -> Unit) = exportConfigurations(ExportConfigurationsRequest.builder().apply(block).build())

    /**
     * Retrieves a short summary of discovered assets.
     * This API operation takes no request parameters and is called as is at the command
     * prompt as shown in the example.
     */
    suspend fun getDiscoverySummary(input: GetDiscoverySummaryRequest): GetDiscoverySummaryResponse

    /**
     * Retrieves a short summary of discovered assets.
     * This API operation takes no request parameters and is called as is at the command
     * prompt as shown in the example.
     */
    suspend fun getDiscoverySummary(block: GetDiscoverySummaryRequest.DslBuilder.() -> Unit) = getDiscoverySummary(GetDiscoverySummaryRequest.builder().apply(block).build())

    /**
     * Retrieves a list of configuration items as specified by the value passed to the
     * required parameter configurationType. Optional filtering may be applied to refine
     * search results.
     */
    suspend fun listConfigurations(input: ListConfigurationsRequest): ListConfigurationsResponse

    /**
     * Retrieves a list of configuration items as specified by the value passed to the
     * required parameter configurationType. Optional filtering may be applied to refine
     * search results.
     */
    suspend fun listConfigurations(block: ListConfigurationsRequest.DslBuilder.() -> Unit) = listConfigurations(ListConfigurationsRequest.builder().apply(block).build())

    /**
     * Retrieves a list of servers that are one network hop away from a specified
     * server.
     */
    suspend fun listServerNeighbors(input: ListServerNeighborsRequest): ListServerNeighborsResponse

    /**
     * Retrieves a list of servers that are one network hop away from a specified
     * server.
     */
    suspend fun listServerNeighbors(block: ListServerNeighborsRequest.DslBuilder.() -> Unit) = listServerNeighbors(ListServerNeighborsRequest.builder().apply(block).build())

    /**
     * Start the continuous flow of agent's discovered data into Amazon Athena.
     */
    suspend fun startContinuousExport(input: StartContinuousExportRequest): StartContinuousExportResponse

    /**
     * Start the continuous flow of agent's discovered data into Amazon Athena.
     */
    suspend fun startContinuousExport(block: StartContinuousExportRequest.DslBuilder.() -> Unit) = startContinuousExport(StartContinuousExportRequest.builder().apply(block).build())

    /**
     * Instructs the specified agents or connectors to start collecting data.
     */
    suspend fun startDataCollectionByAgentIds(input: StartDataCollectionByAgentIdsRequest): StartDataCollectionByAgentIdsResponse

    /**
     * Instructs the specified agents or connectors to start collecting data.
     */
    suspend fun startDataCollectionByAgentIds(block: StartDataCollectionByAgentIdsRequest.DslBuilder.() -> Unit) = startDataCollectionByAgentIds(StartDataCollectionByAgentIdsRequest.builder().apply(block).build())

    /**
     * Begins the export of discovered data to an S3 bucket.
     * If you specify agentIds in a filter, the task exports up to 72 hours of
     * detailed data collected by the identified Application Discovery Agent, including network,
     * process, and performance details. A time range for exported agent data may be set by using
     * startTime and endTime. Export of detailed agent data is limited to
     * five concurrently running exports.
     * If you do not include an agentIds filter, summary data is exported that
     * includes both AWS Agentless Discovery Connector data and summary data from AWS Discovery
     * Agents. Export of summary data is limited to two exports per day.
     */
    suspend fun startExportTask(input: StartExportTaskRequest): StartExportTaskResponse

    /**
     * Begins the export of discovered data to an S3 bucket.
     * If you specify agentIds in a filter, the task exports up to 72 hours of
     * detailed data collected by the identified Application Discovery Agent, including network,
     * process, and performance details. A time range for exported agent data may be set by using
     * startTime and endTime. Export of detailed agent data is limited to
     * five concurrently running exports.
     * If you do not include an agentIds filter, summary data is exported that
     * includes both AWS Agentless Discovery Connector data and summary data from AWS Discovery
     * Agents. Export of summary data is limited to two exports per day.
     */
    suspend fun startExportTask(block: StartExportTaskRequest.DslBuilder.() -> Unit) = startExportTask(StartExportTaskRequest.builder().apply(block).build())

    /**
     * Starts an import task, which allows you to import details of your on-premises environment
     * directly into AWS Migration Hub without having to use the Application Discovery Service (ADS)
     * tools such as the Discovery Connector or Discovery Agent. This gives you the option to perform
     * migration assessment and planning directly from your imported data, including the ability to
     * group your devices as applications and track their migration status.
     * To start an import request, do this:
     * <ol>
     * Download the specially formatted comma separated value (CSV) import template, which
     * you can find here: <a href="https://s3-us-west-2.amazonaws.com/templates-7cffcf56-bd96-4b1c-b45b-a5b42f282e46/import_template.csv">https://s3-us-west-2.amazonaws.com/templates-7cffcf56-bd96-4b1c-b45b-a5b42f282e46/import_template.csv.
     * Fill out the template with your server and application data.
     * Upload your import file to an Amazon S3 bucket, and make a note of it's Object URL.
     * Your import file must be in the CSV format.
     * Use the console or the StartImportTask command with the AWS CLI or one of
     * the AWS SDKs to import the records from your file.
     * </ol>
     * For more information, including step-by-step procedures, see <a href="https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-import.html">Migration Hub
     * Import in the AWS Application Discovery Service User
     * Guide.
     * There are limits to the number of import tasks you can create (and delete) in an AWS
     * account. For more information, see <a href="https://docs.aws.amazon.com/application-discovery/latest/userguide/ads_service_limits.html">AWS Application
     * Discovery Service Limits in the AWS Application Discovery Service User
     * Guide.
     */
    suspend fun startImportTask(input: StartImportTaskRequest): StartImportTaskResponse

    /**
     * Starts an import task, which allows you to import details of your on-premises environment
     * directly into AWS Migration Hub without having to use the Application Discovery Service (ADS)
     * tools such as the Discovery Connector or Discovery Agent. This gives you the option to perform
     * migration assessment and planning directly from your imported data, including the ability to
     * group your devices as applications and track their migration status.
     * To start an import request, do this:
     * <ol>
     * Download the specially formatted comma separated value (CSV) import template, which
     * you can find here: <a href="https://s3-us-west-2.amazonaws.com/templates-7cffcf56-bd96-4b1c-b45b-a5b42f282e46/import_template.csv">https://s3-us-west-2.amazonaws.com/templates-7cffcf56-bd96-4b1c-b45b-a5b42f282e46/import_template.csv.
     * Fill out the template with your server and application data.
     * Upload your import file to an Amazon S3 bucket, and make a note of it's Object URL.
     * Your import file must be in the CSV format.
     * Use the console or the StartImportTask command with the AWS CLI or one of
     * the AWS SDKs to import the records from your file.
     * </ol>
     * For more information, including step-by-step procedures, see <a href="https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-import.html">Migration Hub
     * Import in the AWS Application Discovery Service User
     * Guide.
     * There are limits to the number of import tasks you can create (and delete) in an AWS
     * account. For more information, see <a href="https://docs.aws.amazon.com/application-discovery/latest/userguide/ads_service_limits.html">AWS Application
     * Discovery Service Limits in the AWS Application Discovery Service User
     * Guide.
     */
    suspend fun startImportTask(block: StartImportTaskRequest.DslBuilder.() -> Unit) = startImportTask(StartImportTaskRequest.builder().apply(block).build())

    /**
     * Stop the continuous flow of agent's discovered data into Amazon Athena.
     */
    suspend fun stopContinuousExport(input: StopContinuousExportRequest): StopContinuousExportResponse

    /**
     * Stop the continuous flow of agent's discovered data into Amazon Athena.
     */
    suspend fun stopContinuousExport(block: StopContinuousExportRequest.DslBuilder.() -> Unit) = stopContinuousExport(StopContinuousExportRequest.builder().apply(block).build())

    /**
     * Instructs the specified agents or connectors to stop collecting data.
     */
    suspend fun stopDataCollectionByAgentIds(input: StopDataCollectionByAgentIdsRequest): StopDataCollectionByAgentIdsResponse

    /**
     * Instructs the specified agents or connectors to stop collecting data.
     */
    suspend fun stopDataCollectionByAgentIds(block: StopDataCollectionByAgentIdsRequest.DslBuilder.() -> Unit) = stopDataCollectionByAgentIds(StopDataCollectionByAgentIdsRequest.builder().apply(block).build())

    /**
     * Updates metadata about an application.
     */
    suspend fun updateApplication(input: UpdateApplicationRequest): UpdateApplicationResponse

    /**
     * Updates metadata about an application.
     */
    suspend fun updateApplication(block: UpdateApplicationRequest.DslBuilder.() -> Unit) = updateApplication(UpdateApplicationRequest.builder().apply(block).build())
}
