// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationdiscoveryservice.model



/**
 * Information about agents or connectors associated with the user’s AWS account.
 * Information includes agent or connector IDs, IP addresses, media access control (MAC)
 * addresses, agent or connector health, hostname where the agent or connector resides, and agent
 * version for each agent.
 */
class AgentInfo private constructor(builder: BuilderImpl) {
    /**
     * The agent or connector ID.
     */
    val agentId: String? = builder.agentId
    /**
     * Network details about the host where the agent or connector resides.
     */
    val agentNetworkInfoList: List<AgentNetworkInfo>? = builder.agentNetworkInfoList
    /**
     * Type of agent.
     */
    val agentType: String? = builder.agentType
    /**
     * Status of the collection process for an agent or connector.
     */
    val collectionStatus: String? = builder.collectionStatus
    /**
     * The ID of the connector.
     */
    val connectorId: String? = builder.connectorId
    /**
     * The health of the agent or connector.
     */
    val health: AgentStatus? = builder.health
    /**
     * The name of the host where the agent or connector resides. The host can be a server or
     * virtual machine.
     */
    val hostName: String? = builder.hostName
    /**
     * Time since agent or connector health was reported.
     */
    val lastHealthPingTime: String? = builder.lastHealthPingTime
    /**
     * Agent's first registration timestamp in UTC.
     */
    val registeredTime: String? = builder.registeredTime
    /**
     * The agent or connector version.
     */
    val version: String? = builder.version

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AgentInfo = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AgentInfo(")
        append("agentId=$agentId,")
        append("agentNetworkInfoList=$agentNetworkInfoList,")
        append("agentType=$agentType,")
        append("collectionStatus=$collectionStatus,")
        append("connectorId=$connectorId,")
        append("health=$health,")
        append("hostName=$hostName,")
        append("lastHealthPingTime=$lastHealthPingTime,")
        append("registeredTime=$registeredTime,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = agentId?.hashCode() ?: 0
        result = 31 * result + (agentNetworkInfoList?.hashCode() ?: 0)
        result = 31 * result + (agentType?.hashCode() ?: 0)
        result = 31 * result + (collectionStatus?.hashCode() ?: 0)
        result = 31 * result + (connectorId?.hashCode() ?: 0)
        result = 31 * result + (health?.hashCode() ?: 0)
        result = 31 * result + (hostName?.hashCode() ?: 0)
        result = 31 * result + (lastHealthPingTime?.hashCode() ?: 0)
        result = 31 * result + (registeredTime?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AgentInfo

        if (agentId != other.agentId) return false
        if (agentNetworkInfoList != other.agentNetworkInfoList) return false
        if (agentType != other.agentType) return false
        if (collectionStatus != other.collectionStatus) return false
        if (connectorId != other.connectorId) return false
        if (health != other.health) return false
        if (hostName != other.hostName) return false
        if (lastHealthPingTime != other.lastHealthPingTime) return false
        if (registeredTime != other.registeredTime) return false
        if (version != other.version) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AgentInfo = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AgentInfo
        /**
         * The agent or connector ID.
         */
        fun agentId(agentId: String): FluentBuilder
        /**
         * Network details about the host where the agent or connector resides.
         */
        fun agentNetworkInfoList(agentNetworkInfoList: List<AgentNetworkInfo>): FluentBuilder
        /**
         * Type of agent.
         */
        fun agentType(agentType: String): FluentBuilder
        /**
         * Status of the collection process for an agent or connector.
         */
        fun collectionStatus(collectionStatus: String): FluentBuilder
        /**
         * The ID of the connector.
         */
        fun connectorId(connectorId: String): FluentBuilder
        /**
         * The health of the agent or connector.
         */
        fun health(health: AgentStatus): FluentBuilder
        /**
         * The name of the host where the agent or connector resides. The host can be a server or
         * virtual machine.
         */
        fun hostName(hostName: String): FluentBuilder
        /**
         * Time since agent or connector health was reported.
         */
        fun lastHealthPingTime(lastHealthPingTime: String): FluentBuilder
        /**
         * Agent's first registration timestamp in UTC.
         */
        fun registeredTime(registeredTime: String): FluentBuilder
        /**
         * The agent or connector version.
         */
        fun version(version: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The agent or connector ID.
         */
        var agentId: String?
        /**
         * Network details about the host where the agent or connector resides.
         */
        var agentNetworkInfoList: List<AgentNetworkInfo>?
        /**
         * Type of agent.
         */
        var agentType: String?
        /**
         * Status of the collection process for an agent or connector.
         */
        var collectionStatus: String?
        /**
         * The ID of the connector.
         */
        var connectorId: String?
        /**
         * The health of the agent or connector.
         */
        var health: AgentStatus?
        /**
         * The name of the host where the agent or connector resides. The host can be a server or
         * virtual machine.
         */
        var hostName: String?
        /**
         * Time since agent or connector health was reported.
         */
        var lastHealthPingTime: String?
        /**
         * Agent's first registration timestamp in UTC.
         */
        var registeredTime: String?
        /**
         * The agent or connector version.
         */
        var version: String?

        fun build(): AgentInfo
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var agentId: String? = null
        override var agentNetworkInfoList: List<AgentNetworkInfo>? = null
        override var agentType: String? = null
        override var collectionStatus: String? = null
        override var connectorId: String? = null
        override var health: AgentStatus? = null
        override var hostName: String? = null
        override var lastHealthPingTime: String? = null
        override var registeredTime: String? = null
        override var version: String? = null

        constructor(x: AgentInfo) : this() {
            this.agentId = x.agentId
            this.agentNetworkInfoList = x.agentNetworkInfoList
            this.agentType = x.agentType
            this.collectionStatus = x.collectionStatus
            this.connectorId = x.connectorId
            this.health = x.health
            this.hostName = x.hostName
            this.lastHealthPingTime = x.lastHealthPingTime
            this.registeredTime = x.registeredTime
            this.version = x.version
        }

        override fun build(): AgentInfo = AgentInfo(this)
        override fun agentId(agentId: String): FluentBuilder = apply { this.agentId = agentId }
        override fun agentNetworkInfoList(agentNetworkInfoList: List<AgentNetworkInfo>): FluentBuilder = apply { this.agentNetworkInfoList = agentNetworkInfoList }
        override fun agentType(agentType: String): FluentBuilder = apply { this.agentType = agentType }
        override fun collectionStatus(collectionStatus: String): FluentBuilder = apply { this.collectionStatus = collectionStatus }
        override fun connectorId(connectorId: String): FluentBuilder = apply { this.connectorId = connectorId }
        override fun health(health: AgentStatus): FluentBuilder = apply { this.health = health }
        override fun hostName(hostName: String): FluentBuilder = apply { this.hostName = hostName }
        override fun lastHealthPingTime(lastHealthPingTime: String): FluentBuilder = apply { this.lastHealthPingTime = lastHealthPingTime }
        override fun registeredTime(registeredTime: String): FluentBuilder = apply { this.registeredTime = registeredTime }
        override fun version(version: String): FluentBuilder = apply { this.version = version }
    }
}
