// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationdiscoveryservice.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A list of continuous export descriptions.
 */
class ContinuousExportDescription private constructor(builder: BuilderImpl) {
    /**
     * The type of data collector used to gather this data (currently only offered for
     * AGENT).
     */
    val dataSource: DataSource? = builder.dataSource
    /**
     * The unique ID assigned to this export.
     */
    val exportId: String? = builder.exportId
    /**
     * The name of the s3 bucket where the export data parquet files are stored.
     */
    val s3Bucket: String? = builder.s3Bucket
    /**
     * An object which describes how the data is stored.
     * databaseName - the name of the Glue database used to store the
     * schema.
     */
    val schemaStorageConfig: Map<String, String>? = builder.schemaStorageConfig
    /**
     * The timestamp representing when the continuous export was started.
     */
    val startTime: Instant? = builder.startTime
    /**
     * Describes the status of the export. Can be one of the following values:
     * START_IN_PROGRESS - setting up resources to start continuous export.
     * START_FAILED - an error occurred setting up continuous export. To recover, call
     * start-continuous-export again.
     * ACTIVE - data is being exported to the customer bucket.
     * ERROR - an error occurred during export. To fix the issue, call
     * stop-continuous-export and start-continuous-export.
     * STOP_IN_PROGRESS - stopping the export.
     * STOP_FAILED - an error occurred stopping the export. To recover, call
     * stop-continuous-export again.
     * INACTIVE - the continuous export has been stopped. Data is no longer being exported
     * to the customer bucket.
     */
    val status: ContinuousExportStatus? = builder.status
    /**
     * Contains information about any errors that have occurred. This data type can have the
     * following values:
     * ACCESS_DENIED - You don’t have permission to start Data Exploration in Amazon
     * Athena. Contact your AWS administrator for help. For more information, see <a href="http://docs.aws.amazon.com/application-discovery/latest/userguide/setting-up.html">Setting Up AWS Application Discovery Service in the Application Discovery
     * Service User Guide.
     * DELIVERY_STREAM_LIMIT_FAILURE - You reached the limit for Amazon Kinesis Data
     * Firehose delivery streams. Reduce the number of streams or request a limit increase and
     * try again. For more information, see <a href="http://docs.aws.amazon.com/streams/latest/dev/service-sizes-and-limits.html">Kinesis Data Streams Limits in the Amazon Kinesis Data Streams Developer
     * Guide.
     * FIREHOSE_ROLE_MISSING - The Data Exploration feature is in an error state because
     * your IAM User is missing the AWSApplicationDiscoveryServiceFirehose role. Turn on Data
     * Exploration in Amazon Athena and try again. For more information, see <a href="http://docs.aws.amazon.com/application-discovery/latest/userguide/setting-up.html#setting-up-user-policy">Step 3: Provide Application Discovery Service Access to Non-Administrator Users by
     * Attaching Policies in the Application Discovery Service User Guide.
     * FIREHOSE_STREAM_DOES_NOT_EXIST - The Data Exploration feature is in an error state
     * because your IAM User is missing one or more of the Kinesis data delivery
     * streams.
     * INTERNAL_FAILURE - The Data Exploration feature is in an error state because of an
     * internal failure. Try again later. If this problem persists, contact AWS
     * Support.
     * S3_BUCKET_LIMIT_FAILURE - You reached the limit for Amazon S3 buckets. Reduce the
     * number of Amazon S3 buckets or request a limit increase and try again. For more
     * information, see <a href="http://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html">Bucket
     * Restrictions and Limitations in the Amazon Simple Storage Service Developer
     * Guide.
     * S3_NOT_SIGNED_UP - Your account is not signed up for the Amazon S3 service. You
     * must sign up before you can use Amazon S3. You can sign up at the following URL: <a href="https://aws.amazon.com/s3">https://aws.amazon.com/s3.
     */
    val statusDetail: String? = builder.statusDetail
    /**
     * The timestamp that represents when this continuous export was stopped.
     */
    val stopTime: Instant? = builder.stopTime

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ContinuousExportDescription = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ContinuousExportDescription(")
        append("dataSource=$dataSource,")
        append("exportId=$exportId,")
        append("s3Bucket=$s3Bucket,")
        append("schemaStorageConfig=$schemaStorageConfig,")
        append("startTime=$startTime,")
        append("status=$status,")
        append("statusDetail=$statusDetail,")
        append("stopTime=$stopTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataSource?.hashCode() ?: 0
        result = 31 * result + (exportId?.hashCode() ?: 0)
        result = 31 * result + (s3Bucket?.hashCode() ?: 0)
        result = 31 * result + (schemaStorageConfig?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusDetail?.hashCode() ?: 0)
        result = 31 * result + (stopTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ContinuousExportDescription

        if (dataSource != other.dataSource) return false
        if (exportId != other.exportId) return false
        if (s3Bucket != other.s3Bucket) return false
        if (schemaStorageConfig != other.schemaStorageConfig) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false
        if (statusDetail != other.statusDetail) return false
        if (stopTime != other.stopTime) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ContinuousExportDescription = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ContinuousExportDescription
        /**
         * The type of data collector used to gather this data (currently only offered for
         * AGENT).
         */
        fun dataSource(dataSource: DataSource): FluentBuilder
        /**
         * The unique ID assigned to this export.
         */
        fun exportId(exportId: String): FluentBuilder
        /**
         * The name of the s3 bucket where the export data parquet files are stored.
         */
        fun s3Bucket(s3Bucket: String): FluentBuilder
        /**
         * An object which describes how the data is stored.
         * databaseName - the name of the Glue database used to store the
         * schema.
         */
        fun schemaStorageConfig(schemaStorageConfig: Map<String, String>): FluentBuilder
        /**
         * The timestamp representing when the continuous export was started.
         */
        fun startTime(startTime: Instant): FluentBuilder
        /**
         * Describes the status of the export. Can be one of the following values:
         * START_IN_PROGRESS - setting up resources to start continuous export.
         * START_FAILED - an error occurred setting up continuous export. To recover, call
         * start-continuous-export again.
         * ACTIVE - data is being exported to the customer bucket.
         * ERROR - an error occurred during export. To fix the issue, call
         * stop-continuous-export and start-continuous-export.
         * STOP_IN_PROGRESS - stopping the export.
         * STOP_FAILED - an error occurred stopping the export. To recover, call
         * stop-continuous-export again.
         * INACTIVE - the continuous export has been stopped. Data is no longer being exported
         * to the customer bucket.
         */
        fun status(status: ContinuousExportStatus): FluentBuilder
        /**
         * Contains information about any errors that have occurred. This data type can have the
         * following values:
         * ACCESS_DENIED - You don’t have permission to start Data Exploration in Amazon
         * Athena. Contact your AWS administrator for help. For more information, see <a href="http://docs.aws.amazon.com/application-discovery/latest/userguide/setting-up.html">Setting Up AWS Application Discovery Service in the Application Discovery
         * Service User Guide.
         * DELIVERY_STREAM_LIMIT_FAILURE - You reached the limit for Amazon Kinesis Data
         * Firehose delivery streams. Reduce the number of streams or request a limit increase and
         * try again. For more information, see <a href="http://docs.aws.amazon.com/streams/latest/dev/service-sizes-and-limits.html">Kinesis Data Streams Limits in the Amazon Kinesis Data Streams Developer
         * Guide.
         * FIREHOSE_ROLE_MISSING - The Data Exploration feature is in an error state because
         * your IAM User is missing the AWSApplicationDiscoveryServiceFirehose role. Turn on Data
         * Exploration in Amazon Athena and try again. For more information, see <a href="http://docs.aws.amazon.com/application-discovery/latest/userguide/setting-up.html#setting-up-user-policy">Step 3: Provide Application Discovery Service Access to Non-Administrator Users by
         * Attaching Policies in the Application Discovery Service User Guide.
         * FIREHOSE_STREAM_DOES_NOT_EXIST - The Data Exploration feature is in an error state
         * because your IAM User is missing one or more of the Kinesis data delivery
         * streams.
         * INTERNAL_FAILURE - The Data Exploration feature is in an error state because of an
         * internal failure. Try again later. If this problem persists, contact AWS
         * Support.
         * S3_BUCKET_LIMIT_FAILURE - You reached the limit for Amazon S3 buckets. Reduce the
         * number of Amazon S3 buckets or request a limit increase and try again. For more
         * information, see <a href="http://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html">Bucket
         * Restrictions and Limitations in the Amazon Simple Storage Service Developer
         * Guide.
         * S3_NOT_SIGNED_UP - Your account is not signed up for the Amazon S3 service. You
         * must sign up before you can use Amazon S3. You can sign up at the following URL: <a href="https://aws.amazon.com/s3">https://aws.amazon.com/s3.
         */
        fun statusDetail(statusDetail: String): FluentBuilder
        /**
         * The timestamp that represents when this continuous export was stopped.
         */
        fun stopTime(stopTime: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The type of data collector used to gather this data (currently only offered for
         * AGENT).
         */
        var dataSource: DataSource?
        /**
         * The unique ID assigned to this export.
         */
        var exportId: String?
        /**
         * The name of the s3 bucket where the export data parquet files are stored.
         */
        var s3Bucket: String?
        /**
         * An object which describes how the data is stored.
         * databaseName - the name of the Glue database used to store the
         * schema.
         */
        var schemaStorageConfig: Map<String, String>?
        /**
         * The timestamp representing when the continuous export was started.
         */
        var startTime: Instant?
        /**
         * Describes the status of the export. Can be one of the following values:
         * START_IN_PROGRESS - setting up resources to start continuous export.
         * START_FAILED - an error occurred setting up continuous export. To recover, call
         * start-continuous-export again.
         * ACTIVE - data is being exported to the customer bucket.
         * ERROR - an error occurred during export. To fix the issue, call
         * stop-continuous-export and start-continuous-export.
         * STOP_IN_PROGRESS - stopping the export.
         * STOP_FAILED - an error occurred stopping the export. To recover, call
         * stop-continuous-export again.
         * INACTIVE - the continuous export has been stopped. Data is no longer being exported
         * to the customer bucket.
         */
        var status: ContinuousExportStatus?
        /**
         * Contains information about any errors that have occurred. This data type can have the
         * following values:
         * ACCESS_DENIED - You don’t have permission to start Data Exploration in Amazon
         * Athena. Contact your AWS administrator for help. For more information, see <a href="http://docs.aws.amazon.com/application-discovery/latest/userguide/setting-up.html">Setting Up AWS Application Discovery Service in the Application Discovery
         * Service User Guide.
         * DELIVERY_STREAM_LIMIT_FAILURE - You reached the limit for Amazon Kinesis Data
         * Firehose delivery streams. Reduce the number of streams or request a limit increase and
         * try again. For more information, see <a href="http://docs.aws.amazon.com/streams/latest/dev/service-sizes-and-limits.html">Kinesis Data Streams Limits in the Amazon Kinesis Data Streams Developer
         * Guide.
         * FIREHOSE_ROLE_MISSING - The Data Exploration feature is in an error state because
         * your IAM User is missing the AWSApplicationDiscoveryServiceFirehose role. Turn on Data
         * Exploration in Amazon Athena and try again. For more information, see <a href="http://docs.aws.amazon.com/application-discovery/latest/userguide/setting-up.html#setting-up-user-policy">Step 3: Provide Application Discovery Service Access to Non-Administrator Users by
         * Attaching Policies in the Application Discovery Service User Guide.
         * FIREHOSE_STREAM_DOES_NOT_EXIST - The Data Exploration feature is in an error state
         * because your IAM User is missing one or more of the Kinesis data delivery
         * streams.
         * INTERNAL_FAILURE - The Data Exploration feature is in an error state because of an
         * internal failure. Try again later. If this problem persists, contact AWS
         * Support.
         * S3_BUCKET_LIMIT_FAILURE - You reached the limit for Amazon S3 buckets. Reduce the
         * number of Amazon S3 buckets or request a limit increase and try again. For more
         * information, see <a href="http://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html">Bucket
         * Restrictions and Limitations in the Amazon Simple Storage Service Developer
         * Guide.
         * S3_NOT_SIGNED_UP - Your account is not signed up for the Amazon S3 service. You
         * must sign up before you can use Amazon S3. You can sign up at the following URL: <a href="https://aws.amazon.com/s3">https://aws.amazon.com/s3.
         */
        var statusDetail: String?
        /**
         * The timestamp that represents when this continuous export was stopped.
         */
        var stopTime: Instant?

        fun build(): ContinuousExportDescription
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dataSource: DataSource? = null
        override var exportId: String? = null
        override var s3Bucket: String? = null
        override var schemaStorageConfig: Map<String, String>? = null
        override var startTime: Instant? = null
        override var status: ContinuousExportStatus? = null
        override var statusDetail: String? = null
        override var stopTime: Instant? = null

        constructor(x: ContinuousExportDescription) : this() {
            this.dataSource = x.dataSource
            this.exportId = x.exportId
            this.s3Bucket = x.s3Bucket
            this.schemaStorageConfig = x.schemaStorageConfig
            this.startTime = x.startTime
            this.status = x.status
            this.statusDetail = x.statusDetail
            this.stopTime = x.stopTime
        }

        override fun build(): ContinuousExportDescription = ContinuousExportDescription(this)
        override fun dataSource(dataSource: DataSource): FluentBuilder = apply { this.dataSource = dataSource }
        override fun exportId(exportId: String): FluentBuilder = apply { this.exportId = exportId }
        override fun s3Bucket(s3Bucket: String): FluentBuilder = apply { this.s3Bucket = s3Bucket }
        override fun schemaStorageConfig(schemaStorageConfig: Map<String, String>): FluentBuilder = apply { this.schemaStorageConfig = schemaStorageConfig }
        override fun startTime(startTime: Instant): FluentBuilder = apply { this.startTime = startTime }
        override fun status(status: ContinuousExportStatus): FluentBuilder = apply { this.status = status }
        override fun statusDetail(statusDetail: String): FluentBuilder = apply { this.statusDetail = statusDetail }
        override fun stopTime(stopTime: Instant): FluentBuilder = apply { this.stopTime = stopTime }
    }
}
