// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationdiscoveryservice.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An array of information related to the import task request that includes status
 * information, times, IDs, the Amazon S3 Object URL for the import file, and more.
 */
class ImportTask private constructor(builder: BuilderImpl) {
    /**
     * The total number of application records in the import file that failed to be
     * imported.
     */
    val applicationImportFailure: Int = builder.applicationImportFailure
    /**
     * The total number of application records in the import file that were successfully
     * imported.
     */
    val applicationImportSuccess: Int = builder.applicationImportSuccess
    /**
     * A unique token used to prevent the same import request from occurring more than once. If
     * you didn't provide a token, a token was automatically generated when the import task request
     * was sent.
     */
    val clientRequestToken: String? = builder.clientRequestToken
    /**
     * A link to a compressed archive folder (in the ZIP format) that contains an error log and a
     * file of failed records. You can use these two files to quickly identify records that failed,
     * why they failed, and correct those records. Afterward, you can upload the corrected file to
     * your Amazon S3 bucket and create another import task request.
     * This field also includes authorization information so you can confirm the authenticity of
     * the compressed archive before you download it.
     * If some records failed to be imported we recommend that you correct the records in the
     * failed entries file and then imports that failed entries file. This prevents you from having
     * to correct and update the larger original file and attempt importing it again.
     */
    val errorsAndFailedEntriesZip: String? = builder.errorsAndFailedEntriesZip
    /**
     * The time that the import task request finished, presented in the Unix time stamp
     * format.
     */
    val importCompletionTime: Instant? = builder.importCompletionTime
    /**
     * The time that the import task request was deleted, presented in the Unix time stamp
     * format.
     */
    val importDeletedTime: Instant? = builder.importDeletedTime
    /**
     * The time that the import task request was made, presented in the Unix time stamp
     * format.
     */
    val importRequestTime: Instant? = builder.importRequestTime
    /**
     * The unique ID for a specific import task. These IDs aren't globally unique, but they are
     * unique within an AWS account.
     */
    val importTaskId: String? = builder.importTaskId
    /**
     * The URL for your import file that you've uploaded to Amazon S3.
     */
    val importUrl: String? = builder.importUrl
    /**
     * A descriptive name for an import task. You can use this name to filter future requests
     * related to this import task, such as identifying applications and servers that were included
     * in this import task. We recommend that you use a meaningful name for each import task.
     */
    val name: String? = builder.name
    /**
     * The total number of server records in the import file that failed to be imported.
     */
    val serverImportFailure: Int = builder.serverImportFailure
    /**
     * The total number of server records in the import file that were successfully
     * imported.
     */
    val serverImportSuccess: Int = builder.serverImportSuccess
    /**
     * The status of the import task. An import can have the status of
     * IMPORT_COMPLETE and still have some records fail to import from the overall
     * request. More information can be found in the downloadable archive defined in the
     * errorsAndFailedEntriesZip field, or in the Migration Hub management
     * console.
     */
    val status: ImportStatus? = builder.status

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ImportTask = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ImportTask(")
        append("applicationImportFailure=$applicationImportFailure,")
        append("applicationImportSuccess=$applicationImportSuccess,")
        append("clientRequestToken=$clientRequestToken,")
        append("errorsAndFailedEntriesZip=$errorsAndFailedEntriesZip,")
        append("importCompletionTime=$importCompletionTime,")
        append("importDeletedTime=$importDeletedTime,")
        append("importRequestTime=$importRequestTime,")
        append("importTaskId=$importTaskId,")
        append("importUrl=$importUrl,")
        append("name=$name,")
        append("serverImportFailure=$serverImportFailure,")
        append("serverImportSuccess=$serverImportSuccess,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationImportFailure
        result = 31 * result + (applicationImportSuccess)
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (errorsAndFailedEntriesZip?.hashCode() ?: 0)
        result = 31 * result + (importCompletionTime?.hashCode() ?: 0)
        result = 31 * result + (importDeletedTime?.hashCode() ?: 0)
        result = 31 * result + (importRequestTime?.hashCode() ?: 0)
        result = 31 * result + (importTaskId?.hashCode() ?: 0)
        result = 31 * result + (importUrl?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (serverImportFailure)
        result = 31 * result + (serverImportSuccess)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ImportTask

        if (applicationImportFailure != other.applicationImportFailure) return false
        if (applicationImportSuccess != other.applicationImportSuccess) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (errorsAndFailedEntriesZip != other.errorsAndFailedEntriesZip) return false
        if (importCompletionTime != other.importCompletionTime) return false
        if (importDeletedTime != other.importDeletedTime) return false
        if (importRequestTime != other.importRequestTime) return false
        if (importTaskId != other.importTaskId) return false
        if (importUrl != other.importUrl) return false
        if (name != other.name) return false
        if (serverImportFailure != other.serverImportFailure) return false
        if (serverImportSuccess != other.serverImportSuccess) return false
        if (status != other.status) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ImportTask = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ImportTask
        /**
         * The total number of application records in the import file that failed to be
         * imported.
         */
        fun applicationImportFailure(applicationImportFailure: Int): FluentBuilder
        /**
         * The total number of application records in the import file that were successfully
         * imported.
         */
        fun applicationImportSuccess(applicationImportSuccess: Int): FluentBuilder
        /**
         * A unique token used to prevent the same import request from occurring more than once. If
         * you didn't provide a token, a token was automatically generated when the import task request
         * was sent.
         */
        fun clientRequestToken(clientRequestToken: String): FluentBuilder
        /**
         * A link to a compressed archive folder (in the ZIP format) that contains an error log and a
         * file of failed records. You can use these two files to quickly identify records that failed,
         * why they failed, and correct those records. Afterward, you can upload the corrected file to
         * your Amazon S3 bucket and create another import task request.
         * This field also includes authorization information so you can confirm the authenticity of
         * the compressed archive before you download it.
         * If some records failed to be imported we recommend that you correct the records in the
         * failed entries file and then imports that failed entries file. This prevents you from having
         * to correct and update the larger original file and attempt importing it again.
         */
        fun errorsAndFailedEntriesZip(errorsAndFailedEntriesZip: String): FluentBuilder
        /**
         * The time that the import task request finished, presented in the Unix time stamp
         * format.
         */
        fun importCompletionTime(importCompletionTime: Instant): FluentBuilder
        /**
         * The time that the import task request was deleted, presented in the Unix time stamp
         * format.
         */
        fun importDeletedTime(importDeletedTime: Instant): FluentBuilder
        /**
         * The time that the import task request was made, presented in the Unix time stamp
         * format.
         */
        fun importRequestTime(importRequestTime: Instant): FluentBuilder
        /**
         * The unique ID for a specific import task. These IDs aren't globally unique, but they are
         * unique within an AWS account.
         */
        fun importTaskId(importTaskId: String): FluentBuilder
        /**
         * The URL for your import file that you've uploaded to Amazon S3.
         */
        fun importUrl(importUrl: String): FluentBuilder
        /**
         * A descriptive name for an import task. You can use this name to filter future requests
         * related to this import task, such as identifying applications and servers that were included
         * in this import task. We recommend that you use a meaningful name for each import task.
         */
        fun name(name: String): FluentBuilder
        /**
         * The total number of server records in the import file that failed to be imported.
         */
        fun serverImportFailure(serverImportFailure: Int): FluentBuilder
        /**
         * The total number of server records in the import file that were successfully
         * imported.
         */
        fun serverImportSuccess(serverImportSuccess: Int): FluentBuilder
        /**
         * The status of the import task. An import can have the status of
         * IMPORT_COMPLETE and still have some records fail to import from the overall
         * request. More information can be found in the downloadable archive defined in the
         * errorsAndFailedEntriesZip field, or in the Migration Hub management
         * console.
         */
        fun status(status: ImportStatus): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The total number of application records in the import file that failed to be
         * imported.
         */
        var applicationImportFailure: Int
        /**
         * The total number of application records in the import file that were successfully
         * imported.
         */
        var applicationImportSuccess: Int
        /**
         * A unique token used to prevent the same import request from occurring more than once. If
         * you didn't provide a token, a token was automatically generated when the import task request
         * was sent.
         */
        var clientRequestToken: String?
        /**
         * A link to a compressed archive folder (in the ZIP format) that contains an error log and a
         * file of failed records. You can use these two files to quickly identify records that failed,
         * why they failed, and correct those records. Afterward, you can upload the corrected file to
         * your Amazon S3 bucket and create another import task request.
         * This field also includes authorization information so you can confirm the authenticity of
         * the compressed archive before you download it.
         * If some records failed to be imported we recommend that you correct the records in the
         * failed entries file and then imports that failed entries file. This prevents you from having
         * to correct and update the larger original file and attempt importing it again.
         */
        var errorsAndFailedEntriesZip: String?
        /**
         * The time that the import task request finished, presented in the Unix time stamp
         * format.
         */
        var importCompletionTime: Instant?
        /**
         * The time that the import task request was deleted, presented in the Unix time stamp
         * format.
         */
        var importDeletedTime: Instant?
        /**
         * The time that the import task request was made, presented in the Unix time stamp
         * format.
         */
        var importRequestTime: Instant?
        /**
         * The unique ID for a specific import task. These IDs aren't globally unique, but they are
         * unique within an AWS account.
         */
        var importTaskId: String?
        /**
         * The URL for your import file that you've uploaded to Amazon S3.
         */
        var importUrl: String?
        /**
         * A descriptive name for an import task. You can use this name to filter future requests
         * related to this import task, such as identifying applications and servers that were included
         * in this import task. We recommend that you use a meaningful name for each import task.
         */
        var name: String?
        /**
         * The total number of server records in the import file that failed to be imported.
         */
        var serverImportFailure: Int
        /**
         * The total number of server records in the import file that were successfully
         * imported.
         */
        var serverImportSuccess: Int
        /**
         * The status of the import task. An import can have the status of
         * IMPORT_COMPLETE and still have some records fail to import from the overall
         * request. More information can be found in the downloadable archive defined in the
         * errorsAndFailedEntriesZip field, or in the Migration Hub management
         * console.
         */
        var status: ImportStatus?

        fun build(): ImportTask
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var applicationImportFailure: Int = 0
        override var applicationImportSuccess: Int = 0
        override var clientRequestToken: String? = null
        override var errorsAndFailedEntriesZip: String? = null
        override var importCompletionTime: Instant? = null
        override var importDeletedTime: Instant? = null
        override var importRequestTime: Instant? = null
        override var importTaskId: String? = null
        override var importUrl: String? = null
        override var name: String? = null
        override var serverImportFailure: Int = 0
        override var serverImportSuccess: Int = 0
        override var status: ImportStatus? = null

        constructor(x: ImportTask) : this() {
            this.applicationImportFailure = x.applicationImportFailure
            this.applicationImportSuccess = x.applicationImportSuccess
            this.clientRequestToken = x.clientRequestToken
            this.errorsAndFailedEntriesZip = x.errorsAndFailedEntriesZip
            this.importCompletionTime = x.importCompletionTime
            this.importDeletedTime = x.importDeletedTime
            this.importRequestTime = x.importRequestTime
            this.importTaskId = x.importTaskId
            this.importUrl = x.importUrl
            this.name = x.name
            this.serverImportFailure = x.serverImportFailure
            this.serverImportSuccess = x.serverImportSuccess
            this.status = x.status
        }

        override fun build(): ImportTask = ImportTask(this)
        override fun applicationImportFailure(applicationImportFailure: Int): FluentBuilder = apply { this.applicationImportFailure = applicationImportFailure }
        override fun applicationImportSuccess(applicationImportSuccess: Int): FluentBuilder = apply { this.applicationImportSuccess = applicationImportSuccess }
        override fun clientRequestToken(clientRequestToken: String): FluentBuilder = apply { this.clientRequestToken = clientRequestToken }
        override fun errorsAndFailedEntriesZip(errorsAndFailedEntriesZip: String): FluentBuilder = apply { this.errorsAndFailedEntriesZip = errorsAndFailedEntriesZip }
        override fun importCompletionTime(importCompletionTime: Instant): FluentBuilder = apply { this.importCompletionTime = importCompletionTime }
        override fun importDeletedTime(importDeletedTime: Instant): FluentBuilder = apply { this.importDeletedTime = importDeletedTime }
        override fun importRequestTime(importRequestTime: Instant): FluentBuilder = apply { this.importRequestTime = importRequestTime }
        override fun importTaskId(importTaskId: String): FluentBuilder = apply { this.importTaskId = importTaskId }
        override fun importUrl(importUrl: String): FluentBuilder = apply { this.importUrl = importUrl }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun serverImportFailure(serverImportFailure: Int): FluentBuilder = apply { this.serverImportFailure = serverImportFailure }
        override fun serverImportSuccess(serverImportSuccess: Int): FluentBuilder = apply { this.serverImportSuccess = serverImportSuccess }
        override fun status(status: ImportStatus): FluentBuilder = apply { this.status = status }
    }
}
