// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationdiscoveryservice.model



class ListConfigurationsRequest private constructor(builder: BuilderImpl) {
    /**
     * A valid configuration identified by Application Discovery Service.
     */
    val configurationType: ConfigurationItemType? = builder.configurationType
    /**
     * You can filter the request using various logical operators and a
     * key-value format. For example:
     * {"key": "serverType", "value": "webServer"}
     * For a complete list of filter options and guidance about using them with this action,
     * see <a href="https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#ListConfigurations">Using the ListConfigurations Action in the AWS Application Discovery
     * Service User Guide.
     */
    val filters: List<Filter>? = builder.filters
    /**
     * The total number of items to return. The maximum value is 100.
     */
    val maxResults: Int = builder.maxResults
    /**
     * Token to retrieve the next set of results. For example, if a previous call to
     * ListConfigurations returned 100 items, but you set
     * ListConfigurationsRequest$maxResults to 10, you received a set of 10 results
     * along with a token. Use that token in this query to get the next set of 10.
     */
    val nextToken: String? = builder.nextToken
    /**
     * Certain filter criteria return output that can be sorted in ascending or descending
     * order. For a list of output characteristics for each filter, see <a href="https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#ListConfigurations">Using the ListConfigurations Action in the AWS Application Discovery
     * Service User Guide.
     */
    val orderBy: List<OrderByElement>? = builder.orderBy

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListConfigurationsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListConfigurationsRequest(")
        append("configurationType=$configurationType,")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("orderBy=$orderBy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = configurationType?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (maxResults)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (orderBy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListConfigurationsRequest

        if (configurationType != other.configurationType) return false
        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (orderBy != other.orderBy) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListConfigurationsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListConfigurationsRequest
        /**
         * A valid configuration identified by Application Discovery Service.
         */
        fun configurationType(configurationType: ConfigurationItemType): FluentBuilder
        /**
         * You can filter the request using various logical operators and a
         * key-value format. For example:
         * {"key": "serverType", "value": "webServer"}
         * For a complete list of filter options and guidance about using them with this action,
         * see <a href="https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#ListConfigurations">Using the ListConfigurations Action in the AWS Application Discovery
         * Service User Guide.
         */
        fun filters(filters: List<Filter>): FluentBuilder
        /**
         * The total number of items to return. The maximum value is 100.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * Token to retrieve the next set of results. For example, if a previous call to
         * ListConfigurations returned 100 items, but you set
         * ListConfigurationsRequest$maxResults to 10, you received a set of 10 results
         * along with a token. Use that token in this query to get the next set of 10.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * Certain filter criteria return output that can be sorted in ascending or descending
         * order. For a list of output characteristics for each filter, see <a href="https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#ListConfigurations">Using the ListConfigurations Action in the AWS Application Discovery
         * Service User Guide.
         */
        fun orderBy(orderBy: List<OrderByElement>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A valid configuration identified by Application Discovery Service.
         */
        var configurationType: ConfigurationItemType?
        /**
         * You can filter the request using various logical operators and a
         * key-value format. For example:
         * {"key": "serverType", "value": "webServer"}
         * For a complete list of filter options and guidance about using them with this action,
         * see <a href="https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#ListConfigurations">Using the ListConfigurations Action in the AWS Application Discovery
         * Service User Guide.
         */
        var filters: List<Filter>?
        /**
         * The total number of items to return. The maximum value is 100.
         */
        var maxResults: Int
        /**
         * Token to retrieve the next set of results. For example, if a previous call to
         * ListConfigurations returned 100 items, but you set
         * ListConfigurationsRequest$maxResults to 10, you received a set of 10 results
         * along with a token. Use that token in this query to get the next set of 10.
         */
        var nextToken: String?
        /**
         * Certain filter criteria return output that can be sorted in ascending or descending
         * order. For a list of output characteristics for each filter, see <a href="https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#ListConfigurations">Using the ListConfigurations Action in the AWS Application Discovery
         * Service User Guide.
         */
        var orderBy: List<OrderByElement>?

        fun build(): ListConfigurationsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var configurationType: ConfigurationItemType? = null
        override var filters: List<Filter>? = null
        override var maxResults: Int = 0
        override var nextToken: String? = null
        override var orderBy: List<OrderByElement>? = null

        constructor(x: ListConfigurationsRequest) : this() {
            this.configurationType = x.configurationType
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.orderBy = x.orderBy
        }

        override fun build(): ListConfigurationsRequest = ListConfigurationsRequest(this)
        override fun configurationType(configurationType: ConfigurationItemType): FluentBuilder = apply { this.configurationType = configurationType }
        override fun filters(filters: List<Filter>): FluentBuilder = apply { this.filters = filters }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun orderBy(orderBy: List<OrderByElement>): FluentBuilder = apply { this.orderBy = orderBy }
    }
}
