// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationdiscoveryservice.model

import aws.smithy.kotlin.runtime.time.Instant

class StartExportTaskRequest private constructor(builder: BuilderImpl) {
    /**
     * The end timestamp for exported data from the single Application Discovery Agent
     * selected in the filters. If no value is specified, exported data includes the most recent data
     * collected by the agent.
     */
    val endTime: Instant? = builder.endTime
    /**
     * The file format for the returned export data. Default value is CSV.
     * Note:
     * The
     * GRAPHML
     * option has been deprecated.
     */
    val exportDataFormat: List<ExportDataFormat>? = builder.exportDataFormat
    /**
     * If a filter is present, it selects the single agentId of the Application
     * Discovery Agent for which data is exported. The agentId can be found in the
     * results of the DescribeAgents API or CLI. If no filter is present,
     * startTime and endTime are ignored and exported data includes both
     * Agentless Discovery Connector data and summary data from Application Discovery agents.
     */
    val filters: List<ExportFilter>? = builder.filters
    /**
     * The start timestamp for exported data from the single Application Discovery Agent
     * selected in the filters. If no value is specified, data is exported starting from the first
     * data collected by the agent.
     */
    val startTime: Instant? = builder.startTime

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): StartExportTaskRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("StartExportTaskRequest(")
        append("endTime=$endTime,")
        append("exportDataFormat=$exportDataFormat,")
        append("filters=$filters,")
        append("startTime=$startTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (exportDataFormat?.hashCode() ?: 0)
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as StartExportTaskRequest

        if (endTime != other.endTime) return false
        if (exportDataFormat != other.exportDataFormat) return false
        if (filters != other.filters) return false
        if (startTime != other.startTime) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): StartExportTaskRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): StartExportTaskRequest
        /**
         * The end timestamp for exported data from the single Application Discovery Agent
         * selected in the filters. If no value is specified, exported data includes the most recent data
         * collected by the agent.
         */
        fun endTime(endTime: Instant): FluentBuilder
        /**
         * The file format for the returned export data. Default value is CSV.
         * Note:
         * The
         * GRAPHML
         * option has been deprecated.
         */
        fun exportDataFormat(exportDataFormat: List<ExportDataFormat>): FluentBuilder
        /**
         * If a filter is present, it selects the single agentId of the Application
         * Discovery Agent for which data is exported. The agentId can be found in the
         * results of the DescribeAgents API or CLI. If no filter is present,
         * startTime and endTime are ignored and exported data includes both
         * Agentless Discovery Connector data and summary data from Application Discovery agents.
         */
        fun filters(filters: List<ExportFilter>): FluentBuilder
        /**
         * The start timestamp for exported data from the single Application Discovery Agent
         * selected in the filters. If no value is specified, data is exported starting from the first
         * data collected by the agent.
         */
        fun startTime(startTime: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The end timestamp for exported data from the single Application Discovery Agent
         * selected in the filters. If no value is specified, exported data includes the most recent data
         * collected by the agent.
         */
        var endTime: Instant?
        /**
         * The file format for the returned export data. Default value is CSV.
         * Note:
         * The
         * GRAPHML
         * option has been deprecated.
         */
        var exportDataFormat: List<ExportDataFormat>?
        /**
         * If a filter is present, it selects the single agentId of the Application
         * Discovery Agent for which data is exported. The agentId can be found in the
         * results of the DescribeAgents API or CLI. If no filter is present,
         * startTime and endTime are ignored and exported data includes both
         * Agentless Discovery Connector data and summary data from Application Discovery agents.
         */
        var filters: List<ExportFilter>?
        /**
         * The start timestamp for exported data from the single Application Discovery Agent
         * selected in the filters. If no value is specified, data is exported starting from the first
         * data collected by the agent.
         */
        var startTime: Instant?

        fun build(): StartExportTaskRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var endTime: Instant? = null
        override var exportDataFormat: List<ExportDataFormat>? = null
        override var filters: List<ExportFilter>? = null
        override var startTime: Instant? = null

        constructor(x: StartExportTaskRequest) : this() {
            this.endTime = x.endTime
            this.exportDataFormat = x.exportDataFormat
            this.filters = x.filters
            this.startTime = x.startTime
        }

        override fun build(): StartExportTaskRequest = StartExportTaskRequest(this)
        override fun endTime(endTime: Instant): FluentBuilder = apply { this.endTime = endTime }
        override fun exportDataFormat(exportDataFormat: List<ExportDataFormat>): FluentBuilder = apply { this.exportDataFormat = exportDataFormat }
        override fun filters(filters: List<ExportFilter>): FluentBuilder = apply { this.filters = filters }
        override fun startTime(startTime: Instant): FluentBuilder = apply { this.startTime = startTime }
    }
}
