// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationdiscoveryservice.model

import aws.smithy.kotlin.runtime.time.Instant

class StartContinuousExportResponse private constructor(builder: BuilderImpl) {
    /**
     * The type of data collector used to gather this data (currently only offered for
     * AGENT).
     */
    val dataSource: DataSource? = builder.dataSource
    /**
     * The unique ID assigned to this export.
     */
    val exportId: String? = builder.exportId
    /**
     * The name of the s3 bucket where the export data parquet files are stored.
     */
    val s3Bucket: String? = builder.s3Bucket
    /**
     * A dictionary which describes how the data is stored.
     * databaseName - the name of the Glue database used to store the
     * schema.
     */
    val schemaStorageConfig: Map<String, String>? = builder.schemaStorageConfig
    /**
     * The timestamp representing when the continuous export was started.
     */
    val startTime: Instant? = builder.startTime

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): StartContinuousExportResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("StartContinuousExportResponse(")
        append("dataSource=$dataSource,")
        append("exportId=$exportId,")
        append("s3Bucket=$s3Bucket,")
        append("schemaStorageConfig=$schemaStorageConfig,")
        append("startTime=$startTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataSource?.hashCode() ?: 0
        result = 31 * result + (exportId?.hashCode() ?: 0)
        result = 31 * result + (s3Bucket?.hashCode() ?: 0)
        result = 31 * result + (schemaStorageConfig?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as StartContinuousExportResponse

        if (dataSource != other.dataSource) return false
        if (exportId != other.exportId) return false
        if (s3Bucket != other.s3Bucket) return false
        if (schemaStorageConfig != other.schemaStorageConfig) return false
        if (startTime != other.startTime) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): StartContinuousExportResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): StartContinuousExportResponse
        /**
         * The type of data collector used to gather this data (currently only offered for
         * AGENT).
         */
        fun dataSource(dataSource: DataSource): FluentBuilder
        /**
         * The unique ID assigned to this export.
         */
        fun exportId(exportId: String): FluentBuilder
        /**
         * The name of the s3 bucket where the export data parquet files are stored.
         */
        fun s3Bucket(s3Bucket: String): FluentBuilder
        /**
         * A dictionary which describes how the data is stored.
         * databaseName - the name of the Glue database used to store the
         * schema.
         */
        fun schemaStorageConfig(schemaStorageConfig: Map<String, String>): FluentBuilder
        /**
         * The timestamp representing when the continuous export was started.
         */
        fun startTime(startTime: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The type of data collector used to gather this data (currently only offered for
         * AGENT).
         */
        var dataSource: DataSource?
        /**
         * The unique ID assigned to this export.
         */
        var exportId: String?
        /**
         * The name of the s3 bucket where the export data parquet files are stored.
         */
        var s3Bucket: String?
        /**
         * A dictionary which describes how the data is stored.
         * databaseName - the name of the Glue database used to store the
         * schema.
         */
        var schemaStorageConfig: Map<String, String>?
        /**
         * The timestamp representing when the continuous export was started.
         */
        var startTime: Instant?

        fun build(): StartContinuousExportResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dataSource: DataSource? = null
        override var exportId: String? = null
        override var s3Bucket: String? = null
        override var schemaStorageConfig: Map<String, String>? = null
        override var startTime: Instant? = null

        constructor(x: StartContinuousExportResponse) : this() {
            this.dataSource = x.dataSource
            this.exportId = x.exportId
            this.s3Bucket = x.s3Bucket
            this.schemaStorageConfig = x.schemaStorageConfig
            this.startTime = x.startTime
        }

        override fun build(): StartContinuousExportResponse = StartContinuousExportResponse(this)
        override fun dataSource(dataSource: DataSource): FluentBuilder = apply { this.dataSource = dataSource }
        override fun exportId(exportId: String): FluentBuilder = apply { this.exportId = exportId }
        override fun s3Bucket(s3Bucket: String): FluentBuilder = apply { this.s3Bucket = s3Bucket }
        override fun schemaStorageConfig(schemaStorageConfig: Map<String, String>): FluentBuilder = apply { this.schemaStorageConfig = schemaStorageConfig }
        override fun startTime(startTime: Instant): FluentBuilder = apply { this.startTime = startTime }
    }
}
