// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationdiscoveryservice.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.ApplicationDiscoveryException
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.DescribeExportConfigurationsResponse
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.ExportInfo
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeExportConfigurationsOperationDeserializer: HttpDeserialize<DescribeExportConfigurationsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeExportConfigurationsResponse {
        if (!response.status.isSuccess()) {
            throwDescribeExportConfigurationsError(context, response)
        }
        val builder = DescribeExportConfigurationsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeExportConfigurationsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeDescribeExportConfigurationsOperationBody(builder: DescribeExportConfigurationsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val EXPORTSINFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("exportsInfo"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(EXPORTSINFO_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                EXPORTSINFO_DESCRIPTOR.index -> builder.exportsInfo =
                    deserializer.deserializeList(EXPORTSINFO_DESCRIPTOR) {
                        val col0 = mutableListOf<ExportInfo>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeExportInfoDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDescribeExportConfigurationsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsJson1_1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "AuthorizationErrorException" -> AuthorizationErrorExceptionDeserializer()
        "HomeRegionNotSetException" -> HomeRegionNotSetExceptionDeserializer()
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer()
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "ServerInternalErrorException" -> ServerInternalErrorExceptionDeserializer()
        else -> throw ApplicationDiscoveryException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
