// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationdiscoveryservice.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.ApplicationDiscoveryException
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.GetDiscoverySummaryResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetDiscoverySummaryOperationDeserializer: HttpDeserialize<GetDiscoverySummaryResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetDiscoverySummaryResponse {
        if (!response.status.isSuccess()) {
            throwGetDiscoverySummaryError(context, response)
        }
        val builder = GetDiscoverySummaryResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetDiscoverySummaryOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeGetDiscoverySummaryOperationBody(builder: GetDiscoverySummaryResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AGENTSUMMARY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("agentSummary"))
    val APPLICATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("applications"))
    val CONNECTORSUMMARY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("connectorSummary"))
    val SERVERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("servers"))
    val SERVERSMAPPEDTOAPPLICATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("serversMappedToApplications"))
    val SERVERSMAPPEDTOTAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("serversMappedtoTags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AGENTSUMMARY_DESCRIPTOR)
        field(APPLICATIONS_DESCRIPTOR)
        field(CONNECTORSUMMARY_DESCRIPTOR)
        field(SERVERS_DESCRIPTOR)
        field(SERVERSMAPPEDTOAPPLICATIONS_DESCRIPTOR)
        field(SERVERSMAPPEDTOTAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AGENTSUMMARY_DESCRIPTOR.index -> builder.agentSummary = deserializeCustomerAgentInfoDocument(deserializer)
                APPLICATIONS_DESCRIPTOR.index -> builder.applications = deserializeLong()
                CONNECTORSUMMARY_DESCRIPTOR.index -> builder.connectorSummary = deserializeCustomerConnectorInfoDocument(deserializer)
                SERVERS_DESCRIPTOR.index -> builder.servers = deserializeLong()
                SERVERSMAPPEDTOAPPLICATIONS_DESCRIPTOR.index -> builder.serversMappedToApplications = deserializeLong()
                SERVERSMAPPEDTOTAGS_DESCRIPTOR.index -> builder.serversMappedtoTags = deserializeLong()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwGetDiscoverySummaryError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsJson1_1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "AuthorizationErrorException" -> AuthorizationErrorExceptionDeserializer()
        "HomeRegionNotSetException" -> HomeRegionNotSetExceptionDeserializer()
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer()
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer()
        "ServerInternalErrorException" -> ServerInternalErrorExceptionDeserializer()
        else -> throw ApplicationDiscoveryException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
