// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationdiscoveryservice.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.AgentConfigurationStatus
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.ApplicationDiscoveryException
import aws.sdk.kotlin.services.applicationdiscoveryservice.model.StopDataCollectionByAgentIdsResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class StopDataCollectionByAgentIdsOperationDeserializer: HttpDeserialize<StopDataCollectionByAgentIdsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): StopDataCollectionByAgentIdsResponse {
        if (!response.status.isSuccess()) {
            throwStopDataCollectionByAgentIdsError(context, response)
        }
        val builder = StopDataCollectionByAgentIdsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeStopDataCollectionByAgentIdsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeStopDataCollectionByAgentIdsOperationBody(builder: StopDataCollectionByAgentIdsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AGENTSCONFIGURATIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("agentsConfigurationStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AGENTSCONFIGURATIONSTATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AGENTSCONFIGURATIONSTATUS_DESCRIPTOR.index -> builder.agentsConfigurationStatus =
                    deserializer.deserializeList(AGENTSCONFIGURATIONSTATUS_DESCRIPTOR) {
                        val col0 = mutableListOf<AgentConfigurationStatus>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAgentConfigurationStatusDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwStopDataCollectionByAgentIdsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsJson1_1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "AuthorizationErrorException" -> AuthorizationErrorExceptionDeserializer()
        "HomeRegionNotSetException" -> HomeRegionNotSetExceptionDeserializer()
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer()
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer()
        "ServerInternalErrorException" -> ServerInternalErrorExceptionDeserializer()
        else -> throw ApplicationDiscoveryException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
