// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationinsights

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.applicationinsights.auth.ApplicationInsightsAuthSchemeProvider
import aws.sdk.kotlin.services.applicationinsights.auth.DefaultApplicationInsightsAuthSchemeProvider
import aws.sdk.kotlin.services.applicationinsights.endpoints.ApplicationInsightsEndpointParameters
import aws.sdk.kotlin.services.applicationinsights.endpoints.ApplicationInsightsEndpointProvider
import aws.sdk.kotlin.services.applicationinsights.endpoints.DefaultApplicationInsightsEndpointProvider
import aws.sdk.kotlin.services.applicationinsights.model.AddWorkloadRequest
import aws.sdk.kotlin.services.applicationinsights.model.AddWorkloadResponse
import aws.sdk.kotlin.services.applicationinsights.model.CreateApplicationRequest
import aws.sdk.kotlin.services.applicationinsights.model.CreateApplicationResponse
import aws.sdk.kotlin.services.applicationinsights.model.CreateComponentRequest
import aws.sdk.kotlin.services.applicationinsights.model.CreateComponentResponse
import aws.sdk.kotlin.services.applicationinsights.model.CreateLogPatternRequest
import aws.sdk.kotlin.services.applicationinsights.model.CreateLogPatternResponse
import aws.sdk.kotlin.services.applicationinsights.model.DeleteApplicationRequest
import aws.sdk.kotlin.services.applicationinsights.model.DeleteApplicationResponse
import aws.sdk.kotlin.services.applicationinsights.model.DeleteComponentRequest
import aws.sdk.kotlin.services.applicationinsights.model.DeleteComponentResponse
import aws.sdk.kotlin.services.applicationinsights.model.DeleteLogPatternRequest
import aws.sdk.kotlin.services.applicationinsights.model.DeleteLogPatternResponse
import aws.sdk.kotlin.services.applicationinsights.model.DescribeApplicationRequest
import aws.sdk.kotlin.services.applicationinsights.model.DescribeApplicationResponse
import aws.sdk.kotlin.services.applicationinsights.model.DescribeComponentConfigurationRecommendationRequest
import aws.sdk.kotlin.services.applicationinsights.model.DescribeComponentConfigurationRecommendationResponse
import aws.sdk.kotlin.services.applicationinsights.model.DescribeComponentConfigurationRequest
import aws.sdk.kotlin.services.applicationinsights.model.DescribeComponentConfigurationResponse
import aws.sdk.kotlin.services.applicationinsights.model.DescribeComponentRequest
import aws.sdk.kotlin.services.applicationinsights.model.DescribeComponentResponse
import aws.sdk.kotlin.services.applicationinsights.model.DescribeLogPatternRequest
import aws.sdk.kotlin.services.applicationinsights.model.DescribeLogPatternResponse
import aws.sdk.kotlin.services.applicationinsights.model.DescribeObservationRequest
import aws.sdk.kotlin.services.applicationinsights.model.DescribeObservationResponse
import aws.sdk.kotlin.services.applicationinsights.model.DescribeProblemObservationsRequest
import aws.sdk.kotlin.services.applicationinsights.model.DescribeProblemObservationsResponse
import aws.sdk.kotlin.services.applicationinsights.model.DescribeProblemRequest
import aws.sdk.kotlin.services.applicationinsights.model.DescribeProblemResponse
import aws.sdk.kotlin.services.applicationinsights.model.DescribeWorkloadRequest
import aws.sdk.kotlin.services.applicationinsights.model.DescribeWorkloadResponse
import aws.sdk.kotlin.services.applicationinsights.model.ListApplicationsRequest
import aws.sdk.kotlin.services.applicationinsights.model.ListApplicationsResponse
import aws.sdk.kotlin.services.applicationinsights.model.ListComponentsRequest
import aws.sdk.kotlin.services.applicationinsights.model.ListComponentsResponse
import aws.sdk.kotlin.services.applicationinsights.model.ListConfigurationHistoryRequest
import aws.sdk.kotlin.services.applicationinsights.model.ListConfigurationHistoryResponse
import aws.sdk.kotlin.services.applicationinsights.model.ListLogPatternSetsRequest
import aws.sdk.kotlin.services.applicationinsights.model.ListLogPatternSetsResponse
import aws.sdk.kotlin.services.applicationinsights.model.ListLogPatternsRequest
import aws.sdk.kotlin.services.applicationinsights.model.ListLogPatternsResponse
import aws.sdk.kotlin.services.applicationinsights.model.ListProblemsRequest
import aws.sdk.kotlin.services.applicationinsights.model.ListProblemsResponse
import aws.sdk.kotlin.services.applicationinsights.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.applicationinsights.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.applicationinsights.model.ListWorkloadsRequest
import aws.sdk.kotlin.services.applicationinsights.model.ListWorkloadsResponse
import aws.sdk.kotlin.services.applicationinsights.model.RemoveWorkloadRequest
import aws.sdk.kotlin.services.applicationinsights.model.RemoveWorkloadResponse
import aws.sdk.kotlin.services.applicationinsights.model.TagResourceRequest
import aws.sdk.kotlin.services.applicationinsights.model.TagResourceResponse
import aws.sdk.kotlin.services.applicationinsights.model.UntagResourceRequest
import aws.sdk.kotlin.services.applicationinsights.model.UntagResourceResponse
import aws.sdk.kotlin.services.applicationinsights.model.UpdateApplicationRequest
import aws.sdk.kotlin.services.applicationinsights.model.UpdateApplicationResponse
import aws.sdk.kotlin.services.applicationinsights.model.UpdateComponentConfigurationRequest
import aws.sdk.kotlin.services.applicationinsights.model.UpdateComponentConfigurationResponse
import aws.sdk.kotlin.services.applicationinsights.model.UpdateComponentRequest
import aws.sdk.kotlin.services.applicationinsights.model.UpdateComponentResponse
import aws.sdk.kotlin.services.applicationinsights.model.UpdateLogPatternRequest
import aws.sdk.kotlin.services.applicationinsights.model.UpdateLogPatternResponse
import aws.sdk.kotlin.services.applicationinsights.model.UpdateProblemRequest
import aws.sdk.kotlin.services.applicationinsights.model.UpdateProblemResponse
import aws.sdk.kotlin.services.applicationinsights.model.UpdateWorkloadRequest
import aws.sdk.kotlin.services.applicationinsights.model.UpdateWorkloadResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Application Insights"
public const val SdkVersion: String = "1.3.47"
public const val ServiceApiVersion: String = "2018-11-25"

/**
 * # Amazon CloudWatch Application Insights
 *  Amazon CloudWatch Application Insights is a service that helps you detect common problems with your applications. It enables you to pinpoint the source of issues in your applications (built with technologies such as Microsoft IIS, .NET, and Microsoft SQL Server), by providing key insights into detected problems.
 *
 * After you onboard your application, CloudWatch Application Insights identifies, recommends, and sets up metrics and logs. It continuously analyzes and correlates your metrics and logs for unusual behavior to surface actionable problems with your application. For example, if your application is slow and unresponsive and leading to HTTP 500 errors in your Application Load Balancer (ALB), Application Insights informs you that a memory pressure problem with your SQL Server database is occurring. It bases this analysis on impactful metrics and log errors.
 */
public interface ApplicationInsightsClient : SdkClient {
    /**
     * ApplicationInsightsClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, ApplicationInsightsClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "ApplicationInsights",
                "APPLICATION_INSIGHTS",
                "application_insights",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, ApplicationInsightsClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): ApplicationInsightsClient = DefaultApplicationInsightsClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: ApplicationInsightsEndpointProvider = builder.endpointProvider ?: DefaultApplicationInsightsEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: ApplicationInsightsAuthSchemeProvider = builder.authSchemeProvider ?: DefaultApplicationInsightsAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Application Insights"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: ApplicationInsightsEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: ApplicationInsightsAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Adds a workload to a component. Each component can have at most five workloads.
     */
    public suspend fun addWorkload(input: AddWorkloadRequest): AddWorkloadResponse

    /**
     * Adds an application that is created from a resource group.
     */
    public suspend fun createApplication(input: CreateApplicationRequest = CreateApplicationRequest { }): CreateApplicationResponse

    /**
     * Creates a custom component by grouping similar standalone instances to monitor.
     */
    public suspend fun createComponent(input: CreateComponentRequest): CreateComponentResponse

    /**
     * Adds an log pattern to a `LogPatternSet`.
     */
    public suspend fun createLogPattern(input: CreateLogPatternRequest): CreateLogPatternResponse

    /**
     * Removes the specified application from monitoring. Does not delete the application.
     */
    public suspend fun deleteApplication(input: DeleteApplicationRequest): DeleteApplicationResponse

    /**
     * Ungroups a custom component. When you ungroup custom components, all applicable monitors that are set up for the component are removed and the instances revert to their standalone status.
     */
    public suspend fun deleteComponent(input: DeleteComponentRequest): DeleteComponentResponse

    /**
     * Removes the specified log pattern from a `LogPatternSet`.
     */
    public suspend fun deleteLogPattern(input: DeleteLogPatternRequest): DeleteLogPatternResponse

    /**
     * Describes the application.
     */
    public suspend fun describeApplication(input: DescribeApplicationRequest): DescribeApplicationResponse

    /**
     * Describes a component and lists the resources that are grouped together in a component.
     */
    public suspend fun describeComponent(input: DescribeComponentRequest): DescribeComponentResponse

    /**
     * Describes the monitoring configuration of the component.
     */
    public suspend fun describeComponentConfiguration(input: DescribeComponentConfigurationRequest): DescribeComponentConfigurationResponse

    /**
     * Describes the recommended monitoring configuration of the component.
     */
    public suspend fun describeComponentConfigurationRecommendation(input: DescribeComponentConfigurationRecommendationRequest): DescribeComponentConfigurationRecommendationResponse

    /**
     * Describe a specific log pattern from a `LogPatternSet`.
     */
    public suspend fun describeLogPattern(input: DescribeLogPatternRequest): DescribeLogPatternResponse

    /**
     * Describes an anomaly or error with the application.
     */
    public suspend fun describeObservation(input: DescribeObservationRequest): DescribeObservationResponse

    /**
     * Describes an application problem.
     */
    public suspend fun describeProblem(input: DescribeProblemRequest): DescribeProblemResponse

    /**
     * Describes the anomalies or errors associated with the problem.
     */
    public suspend fun describeProblemObservations(input: DescribeProblemObservationsRequest): DescribeProblemObservationsResponse

    /**
     * Describes a workload and its configuration.
     */
    public suspend fun describeWorkload(input: DescribeWorkloadRequest): DescribeWorkloadResponse

    /**
     * Lists the IDs of the applications that you are monitoring.
     */
    public suspend fun listApplications(input: ListApplicationsRequest = ListApplicationsRequest { }): ListApplicationsResponse

    /**
     * Lists the auto-grouped, standalone, and custom components of the application.
     */
    public suspend fun listComponents(input: ListComponentsRequest): ListComponentsResponse

    /**
     * Lists the INFO, WARN, and ERROR events for periodic configuration updates performed by Application Insights. Examples of events represented are:
     * + INFO: creating a new alarm or updating an alarm threshold.
     * + WARN: alarm not created due to insufficient data points used to predict thresholds.
     * + ERROR: alarm not created due to permission errors or exceeding quotas.
     */
    public suspend fun listConfigurationHistory(input: ListConfigurationHistoryRequest = ListConfigurationHistoryRequest { }): ListConfigurationHistoryResponse

    /**
     * Lists the log pattern sets in the specific application.
     */
    public suspend fun listLogPatternSets(input: ListLogPatternSetsRequest): ListLogPatternSetsResponse

    /**
     * Lists the log patterns in the specific log `LogPatternSet`.
     */
    public suspend fun listLogPatterns(input: ListLogPatternsRequest): ListLogPatternsResponse

    /**
     * Lists the problems with your application.
     */
    public suspend fun listProblems(input: ListProblemsRequest = ListProblemsRequest { }): ListProblemsResponse

    /**
     * Retrieve a list of the tags (keys and values) that are associated with a specified application. A *tag* is a label that you optionally define and associate with an application. Each tag consists of a required *tag key* and an optional associated *tag value*. A tag key is a general label that acts as a category for more specific tag values. A tag value acts as a descriptor within a tag key.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the workloads that are configured on a given component.
     */
    public suspend fun listWorkloads(input: ListWorkloadsRequest): ListWorkloadsResponse

    /**
     * Remove workload from a component.
     */
    public suspend fun removeWorkload(input: RemoveWorkloadRequest): RemoveWorkloadResponse

    /**
     * Add one or more tags (keys and values) to a specified application. A *tag* is a label that you optionally define and associate with an application. Tags can help you categorize and manage application in different ways, such as by purpose, owner, environment, or other criteria.
     *
     * Each tag consists of a required *tag key* and an associated *tag value*, both of which you define. A tag key is a general label that acts as a category for more specific tag values. A tag value acts as a descriptor within a tag key.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Remove one or more tags (keys and values) from a specified application.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the application.
     */
    public suspend fun updateApplication(input: UpdateApplicationRequest): UpdateApplicationResponse

    /**
     * Updates the custom component name and/or the list of resources that make up the component.
     */
    public suspend fun updateComponent(input: UpdateComponentRequest): UpdateComponentResponse

    /**
     * Updates the monitoring configurations for the component. The configuration input parameter is an escaped JSON of the configuration and should match the schema of what is returned by `DescribeComponentConfigurationRecommendation`.
     */
    public suspend fun updateComponentConfiguration(input: UpdateComponentConfigurationRequest): UpdateComponentConfigurationResponse

    /**
     * Adds a log pattern to a `LogPatternSet`.
     */
    public suspend fun updateLogPattern(input: UpdateLogPatternRequest): UpdateLogPatternResponse

    /**
     * Updates the visibility of the problem or specifies the problem as `RESOLVED`.
     */
    public suspend fun updateProblem(input: UpdateProblemRequest): UpdateProblemResponse

    /**
     * Adds a workload to a component. Each component can have at most five workloads.
     */
    public suspend fun updateWorkload(input: UpdateWorkloadRequest): UpdateWorkloadResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun ApplicationInsightsClient.withConfig(block: ApplicationInsightsClient.Config.Builder.() -> Unit): ApplicationInsightsClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultApplicationInsightsClient(newConfig)
}

/**
 * Adds a workload to a component. Each component can have at most five workloads.
 */
public suspend inline fun ApplicationInsightsClient.addWorkload(crossinline block: AddWorkloadRequest.Builder.() -> Unit): AddWorkloadResponse = addWorkload(AddWorkloadRequest.Builder().apply(block).build())

/**
 * Adds an application that is created from a resource group.
 */
public suspend inline fun ApplicationInsightsClient.createApplication(crossinline block: CreateApplicationRequest.Builder.() -> Unit): CreateApplicationResponse = createApplication(CreateApplicationRequest.Builder().apply(block).build())

/**
 * Creates a custom component by grouping similar standalone instances to monitor.
 */
public suspend inline fun ApplicationInsightsClient.createComponent(crossinline block: CreateComponentRequest.Builder.() -> Unit): CreateComponentResponse = createComponent(CreateComponentRequest.Builder().apply(block).build())

/**
 * Adds an log pattern to a `LogPatternSet`.
 */
public suspend inline fun ApplicationInsightsClient.createLogPattern(crossinline block: CreateLogPatternRequest.Builder.() -> Unit): CreateLogPatternResponse = createLogPattern(CreateLogPatternRequest.Builder().apply(block).build())

/**
 * Removes the specified application from monitoring. Does not delete the application.
 */
public suspend inline fun ApplicationInsightsClient.deleteApplication(crossinline block: DeleteApplicationRequest.Builder.() -> Unit): DeleteApplicationResponse = deleteApplication(DeleteApplicationRequest.Builder().apply(block).build())

/**
 * Ungroups a custom component. When you ungroup custom components, all applicable monitors that are set up for the component are removed and the instances revert to their standalone status.
 */
public suspend inline fun ApplicationInsightsClient.deleteComponent(crossinline block: DeleteComponentRequest.Builder.() -> Unit): DeleteComponentResponse = deleteComponent(DeleteComponentRequest.Builder().apply(block).build())

/**
 * Removes the specified log pattern from a `LogPatternSet`.
 */
public suspend inline fun ApplicationInsightsClient.deleteLogPattern(crossinline block: DeleteLogPatternRequest.Builder.() -> Unit): DeleteLogPatternResponse = deleteLogPattern(DeleteLogPatternRequest.Builder().apply(block).build())

/**
 * Describes the application.
 */
public suspend inline fun ApplicationInsightsClient.describeApplication(crossinline block: DescribeApplicationRequest.Builder.() -> Unit): DescribeApplicationResponse = describeApplication(DescribeApplicationRequest.Builder().apply(block).build())

/**
 * Describes a component and lists the resources that are grouped together in a component.
 */
public suspend inline fun ApplicationInsightsClient.describeComponent(crossinline block: DescribeComponentRequest.Builder.() -> Unit): DescribeComponentResponse = describeComponent(DescribeComponentRequest.Builder().apply(block).build())

/**
 * Describes the monitoring configuration of the component.
 */
public suspend inline fun ApplicationInsightsClient.describeComponentConfiguration(crossinline block: DescribeComponentConfigurationRequest.Builder.() -> Unit): DescribeComponentConfigurationResponse = describeComponentConfiguration(DescribeComponentConfigurationRequest.Builder().apply(block).build())

/**
 * Describes the recommended monitoring configuration of the component.
 */
public suspend inline fun ApplicationInsightsClient.describeComponentConfigurationRecommendation(crossinline block: DescribeComponentConfigurationRecommendationRequest.Builder.() -> Unit): DescribeComponentConfigurationRecommendationResponse = describeComponentConfigurationRecommendation(DescribeComponentConfigurationRecommendationRequest.Builder().apply(block).build())

/**
 * Describe a specific log pattern from a `LogPatternSet`.
 */
public suspend inline fun ApplicationInsightsClient.describeLogPattern(crossinline block: DescribeLogPatternRequest.Builder.() -> Unit): DescribeLogPatternResponse = describeLogPattern(DescribeLogPatternRequest.Builder().apply(block).build())

/**
 * Describes an anomaly or error with the application.
 */
public suspend inline fun ApplicationInsightsClient.describeObservation(crossinline block: DescribeObservationRequest.Builder.() -> Unit): DescribeObservationResponse = describeObservation(DescribeObservationRequest.Builder().apply(block).build())

/**
 * Describes an application problem.
 */
public suspend inline fun ApplicationInsightsClient.describeProblem(crossinline block: DescribeProblemRequest.Builder.() -> Unit): DescribeProblemResponse = describeProblem(DescribeProblemRequest.Builder().apply(block).build())

/**
 * Describes the anomalies or errors associated with the problem.
 */
public suspend inline fun ApplicationInsightsClient.describeProblemObservations(crossinline block: DescribeProblemObservationsRequest.Builder.() -> Unit): DescribeProblemObservationsResponse = describeProblemObservations(DescribeProblemObservationsRequest.Builder().apply(block).build())

/**
 * Describes a workload and its configuration.
 */
public suspend inline fun ApplicationInsightsClient.describeWorkload(crossinline block: DescribeWorkloadRequest.Builder.() -> Unit): DescribeWorkloadResponse = describeWorkload(DescribeWorkloadRequest.Builder().apply(block).build())

/**
 * Lists the IDs of the applications that you are monitoring.
 */
public suspend inline fun ApplicationInsightsClient.listApplications(crossinline block: ListApplicationsRequest.Builder.() -> Unit): ListApplicationsResponse = listApplications(ListApplicationsRequest.Builder().apply(block).build())

/**
 * Lists the auto-grouped, standalone, and custom components of the application.
 */
public suspend inline fun ApplicationInsightsClient.listComponents(crossinline block: ListComponentsRequest.Builder.() -> Unit): ListComponentsResponse = listComponents(ListComponentsRequest.Builder().apply(block).build())

/**
 * Lists the INFO, WARN, and ERROR events for periodic configuration updates performed by Application Insights. Examples of events represented are:
 * + INFO: creating a new alarm or updating an alarm threshold.
 * + WARN: alarm not created due to insufficient data points used to predict thresholds.
 * + ERROR: alarm not created due to permission errors or exceeding quotas.
 */
public suspend inline fun ApplicationInsightsClient.listConfigurationHistory(crossinline block: ListConfigurationHistoryRequest.Builder.() -> Unit): ListConfigurationHistoryResponse = listConfigurationHistory(ListConfigurationHistoryRequest.Builder().apply(block).build())

/**
 * Lists the log pattern sets in the specific application.
 */
public suspend inline fun ApplicationInsightsClient.listLogPatternSets(crossinline block: ListLogPatternSetsRequest.Builder.() -> Unit): ListLogPatternSetsResponse = listLogPatternSets(ListLogPatternSetsRequest.Builder().apply(block).build())

/**
 * Lists the log patterns in the specific log `LogPatternSet`.
 */
public suspend inline fun ApplicationInsightsClient.listLogPatterns(crossinline block: ListLogPatternsRequest.Builder.() -> Unit): ListLogPatternsResponse = listLogPatterns(ListLogPatternsRequest.Builder().apply(block).build())

/**
 * Lists the problems with your application.
 */
public suspend inline fun ApplicationInsightsClient.listProblems(crossinline block: ListProblemsRequest.Builder.() -> Unit): ListProblemsResponse = listProblems(ListProblemsRequest.Builder().apply(block).build())

/**
 * Retrieve a list of the tags (keys and values) that are associated with a specified application. A *tag* is a label that you optionally define and associate with an application. Each tag consists of a required *tag key* and an optional associated *tag value*. A tag key is a general label that acts as a category for more specific tag values. A tag value acts as a descriptor within a tag key.
 */
public suspend inline fun ApplicationInsightsClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists the workloads that are configured on a given component.
 */
public suspend inline fun ApplicationInsightsClient.listWorkloads(crossinline block: ListWorkloadsRequest.Builder.() -> Unit): ListWorkloadsResponse = listWorkloads(ListWorkloadsRequest.Builder().apply(block).build())

/**
 * Remove workload from a component.
 */
public suspend inline fun ApplicationInsightsClient.removeWorkload(crossinline block: RemoveWorkloadRequest.Builder.() -> Unit): RemoveWorkloadResponse = removeWorkload(RemoveWorkloadRequest.Builder().apply(block).build())

/**
 * Add one or more tags (keys and values) to a specified application. A *tag* is a label that you optionally define and associate with an application. Tags can help you categorize and manage application in different ways, such as by purpose, owner, environment, or other criteria.
 *
 * Each tag consists of a required *tag key* and an associated *tag value*, both of which you define. A tag key is a general label that acts as a category for more specific tag values. A tag value acts as a descriptor within a tag key.
 */
public suspend inline fun ApplicationInsightsClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Remove one or more tags (keys and values) from a specified application.
 */
public suspend inline fun ApplicationInsightsClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the application.
 */
public suspend inline fun ApplicationInsightsClient.updateApplication(crossinline block: UpdateApplicationRequest.Builder.() -> Unit): UpdateApplicationResponse = updateApplication(UpdateApplicationRequest.Builder().apply(block).build())

/**
 * Updates the custom component name and/or the list of resources that make up the component.
 */
public suspend inline fun ApplicationInsightsClient.updateComponent(crossinline block: UpdateComponentRequest.Builder.() -> Unit): UpdateComponentResponse = updateComponent(UpdateComponentRequest.Builder().apply(block).build())

/**
 * Updates the monitoring configurations for the component. The configuration input parameter is an escaped JSON of the configuration and should match the schema of what is returned by `DescribeComponentConfigurationRecommendation`.
 */
public suspend inline fun ApplicationInsightsClient.updateComponentConfiguration(crossinline block: UpdateComponentConfigurationRequest.Builder.() -> Unit): UpdateComponentConfigurationResponse = updateComponentConfiguration(UpdateComponentConfigurationRequest.Builder().apply(block).build())

/**
 * Adds a log pattern to a `LogPatternSet`.
 */
public suspend inline fun ApplicationInsightsClient.updateLogPattern(crossinline block: UpdateLogPatternRequest.Builder.() -> Unit): UpdateLogPatternResponse = updateLogPattern(UpdateLogPatternRequest.Builder().apply(block).build())

/**
 * Updates the visibility of the problem or specifies the problem as `RESOLVED`.
 */
public suspend inline fun ApplicationInsightsClient.updateProblem(crossinline block: UpdateProblemRequest.Builder.() -> Unit): UpdateProblemResponse = updateProblem(UpdateProblemRequest.Builder().apply(block).build())

/**
 * Adds a workload to a component. Each component can have at most five workloads.
 */
public suspend inline fun ApplicationInsightsClient.updateWorkload(crossinline block: UpdateWorkloadRequest.Builder.() -> Unit): UpdateWorkloadResponse = updateWorkload(UpdateWorkloadRequest.Builder().apply(block).build())
