// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationinsights.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the status of the application.
 */
public class ApplicationInfo private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID for the owner of the application.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * If set to true, the managed policies for SSM and CW will be attached to the instance roles if they are missing.
     */
    public val attachMissingPermission: kotlin.Boolean? = builder.attachMissingPermission
    /**
     * Indicates whether auto-configuration is turned on for this application.
     */
    public val autoConfigEnabled: kotlin.Boolean? = builder.autoConfigEnabled
    /**
     * Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as `instance terminated`, `failed deployment`, and others.
     */
    public val cweMonitorEnabled: kotlin.Boolean? = builder.cweMonitorEnabled
    /**
     * The method used by Application Insights to onboard your resources.
     */
    public val discoveryType: aws.sdk.kotlin.services.applicationinsights.model.DiscoveryType? = builder.discoveryType
    /**
     * The lifecycle of the application.
     */
    public val lifeCycle: kotlin.String? = builder.lifeCycle
    /**
     * Indicates whether Application Insights will create opsItems for any problem detected by Application Insights for an application.
     */
    public val opsCenterEnabled: kotlin.Boolean? = builder.opsCenterEnabled
    /**
     * The SNS topic provided to Application Insights that is associated to the created opsItems to receive SNS notifications for opsItem updates.
     */
    public val opsItemSnsTopicArn: kotlin.String? = builder.opsItemSnsTopicArn
    /**
     * The issues on the user side that block Application Insights from successfully monitoring an application. Example remarks include:
     * + “Configuring application, detected 1 Errors, 3 Warnings”
     * + “Configuring application, detected 1 Unconfigured Components”
     */
    public val remarks: kotlin.String? = builder.remarks
    /**
     * The name of the resource group used for the application.
     */
    public val resourceGroupName: kotlin.String? = builder.resourceGroupName
    /**
     * The SNS topic ARN that is associated with SNS notifications for updates or issues.
     */
    public val snsNotificationArn: kotlin.String? = builder.snsNotificationArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.applicationinsights.model.ApplicationInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ApplicationInfo(")
        append("accountId=$accountId,")
        append("attachMissingPermission=$attachMissingPermission,")
        append("autoConfigEnabled=$autoConfigEnabled,")
        append("cweMonitorEnabled=$cweMonitorEnabled,")
        append("discoveryType=$discoveryType,")
        append("lifeCycle=$lifeCycle,")
        append("opsCenterEnabled=$opsCenterEnabled,")
        append("opsItemSnsTopicArn=$opsItemSnsTopicArn,")
        append("remarks=$remarks,")
        append("resourceGroupName=$resourceGroupName,")
        append("snsNotificationArn=$snsNotificationArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (attachMissingPermission?.hashCode() ?: 0)
        result = 31 * result + (autoConfigEnabled?.hashCode() ?: 0)
        result = 31 * result + (cweMonitorEnabled?.hashCode() ?: 0)
        result = 31 * result + (discoveryType?.hashCode() ?: 0)
        result = 31 * result + (lifeCycle?.hashCode() ?: 0)
        result = 31 * result + (opsCenterEnabled?.hashCode() ?: 0)
        result = 31 * result + (opsItemSnsTopicArn?.hashCode() ?: 0)
        result = 31 * result + (remarks?.hashCode() ?: 0)
        result = 31 * result + (resourceGroupName?.hashCode() ?: 0)
        result = 31 * result + (snsNotificationArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ApplicationInfo

        if (accountId != other.accountId) return false
        if (attachMissingPermission != other.attachMissingPermission) return false
        if (autoConfigEnabled != other.autoConfigEnabled) return false
        if (cweMonitorEnabled != other.cweMonitorEnabled) return false
        if (discoveryType != other.discoveryType) return false
        if (lifeCycle != other.lifeCycle) return false
        if (opsCenterEnabled != other.opsCenterEnabled) return false
        if (opsItemSnsTopicArn != other.opsItemSnsTopicArn) return false
        if (remarks != other.remarks) return false
        if (resourceGroupName != other.resourceGroupName) return false
        if (snsNotificationArn != other.snsNotificationArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.applicationinsights.model.ApplicationInfo = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Web Services account ID for the owner of the application.
         */
        public var accountId: kotlin.String? = null
        /**
         * If set to true, the managed policies for SSM and CW will be attached to the instance roles if they are missing.
         */
        public var attachMissingPermission: kotlin.Boolean? = null
        /**
         * Indicates whether auto-configuration is turned on for this application.
         */
        public var autoConfigEnabled: kotlin.Boolean? = null
        /**
         * Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as `instance terminated`, `failed deployment`, and others.
         */
        public var cweMonitorEnabled: kotlin.Boolean? = null
        /**
         * The method used by Application Insights to onboard your resources.
         */
        public var discoveryType: aws.sdk.kotlin.services.applicationinsights.model.DiscoveryType? = null
        /**
         * The lifecycle of the application.
         */
        public var lifeCycle: kotlin.String? = null
        /**
         * Indicates whether Application Insights will create opsItems for any problem detected by Application Insights for an application.
         */
        public var opsCenterEnabled: kotlin.Boolean? = null
        /**
         * The SNS topic provided to Application Insights that is associated to the created opsItems to receive SNS notifications for opsItem updates.
         */
        public var opsItemSnsTopicArn: kotlin.String? = null
        /**
         * The issues on the user side that block Application Insights from successfully monitoring an application. Example remarks include:
         * + “Configuring application, detected 1 Errors, 3 Warnings”
         * + “Configuring application, detected 1 Unconfigured Components”
         */
        public var remarks: kotlin.String? = null
        /**
         * The name of the resource group used for the application.
         */
        public var resourceGroupName: kotlin.String? = null
        /**
         * The SNS topic ARN that is associated with SNS notifications for updates or issues.
         */
        public var snsNotificationArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.applicationinsights.model.ApplicationInfo) : this() {
            this.accountId = x.accountId
            this.attachMissingPermission = x.attachMissingPermission
            this.autoConfigEnabled = x.autoConfigEnabled
            this.cweMonitorEnabled = x.cweMonitorEnabled
            this.discoveryType = x.discoveryType
            this.lifeCycle = x.lifeCycle
            this.opsCenterEnabled = x.opsCenterEnabled
            this.opsItemSnsTopicArn = x.opsItemSnsTopicArn
            this.remarks = x.remarks
            this.resourceGroupName = x.resourceGroupName
            this.snsNotificationArn = x.snsNotificationArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.applicationinsights.model.ApplicationInfo = ApplicationInfo(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
