// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationinsights.serde

import aws.sdk.kotlin.services.applicationinsights.model.ApplicationInsightsException
import aws.sdk.kotlin.services.applicationinsights.model.ListProblemsResponse
import aws.sdk.kotlin.services.applicationinsights.model.Problem
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListProblemsOperationDeserializer: HttpDeserializer.NonStreaming<ListProblemsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ListProblemsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListProblemsError(context, call, payload)
        }
        val builder = ListProblemsResponse.Builder()

        if (payload != null) {
            deserializeListProblemsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwListProblemsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ApplicationInsightsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ApplicationInsightsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListProblemsOperationBody(builder: ListProblemsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACCOUNTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AccountId"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val PROBLEMLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ProblemList"))
    val RESOURCEGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ResourceGroupName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCOUNTID_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(PROBLEMLIST_DESCRIPTOR)
        field(RESOURCEGROUPNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACCOUNTID_DESCRIPTOR.index -> builder.accountId = deserializeString()
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                PROBLEMLIST_DESCRIPTOR.index -> builder.problemList =
                    deserializer.deserializeList(PROBLEMLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<Problem>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeProblemDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                RESOURCEGROUPNAME_DESCRIPTOR.index -> builder.resourceGroupName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
