// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationinsights

import aws.sdk.kotlin.runtime.auth.signing.AwsSigV4SigningMiddleware
import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.engine.crt.CrtHttpEngine
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.applicationinsights.model.*
import aws.sdk.kotlin.services.applicationinsights.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.middleware.Retry
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "Application Insights"
const val ServiceApiVersion: String = "2018-11-25"
const val SdkVersion: String = "0.10.1-beta"

internal class DefaultApplicationInsightsClient(override val config: ApplicationInsightsClient.Config) : ApplicationInsightsClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: CrtHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Adds an application that is created from a resource group.
     */
    override suspend fun createApplication(input: CreateApplicationRequest): CreateApplicationResponse {
        val op = SdkHttpOperation.build<CreateApplicationRequest, CreateApplicationResponse> {
            serializer = CreateApplicationOperationSerializer()
            deserializer = CreateApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateApplication"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "applicationinsights"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a custom component by grouping similar standalone instances to monitor.
     */
    override suspend fun createComponent(input: CreateComponentRequest): CreateComponentResponse {
        val op = SdkHttpOperation.build<CreateComponentRequest, CreateComponentResponse> {
            serializer = CreateComponentOperationSerializer()
            deserializer = CreateComponentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateComponent"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "applicationinsights"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds an log pattern to a LogPatternSet.
     */
    override suspend fun createLogPattern(input: CreateLogPatternRequest): CreateLogPatternResponse {
        val op = SdkHttpOperation.build<CreateLogPatternRequest, CreateLogPatternResponse> {
            serializer = CreateLogPatternOperationSerializer()
            deserializer = CreateLogPatternOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateLogPattern"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "applicationinsights"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified application from monitoring. Does not delete the application.
     */
    override suspend fun deleteApplication(input: DeleteApplicationRequest): DeleteApplicationResponse {
        val op = SdkHttpOperation.build<DeleteApplicationRequest, DeleteApplicationResponse> {
            serializer = DeleteApplicationOperationSerializer()
            deserializer = DeleteApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteApplication"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "applicationinsights"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Ungroups a custom component. When you ungroup custom components, all applicable
     * monitors that are set up for the component are removed and the instances revert to their standalone status.
     */
    override suspend fun deleteComponent(input: DeleteComponentRequest): DeleteComponentResponse {
        val op = SdkHttpOperation.build<DeleteComponentRequest, DeleteComponentResponse> {
            serializer = DeleteComponentOperationSerializer()
            deserializer = DeleteComponentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteComponent"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "applicationinsights"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified log pattern from a LogPatternSet.
     */
    override suspend fun deleteLogPattern(input: DeleteLogPatternRequest): DeleteLogPatternResponse {
        val op = SdkHttpOperation.build<DeleteLogPatternRequest, DeleteLogPatternResponse> {
            serializer = DeleteLogPatternOperationSerializer()
            deserializer = DeleteLogPatternOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteLogPattern"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "applicationinsights"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the application.
     */
    override suspend fun describeApplication(input: DescribeApplicationRequest): DescribeApplicationResponse {
        val op = SdkHttpOperation.build<DescribeApplicationRequest, DescribeApplicationResponse> {
            serializer = DescribeApplicationOperationSerializer()
            deserializer = DescribeApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeApplication"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "applicationinsights"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a component and lists the resources that are grouped together in a component.
     */
    override suspend fun describeComponent(input: DescribeComponentRequest): DescribeComponentResponse {
        val op = SdkHttpOperation.build<DescribeComponentRequest, DescribeComponentResponse> {
            serializer = DescribeComponentOperationSerializer()
            deserializer = DescribeComponentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeComponent"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "applicationinsights"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the monitoring configuration of the component.
     */
    override suspend fun describeComponentConfiguration(input: DescribeComponentConfigurationRequest): DescribeComponentConfigurationResponse {
        val op = SdkHttpOperation.build<DescribeComponentConfigurationRequest, DescribeComponentConfigurationResponse> {
            serializer = DescribeComponentConfigurationOperationSerializer()
            deserializer = DescribeComponentConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeComponentConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "applicationinsights"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the recommended monitoring configuration of the component.
     */
    override suspend fun describeComponentConfigurationRecommendation(input: DescribeComponentConfigurationRecommendationRequest): DescribeComponentConfigurationRecommendationResponse {
        val op = SdkHttpOperation.build<DescribeComponentConfigurationRecommendationRequest, DescribeComponentConfigurationRecommendationResponse> {
            serializer = DescribeComponentConfigurationRecommendationOperationSerializer()
            deserializer = DescribeComponentConfigurationRecommendationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeComponentConfigurationRecommendation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "applicationinsights"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describe a specific log pattern from a LogPatternSet.
     */
    override suspend fun describeLogPattern(input: DescribeLogPatternRequest): DescribeLogPatternResponse {
        val op = SdkHttpOperation.build<DescribeLogPatternRequest, DescribeLogPatternResponse> {
            serializer = DescribeLogPatternOperationSerializer()
            deserializer = DescribeLogPatternOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeLogPattern"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "applicationinsights"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes an anomaly or error with the application.
     */
    override suspend fun describeObservation(input: DescribeObservationRequest): DescribeObservationResponse {
        val op = SdkHttpOperation.build<DescribeObservationRequest, DescribeObservationResponse> {
            serializer = DescribeObservationOperationSerializer()
            deserializer = DescribeObservationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeObservation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "applicationinsights"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes an application problem.
     */
    override suspend fun describeProblem(input: DescribeProblemRequest): DescribeProblemResponse {
        val op = SdkHttpOperation.build<DescribeProblemRequest, DescribeProblemResponse> {
            serializer = DescribeProblemOperationSerializer()
            deserializer = DescribeProblemOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeProblem"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "applicationinsights"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the anomalies or errors associated with the problem.
     */
    override suspend fun describeProblemObservations(input: DescribeProblemObservationsRequest): DescribeProblemObservationsResponse {
        val op = SdkHttpOperation.build<DescribeProblemObservationsRequest, DescribeProblemObservationsResponse> {
            serializer = DescribeProblemObservationsOperationSerializer()
            deserializer = DescribeProblemObservationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeProblemObservations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "applicationinsights"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the IDs of the applications that you are monitoring.
     */
    override suspend fun listApplications(input: ListApplicationsRequest): ListApplicationsResponse {
        val op = SdkHttpOperation.build<ListApplicationsRequest, ListApplicationsResponse> {
            serializer = ListApplicationsOperationSerializer()
            deserializer = ListApplicationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListApplications"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "applicationinsights"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the auto-grouped, standalone, and custom components of the application.
     */
    override suspend fun listComponents(input: ListComponentsRequest): ListComponentsResponse {
        val op = SdkHttpOperation.build<ListComponentsRequest, ListComponentsResponse> {
            serializer = ListComponentsOperationSerializer()
            deserializer = ListComponentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListComponents"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "applicationinsights"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the INFO, WARN, and ERROR events for periodic configuration updates performed by Application Insights. Examples of events represented are:
     * INFO: creating a new alarm or updating an alarm threshold.
     * WARN: alarm not created due to insufficient data points used to predict thresholds.
     * ERROR: alarm not created due to permission errors or exceeding quotas.
     */
    override suspend fun listConfigurationHistory(input: ListConfigurationHistoryRequest): ListConfigurationHistoryResponse {
        val op = SdkHttpOperation.build<ListConfigurationHistoryRequest, ListConfigurationHistoryResponse> {
            serializer = ListConfigurationHistoryOperationSerializer()
            deserializer = ListConfigurationHistoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListConfigurationHistory"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "applicationinsights"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the log pattern sets in the specific application.
     */
    override suspend fun listLogPatternSets(input: ListLogPatternSetsRequest): ListLogPatternSetsResponse {
        val op = SdkHttpOperation.build<ListLogPatternSetsRequest, ListLogPatternSetsResponse> {
            serializer = ListLogPatternSetsOperationSerializer()
            deserializer = ListLogPatternSetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListLogPatternSets"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "applicationinsights"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the log patterns in the specific log LogPatternSet.
     */
    override suspend fun listLogPatterns(input: ListLogPatternsRequest): ListLogPatternsResponse {
        val op = SdkHttpOperation.build<ListLogPatternsRequest, ListLogPatternsResponse> {
            serializer = ListLogPatternsOperationSerializer()
            deserializer = ListLogPatternsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListLogPatterns"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "applicationinsights"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the problems with your application.
     */
    override suspend fun listProblems(input: ListProblemsRequest): ListProblemsResponse {
        val op = SdkHttpOperation.build<ListProblemsRequest, ListProblemsResponse> {
            serializer = ListProblemsOperationSerializer()
            deserializer = ListProblemsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListProblems"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "applicationinsights"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieve a list of the tags (keys and values) that are associated with a specified
     * application. A tag is a label that you optionally define and associate
     * with an application. Each tag consists of a required tag key and an
     * optional associated tag value. A tag key is a general label that
     * acts as a category for more specific tag values. A tag value acts as a descriptor within
     * a tag key.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "applicationinsights"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Add one or more tags (keys and values) to a specified application. A
     * tag is a label that you optionally define and associate with an
     * application. Tags can help you categorize and manage application in different ways, such as
     * by purpose, owner, environment, or other criteria.
     * Each tag consists of a required tag key and an
     * associated tag value, both of which you define. A tag key is a
     * general label that acts as a category for more specific tag values. A tag value acts as
     * a descriptor within a tag key.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "applicationinsights"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Remove one or more tags (keys and values) from a specified application.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "applicationinsights"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the application.
     */
    override suspend fun updateApplication(input: UpdateApplicationRequest): UpdateApplicationResponse {
        val op = SdkHttpOperation.build<UpdateApplicationRequest, UpdateApplicationResponse> {
            serializer = UpdateApplicationOperationSerializer()
            deserializer = UpdateApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateApplication"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "applicationinsights"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the custom component name and/or the list of resources that make up the
     * component.
     */
    override suspend fun updateComponent(input: UpdateComponentRequest): UpdateComponentResponse {
        val op = SdkHttpOperation.build<UpdateComponentRequest, UpdateComponentResponse> {
            serializer = UpdateComponentOperationSerializer()
            deserializer = UpdateComponentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateComponent"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "applicationinsights"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the monitoring configurations for the component. The configuration input parameter
     * is an escaped JSON of the configuration and should match the schema of what is returned
     * by DescribeComponentConfigurationRecommendation.
     */
    override suspend fun updateComponentConfiguration(input: UpdateComponentConfigurationRequest): UpdateComponentConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateComponentConfigurationRequest, UpdateComponentConfigurationResponse> {
            serializer = UpdateComponentConfigurationOperationSerializer()
            deserializer = UpdateComponentConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateComponentConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "applicationinsights"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds a log pattern to a LogPatternSet.
     */
    override suspend fun updateLogPattern(input: UpdateLogPatternRequest): UpdateLogPatternResponse {
        val op = SdkHttpOperation.build<UpdateLogPatternRequest, UpdateLogPatternResponse> {
            serializer = UpdateLogPatternOperationSerializer()
            deserializer = UpdateLogPatternOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateLogPattern"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "applicationinsights"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
    }
}
