// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationinsights.model



/**
 * An object that defines the tags associated with an application.
 * A tag is a label that you optionally define and associate with
 * an application. Tags can help you categorize and manage resources in different ways, such as
 * by purpose, owner, environment, or other criteria.
 * Each tag consists of a required tag key and an
 * associated tag value, both of which you define. A tag key is a
 * general label that acts as a category for a more specific tag value. A tag value acts as
 * a descriptor within a tag key. A tag key can contain as many as 128 characters. A tag
 * value can contain as many as 256 characters. The characters can be Unicode letters,
 * digits, white space, or one of the following symbols: _ . : / = + -. The following
 * additional restrictions apply to tags:
 * Tag keys and values are case sensitive.
 * For each associated resource, each tag key must be unique and it can have only
 * one value.
 * The aws: prefix is reserved for use by AWS; you can’t use it in
 * any tag keys or values that you define. In addition, you can't edit or remove
 * tag keys or values that use this prefix.
 */
class Tag private constructor(builder: Builder) {
    /**
     * One part of a key-value pair that defines a tag. The maximum length of a tag key is
     * 128 characters. The minimum length is 1 character.
     */
    val key: kotlin.String? = builder.key
    /**
     * The optional part of a key-value pair that defines a tag. The maximum length of a tag
     * value is 256 characters. The minimum length is 0 characters. If you don't want an
     * application to have a specific tag value, don't specify a value for this parameter.
     */
    val value: kotlin.String? = builder.value

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.applicationinsights.model.Tag = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Tag(")
        append("key=$key,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = key?.hashCode() ?: 0
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Tag

        if (key != other.key) return false
        if (value != other.value) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.applicationinsights.model.Tag = Builder(this).apply(block).build()

    class Builder {
        /**
         * One part of a key-value pair that defines a tag. The maximum length of a tag key is
         * 128 characters. The minimum length is 1 character.
         */
        var key: kotlin.String? = null
        /**
         * The optional part of a key-value pair that defines a tag. The maximum length of a tag
         * value is 256 characters. The minimum length is 0 characters. If you don't want an
         * application to have a specific tag value, don't specify a value for this parameter.
         */
        var value: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.applicationinsights.model.Tag) : this() {
            this.key = x.key
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.applicationinsights.model.Tag = Tag(this)
    }
}
