// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationinsights.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.applicationinsights.model.ApplicationInsightsException
import aws.sdk.kotlin.services.applicationinsights.model.DescribeComponentConfigurationResponse
import aws.sdk.kotlin.services.applicationinsights.model.Tier
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeComponentConfigurationOperationDeserializer: HttpDeserialize<DescribeComponentConfigurationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeComponentConfigurationResponse {
        if (!response.status.isSuccess()) {
            throwDescribeComponentConfigurationError(context, response)
        }
        val builder = DescribeComponentConfigurationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeComponentConfigurationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeDescribeComponentConfigurationOperationBody(builder: DescribeComponentConfigurationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COMPONENTCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ComponentConfiguration"))
    val MONITOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("Monitor"))
    val TIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Tier"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMPONENTCONFIGURATION_DESCRIPTOR)
        field(MONITOR_DESCRIPTOR)
        field(TIER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COMPONENTCONFIGURATION_DESCRIPTOR.index -> builder.componentConfiguration = deserializeString()
                MONITOR_DESCRIPTOR.index -> builder.monitor = deserializeBoolean()
                TIER_DESCRIPTOR.index -> builder.tier = deserializeString().let { Tier.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDescribeComponentConfigurationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ApplicationInsightsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "ValidationException" -> ValidationExceptionDeserializer()
        else -> throw ApplicationInsightsException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
