// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationinsights.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.applicationinsights.model.ApplicationInsightsException
import aws.sdk.kotlin.services.applicationinsights.model.ListLogPatternsResponse
import aws.sdk.kotlin.services.applicationinsights.model.LogPattern
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListLogPatternsOperationDeserializer: HttpDeserialize<ListLogPatternsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListLogPatternsResponse {
        if (!response.status.isSuccess()) {
            throwListLogPatternsError(context, response)
        }
        val builder = ListLogPatternsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListLogPatternsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListLogPatternsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ApplicationInsightsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ApplicationInsightsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListLogPatternsOperationBody(builder: ListLogPatternsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val LOGPATTERNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("LogPatterns"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val RESOURCEGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ResourceGroupName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LOGPATTERNS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(RESOURCEGROUPNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LOGPATTERNS_DESCRIPTOR.index -> builder.logPatterns =
                    deserializer.deserializeList(LOGPATTERNS_DESCRIPTOR) {
                        val col0 = mutableListOf<LogPattern>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeLogPatternDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                RESOURCEGROUPNAME_DESCRIPTOR.index -> builder.resourceGroupName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
