// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationinsights.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a problem that is detected by correlating observations.
 */
class Problem private constructor(builder: Builder) {
    /**
     * The resource affected by the problem.
     */
    val affectedResource: kotlin.String? = builder.affectedResource
    /**
     * The time when the problem ended, in epoch seconds.
     */
    val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * Feedback provided by the user about the problem.
     */
    val feedback: Map<String, FeedbackValue>? = builder.feedback
    /**
     * The ID of the problem.
     */
    val id: kotlin.String? = builder.id
    /**
     * A detailed analysis of the problem using machine learning.
     */
    val insights: kotlin.String? = builder.insights
    /**
     * The last time that the problem reoccurred after its last resolution.
     */
    val lastRecurrenceTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastRecurrenceTime
    /**
     * The number of times that the same problem reoccurred after the first time it was resolved.
     */
    val recurringCount: kotlin.Long? = builder.recurringCount
    /**
     * The name of the resource group affected by the problem.
     */
    val resourceGroupName: kotlin.String? = builder.resourceGroupName
    /**
     * A measure of the level of impact of the problem.
     */
    val severityLevel: aws.sdk.kotlin.services.applicationinsights.model.SeverityLevel? = builder.severityLevel
    /**
     * The time when the problem started, in epoch seconds.
     */
    val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The status of the problem.
     */
    val status: aws.sdk.kotlin.services.applicationinsights.model.Status? = builder.status
    /**
     * The name of the problem.
     */
    val title: kotlin.String? = builder.title

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.applicationinsights.model.Problem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Problem(")
        append("affectedResource=$affectedResource,")
        append("endTime=$endTime,")
        append("feedback=$feedback,")
        append("id=$id,")
        append("insights=$insights,")
        append("lastRecurrenceTime=$lastRecurrenceTime,")
        append("recurringCount=$recurringCount,")
        append("resourceGroupName=$resourceGroupName,")
        append("severityLevel=$severityLevel,")
        append("startTime=$startTime,")
        append("status=$status,")
        append("title=$title)")
    }

    override fun hashCode(): kotlin.Int {
        var result = affectedResource?.hashCode() ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (feedback?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (insights?.hashCode() ?: 0)
        result = 31 * result + (lastRecurrenceTime?.hashCode() ?: 0)
        result = 31 * result + (recurringCount?.hashCode() ?: 0)
        result = 31 * result + (resourceGroupName?.hashCode() ?: 0)
        result = 31 * result + (severityLevel?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Problem

        if (affectedResource != other.affectedResource) return false
        if (endTime != other.endTime) return false
        if (feedback != other.feedback) return false
        if (id != other.id) return false
        if (insights != other.insights) return false
        if (lastRecurrenceTime != other.lastRecurrenceTime) return false
        if (recurringCount != other.recurringCount) return false
        if (resourceGroupName != other.resourceGroupName) return false
        if (severityLevel != other.severityLevel) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false
        if (title != other.title) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.applicationinsights.model.Problem = Builder(this).apply(block).build()

    class Builder {
        /**
         * The resource affected by the problem.
         */
        var affectedResource: kotlin.String? = null
        /**
         * The time when the problem ended, in epoch seconds.
         */
        var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Feedback provided by the user about the problem.
         */
        var feedback: Map<String, FeedbackValue>? = null
        /**
         * The ID of the problem.
         */
        var id: kotlin.String? = null
        /**
         * A detailed analysis of the problem using machine learning.
         */
        var insights: kotlin.String? = null
        /**
         * The last time that the problem reoccurred after its last resolution.
         */
        var lastRecurrenceTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of times that the same problem reoccurred after the first time it was resolved.
         */
        var recurringCount: kotlin.Long? = null
        /**
         * The name of the resource group affected by the problem.
         */
        var resourceGroupName: kotlin.String? = null
        /**
         * A measure of the level of impact of the problem.
         */
        var severityLevel: aws.sdk.kotlin.services.applicationinsights.model.SeverityLevel? = null
        /**
         * The time when the problem started, in epoch seconds.
         */
        var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the problem.
         */
        var status: aws.sdk.kotlin.services.applicationinsights.model.Status? = null
        /**
         * The name of the problem.
         */
        var title: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.applicationinsights.model.Problem) : this() {
            this.affectedResource = x.affectedResource
            this.endTime = x.endTime
            this.feedback = x.feedback
            this.id = x.id
            this.insights = x.insights
            this.lastRecurrenceTime = x.lastRecurrenceTime
            this.recurringCount = x.recurringCount
            this.resourceGroupName = x.resourceGroupName
            this.severityLevel = x.severityLevel
            this.startTime = x.startTime
            this.status = x.status
            this.title = x.title
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.applicationinsights.model.Problem = Problem(this)
    }
}
