// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationinsights.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.applicationinsights.model.ApplicationInsightsException
import aws.sdk.kotlin.services.applicationinsights.model.LogPattern
import aws.sdk.kotlin.services.applicationinsights.model.UpdateLogPatternResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateLogPatternOperationDeserializer: HttpDeserialize<UpdateLogPatternResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateLogPatternResponse {
        if (!response.status.isSuccess()) {
            throwUpdateLogPatternError(context, response)
        }
        val builder = UpdateLogPatternResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateLogPatternOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateLogPatternError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ApplicationInsightsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceInUseException" -> ResourceInUseExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ApplicationInsightsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateLogPatternOperationBody(builder: UpdateLogPatternResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val LOGPATTERN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LogPattern"))
    val RESOURCEGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ResourceGroupName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LOGPATTERN_DESCRIPTOR)
        field(RESOURCEGROUPNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LOGPATTERN_DESCRIPTOR.index -> builder.logPattern = deserializeLogPatternDocument(deserializer)
                RESOURCEGROUPNAME_DESCRIPTOR.index -> builder.resourceGroupName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
