// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationinsights.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.applicationinsights.model.ApplicationInsightsException
import aws.sdk.kotlin.services.applicationinsights.model.DescribeComponentConfigurationRecommendationResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeComponentConfigurationRecommendationOperationDeserializer: HttpDeserialize<DescribeComponentConfigurationRecommendationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeComponentConfigurationRecommendationResponse {
        if (!response.status.isSuccess()) {
            throwDescribeComponentConfigurationRecommendationError(context, response)
        }
        val builder = DescribeComponentConfigurationRecommendationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeComponentConfigurationRecommendationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeComponentConfigurationRecommendationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ApplicationInsightsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ApplicationInsightsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeComponentConfigurationRecommendationOperationBody(builder: DescribeComponentConfigurationRecommendationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COMPONENTCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ComponentConfiguration"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMPONENTCONFIGURATION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COMPONENTCONFIGURATION_DESCRIPTOR.index -> builder.componentConfiguration = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
