// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationinsights

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.applicationinsights.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.applicationinsights.endpoints.EndpointProvider
import aws.sdk.kotlin.services.applicationinsights.model.*
import aws.sdk.kotlin.services.applicationinsights.model.CreateApplicationRequest
import aws.sdk.kotlin.services.applicationinsights.model.CreateApplicationResponse
import aws.sdk.kotlin.services.applicationinsights.model.CreateComponentRequest
import aws.sdk.kotlin.services.applicationinsights.model.CreateComponentResponse
import aws.sdk.kotlin.services.applicationinsights.model.CreateLogPatternRequest
import aws.sdk.kotlin.services.applicationinsights.model.CreateLogPatternResponse
import aws.sdk.kotlin.services.applicationinsights.model.DeleteApplicationRequest
import aws.sdk.kotlin.services.applicationinsights.model.DeleteApplicationResponse
import aws.sdk.kotlin.services.applicationinsights.model.DeleteComponentRequest
import aws.sdk.kotlin.services.applicationinsights.model.DeleteComponentResponse
import aws.sdk.kotlin.services.applicationinsights.model.DeleteLogPatternRequest
import aws.sdk.kotlin.services.applicationinsights.model.DeleteLogPatternResponse
import aws.sdk.kotlin.services.applicationinsights.model.DescribeApplicationRequest
import aws.sdk.kotlin.services.applicationinsights.model.DescribeApplicationResponse
import aws.sdk.kotlin.services.applicationinsights.model.DescribeComponentConfigurationRecommendationRequest
import aws.sdk.kotlin.services.applicationinsights.model.DescribeComponentConfigurationRecommendationResponse
import aws.sdk.kotlin.services.applicationinsights.model.DescribeComponentConfigurationRequest
import aws.sdk.kotlin.services.applicationinsights.model.DescribeComponentConfigurationResponse
import aws.sdk.kotlin.services.applicationinsights.model.DescribeComponentRequest
import aws.sdk.kotlin.services.applicationinsights.model.DescribeComponentResponse
import aws.sdk.kotlin.services.applicationinsights.model.DescribeLogPatternRequest
import aws.sdk.kotlin.services.applicationinsights.model.DescribeLogPatternResponse
import aws.sdk.kotlin.services.applicationinsights.model.DescribeObservationRequest
import aws.sdk.kotlin.services.applicationinsights.model.DescribeObservationResponse
import aws.sdk.kotlin.services.applicationinsights.model.DescribeProblemObservationsRequest
import aws.sdk.kotlin.services.applicationinsights.model.DescribeProblemObservationsResponse
import aws.sdk.kotlin.services.applicationinsights.model.DescribeProblemRequest
import aws.sdk.kotlin.services.applicationinsights.model.DescribeProblemResponse
import aws.sdk.kotlin.services.applicationinsights.model.ListApplicationsRequest
import aws.sdk.kotlin.services.applicationinsights.model.ListApplicationsResponse
import aws.sdk.kotlin.services.applicationinsights.model.ListComponentsRequest
import aws.sdk.kotlin.services.applicationinsights.model.ListComponentsResponse
import aws.sdk.kotlin.services.applicationinsights.model.ListConfigurationHistoryRequest
import aws.sdk.kotlin.services.applicationinsights.model.ListConfigurationHistoryResponse
import aws.sdk.kotlin.services.applicationinsights.model.ListLogPatternSetsRequest
import aws.sdk.kotlin.services.applicationinsights.model.ListLogPatternSetsResponse
import aws.sdk.kotlin.services.applicationinsights.model.ListLogPatternsRequest
import aws.sdk.kotlin.services.applicationinsights.model.ListLogPatternsResponse
import aws.sdk.kotlin.services.applicationinsights.model.ListProblemsRequest
import aws.sdk.kotlin.services.applicationinsights.model.ListProblemsResponse
import aws.sdk.kotlin.services.applicationinsights.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.applicationinsights.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.applicationinsights.model.TagResourceRequest
import aws.sdk.kotlin.services.applicationinsights.model.TagResourceResponse
import aws.sdk.kotlin.services.applicationinsights.model.UntagResourceRequest
import aws.sdk.kotlin.services.applicationinsights.model.UntagResourceResponse
import aws.sdk.kotlin.services.applicationinsights.model.UpdateApplicationRequest
import aws.sdk.kotlin.services.applicationinsights.model.UpdateApplicationResponse
import aws.sdk.kotlin.services.applicationinsights.model.UpdateComponentConfigurationRequest
import aws.sdk.kotlin.services.applicationinsights.model.UpdateComponentConfigurationResponse
import aws.sdk.kotlin.services.applicationinsights.model.UpdateComponentRequest
import aws.sdk.kotlin.services.applicationinsights.model.UpdateComponentResponse
import aws.sdk.kotlin.services.applicationinsights.model.UpdateLogPatternRequest
import aws.sdk.kotlin.services.applicationinsights.model.UpdateLogPatternResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig

/**
 * # Amazon CloudWatch Application Insights
 *  Amazon CloudWatch Application Insights is a service that helps you detect common problems with your applications. It enables you to pinpoint the source of issues in your applications (built with technologies such as Microsoft IIS, .NET, and Microsoft SQL Server), by providing key insights into detected problems.
 *
 * After you onboard your application, CloudWatch Application Insights identifies, recommends, and sets up metrics and logs. It continuously analyzes and correlates your metrics and logs for unusual behavior to surface actionable problems with your application. For example, if your application is slow and unresponsive and leading to HTTP 500 errors in your Application Load Balancer (ALB), Application Insights informs you that a memory pressure problem with your SQL Server database is occurring. It bases this analysis on impactful metrics and log errors.
 */
public interface ApplicationInsightsClient : SdkClient {

    override val serviceName: String
        get() = "Application Insights"
    /**
     * ApplicationInsightsClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): ApplicationInsightsClient {
            val config = Config.Builder().apply(block).build()
            return DefaultApplicationInsightsClient(config)
        }

        public operator fun invoke(config: Config): ApplicationInsightsClient = DefaultApplicationInsightsClient(config)

        /**
         * Construct a [ApplicationInsightsClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): ApplicationInsightsClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultApplicationInsightsClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig, TracingClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, "Application Insights")
        public val useDualStack: Boolean = builder.useDualStack
        public val useFips: Boolean = builder.useFips
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * The endpoint provider used to determine where to make service requests.
             */
            public var endpointProvider: EndpointProvider? = null
            /**
             * A custom endpoint to use when making requests.
             */
            public var endpointUrl: Url? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null
            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            public var tracer: Tracer? = null
            /**
             * Flag to toggle whether to use dual-stack endpoints when making requests.
             */
            public var useDualStack: Boolean = false
            /**
             * Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             */
            public var useFips: Boolean = false

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Adds an application that is created from a resource group.
     */
    public suspend fun createApplication(input: CreateApplicationRequest = CreateApplicationRequest {}): CreateApplicationResponse

    /**
     * Creates a custom component by grouping similar standalone instances to monitor.
     */
    public suspend fun createComponent(input: CreateComponentRequest): CreateComponentResponse

    /**
     * Adds an log pattern to a `LogPatternSet`.
     */
    public suspend fun createLogPattern(input: CreateLogPatternRequest): CreateLogPatternResponse

    /**
     * Removes the specified application from monitoring. Does not delete the application.
     */
    public suspend fun deleteApplication(input: DeleteApplicationRequest): DeleteApplicationResponse

    /**
     * Ungroups a custom component. When you ungroup custom components, all applicable monitors that are set up for the component are removed and the instances revert to their standalone status.
     */
    public suspend fun deleteComponent(input: DeleteComponentRequest): DeleteComponentResponse

    /**
     * Removes the specified log pattern from a `LogPatternSet`.
     */
    public suspend fun deleteLogPattern(input: DeleteLogPatternRequest): DeleteLogPatternResponse

    /**
     * Describes the application.
     */
    public suspend fun describeApplication(input: DescribeApplicationRequest): DescribeApplicationResponse

    /**
     * Describes a component and lists the resources that are grouped together in a component.
     */
    public suspend fun describeComponent(input: DescribeComponentRequest): DescribeComponentResponse

    /**
     * Describes the monitoring configuration of the component.
     */
    public suspend fun describeComponentConfiguration(input: DescribeComponentConfigurationRequest): DescribeComponentConfigurationResponse

    /**
     * Describes the recommended monitoring configuration of the component.
     */
    public suspend fun describeComponentConfigurationRecommendation(input: DescribeComponentConfigurationRecommendationRequest): DescribeComponentConfigurationRecommendationResponse

    /**
     * Describe a specific log pattern from a `LogPatternSet`.
     */
    public suspend fun describeLogPattern(input: DescribeLogPatternRequest): DescribeLogPatternResponse

    /**
     * Describes an anomaly or error with the application.
     */
    public suspend fun describeObservation(input: DescribeObservationRequest): DescribeObservationResponse

    /**
     * Describes an application problem.
     */
    public suspend fun describeProblem(input: DescribeProblemRequest): DescribeProblemResponse

    /**
     * Describes the anomalies or errors associated with the problem.
     */
    public suspend fun describeProblemObservations(input: DescribeProblemObservationsRequest): DescribeProblemObservationsResponse

    /**
     * Lists the IDs of the applications that you are monitoring.
     */
    public suspend fun listApplications(input: ListApplicationsRequest = ListApplicationsRequest {}): ListApplicationsResponse

    /**
     * Lists the auto-grouped, standalone, and custom components of the application.
     */
    public suspend fun listComponents(input: ListComponentsRequest): ListComponentsResponse

    /**
     * Lists the INFO, WARN, and ERROR events for periodic configuration updates performed by Application Insights. Examples of events represented are:
     * + INFO: creating a new alarm or updating an alarm threshold.
     * + WARN: alarm not created due to insufficient data points used to predict thresholds.
     * + ERROR: alarm not created due to permission errors or exceeding quotas.
     */
    public suspend fun listConfigurationHistory(input: ListConfigurationHistoryRequest = ListConfigurationHistoryRequest {}): ListConfigurationHistoryResponse

    /**
     * Lists the log pattern sets in the specific application.
     */
    public suspend fun listLogPatternSets(input: ListLogPatternSetsRequest): ListLogPatternSetsResponse

    /**
     * Lists the log patterns in the specific log `LogPatternSet`.
     */
    public suspend fun listLogPatterns(input: ListLogPatternsRequest): ListLogPatternsResponse

    /**
     * Lists the problems with your application.
     */
    public suspend fun listProblems(input: ListProblemsRequest = ListProblemsRequest {}): ListProblemsResponse

    /**
     * Retrieve a list of the tags (keys and values) that are associated with a specified application. A *tag* is a label that you optionally define and associate with an application. Each tag consists of a required *tag key* and an optional associated *tag value*. A tag key is a general label that acts as a category for more specific tag values. A tag value acts as a descriptor within a tag key.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Add one or more tags (keys and values) to a specified application. A *tag* is a label that you optionally define and associate with an application. Tags can help you categorize and manage application in different ways, such as by purpose, owner, environment, or other criteria.
     *
     * Each tag consists of a required *tag key* and an associated *tag value*, both of which you define. A tag key is a general label that acts as a category for more specific tag values. A tag value acts as a descriptor within a tag key.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Remove one or more tags (keys and values) from a specified application.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the application.
     */
    public suspend fun updateApplication(input: UpdateApplicationRequest): UpdateApplicationResponse

    /**
     * Updates the custom component name and/or the list of resources that make up the component.
     */
    public suspend fun updateComponent(input: UpdateComponentRequest): UpdateComponentResponse

    /**
     * Updates the monitoring configurations for the component. The configuration input parameter is an escaped JSON of the configuration and should match the schema of what is returned by `DescribeComponentConfigurationRecommendation`.
     */
    public suspend fun updateComponentConfiguration(input: UpdateComponentConfigurationRequest): UpdateComponentConfigurationResponse

    /**
     * Adds a log pattern to a `LogPatternSet`.
     */
    public suspend fun updateLogPattern(input: UpdateLogPatternRequest): UpdateLogPatternResponse
}

/**
 * Adds an application that is created from a resource group.
 */
public suspend inline fun ApplicationInsightsClient.createApplication(crossinline block: CreateApplicationRequest.Builder.() -> Unit): CreateApplicationResponse = createApplication(CreateApplicationRequest.Builder().apply(block).build())

/**
 * Creates a custom component by grouping similar standalone instances to monitor.
 */
public suspend inline fun ApplicationInsightsClient.createComponent(crossinline block: CreateComponentRequest.Builder.() -> Unit): CreateComponentResponse = createComponent(CreateComponentRequest.Builder().apply(block).build())

/**
 * Adds an log pattern to a `LogPatternSet`.
 */
public suspend inline fun ApplicationInsightsClient.createLogPattern(crossinline block: CreateLogPatternRequest.Builder.() -> Unit): CreateLogPatternResponse = createLogPattern(CreateLogPatternRequest.Builder().apply(block).build())

/**
 * Removes the specified application from monitoring. Does not delete the application.
 */
public suspend inline fun ApplicationInsightsClient.deleteApplication(crossinline block: DeleteApplicationRequest.Builder.() -> Unit): DeleteApplicationResponse = deleteApplication(DeleteApplicationRequest.Builder().apply(block).build())

/**
 * Ungroups a custom component. When you ungroup custom components, all applicable monitors that are set up for the component are removed and the instances revert to their standalone status.
 */
public suspend inline fun ApplicationInsightsClient.deleteComponent(crossinline block: DeleteComponentRequest.Builder.() -> Unit): DeleteComponentResponse = deleteComponent(DeleteComponentRequest.Builder().apply(block).build())

/**
 * Removes the specified log pattern from a `LogPatternSet`.
 */
public suspend inline fun ApplicationInsightsClient.deleteLogPattern(crossinline block: DeleteLogPatternRequest.Builder.() -> Unit): DeleteLogPatternResponse = deleteLogPattern(DeleteLogPatternRequest.Builder().apply(block).build())

/**
 * Describes the application.
 */
public suspend inline fun ApplicationInsightsClient.describeApplication(crossinline block: DescribeApplicationRequest.Builder.() -> Unit): DescribeApplicationResponse = describeApplication(DescribeApplicationRequest.Builder().apply(block).build())

/**
 * Describes a component and lists the resources that are grouped together in a component.
 */
public suspend inline fun ApplicationInsightsClient.describeComponent(crossinline block: DescribeComponentRequest.Builder.() -> Unit): DescribeComponentResponse = describeComponent(DescribeComponentRequest.Builder().apply(block).build())

/**
 * Describes the monitoring configuration of the component.
 */
public suspend inline fun ApplicationInsightsClient.describeComponentConfiguration(crossinline block: DescribeComponentConfigurationRequest.Builder.() -> Unit): DescribeComponentConfigurationResponse = describeComponentConfiguration(DescribeComponentConfigurationRequest.Builder().apply(block).build())

/**
 * Describes the recommended monitoring configuration of the component.
 */
public suspend inline fun ApplicationInsightsClient.describeComponentConfigurationRecommendation(crossinline block: DescribeComponentConfigurationRecommendationRequest.Builder.() -> Unit): DescribeComponentConfigurationRecommendationResponse = describeComponentConfigurationRecommendation(DescribeComponentConfigurationRecommendationRequest.Builder().apply(block).build())

/**
 * Describe a specific log pattern from a `LogPatternSet`.
 */
public suspend inline fun ApplicationInsightsClient.describeLogPattern(crossinline block: DescribeLogPatternRequest.Builder.() -> Unit): DescribeLogPatternResponse = describeLogPattern(DescribeLogPatternRequest.Builder().apply(block).build())

/**
 * Describes an anomaly or error with the application.
 */
public suspend inline fun ApplicationInsightsClient.describeObservation(crossinline block: DescribeObservationRequest.Builder.() -> Unit): DescribeObservationResponse = describeObservation(DescribeObservationRequest.Builder().apply(block).build())

/**
 * Describes an application problem.
 */
public suspend inline fun ApplicationInsightsClient.describeProblem(crossinline block: DescribeProblemRequest.Builder.() -> Unit): DescribeProblemResponse = describeProblem(DescribeProblemRequest.Builder().apply(block).build())

/**
 * Describes the anomalies or errors associated with the problem.
 */
public suspend inline fun ApplicationInsightsClient.describeProblemObservations(crossinline block: DescribeProblemObservationsRequest.Builder.() -> Unit): DescribeProblemObservationsResponse = describeProblemObservations(DescribeProblemObservationsRequest.Builder().apply(block).build())

/**
 * Lists the IDs of the applications that you are monitoring.
 */
public suspend inline fun ApplicationInsightsClient.listApplications(crossinline block: ListApplicationsRequest.Builder.() -> Unit): ListApplicationsResponse = listApplications(ListApplicationsRequest.Builder().apply(block).build())

/**
 * Lists the auto-grouped, standalone, and custom components of the application.
 */
public suspend inline fun ApplicationInsightsClient.listComponents(crossinline block: ListComponentsRequest.Builder.() -> Unit): ListComponentsResponse = listComponents(ListComponentsRequest.Builder().apply(block).build())

/**
 * Lists the INFO, WARN, and ERROR events for periodic configuration updates performed by Application Insights. Examples of events represented are:
 * + INFO: creating a new alarm or updating an alarm threshold.
 * + WARN: alarm not created due to insufficient data points used to predict thresholds.
 * + ERROR: alarm not created due to permission errors or exceeding quotas.
 */
public suspend inline fun ApplicationInsightsClient.listConfigurationHistory(crossinline block: ListConfigurationHistoryRequest.Builder.() -> Unit): ListConfigurationHistoryResponse = listConfigurationHistory(ListConfigurationHistoryRequest.Builder().apply(block).build())

/**
 * Lists the log pattern sets in the specific application.
 */
public suspend inline fun ApplicationInsightsClient.listLogPatternSets(crossinline block: ListLogPatternSetsRequest.Builder.() -> Unit): ListLogPatternSetsResponse = listLogPatternSets(ListLogPatternSetsRequest.Builder().apply(block).build())

/**
 * Lists the log patterns in the specific log `LogPatternSet`.
 */
public suspend inline fun ApplicationInsightsClient.listLogPatterns(crossinline block: ListLogPatternsRequest.Builder.() -> Unit): ListLogPatternsResponse = listLogPatterns(ListLogPatternsRequest.Builder().apply(block).build())

/**
 * Lists the problems with your application.
 */
public suspend inline fun ApplicationInsightsClient.listProblems(crossinline block: ListProblemsRequest.Builder.() -> Unit): ListProblemsResponse = listProblems(ListProblemsRequest.Builder().apply(block).build())

/**
 * Retrieve a list of the tags (keys and values) that are associated with a specified application. A *tag* is a label that you optionally define and associate with an application. Each tag consists of a required *tag key* and an optional associated *tag value*. A tag key is a general label that acts as a category for more specific tag values. A tag value acts as a descriptor within a tag key.
 */
public suspend inline fun ApplicationInsightsClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Add one or more tags (keys and values) to a specified application. A *tag* is a label that you optionally define and associate with an application. Tags can help you categorize and manage application in different ways, such as by purpose, owner, environment, or other criteria.
 *
 * Each tag consists of a required *tag key* and an associated *tag value*, both of which you define. A tag key is a general label that acts as a category for more specific tag values. A tag value acts as a descriptor within a tag key.
 */
public suspend inline fun ApplicationInsightsClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Remove one or more tags (keys and values) from a specified application.
 */
public suspend inline fun ApplicationInsightsClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the application.
 */
public suspend inline fun ApplicationInsightsClient.updateApplication(crossinline block: UpdateApplicationRequest.Builder.() -> Unit): UpdateApplicationResponse = updateApplication(UpdateApplicationRequest.Builder().apply(block).build())

/**
 * Updates the custom component name and/or the list of resources that make up the component.
 */
public suspend inline fun ApplicationInsightsClient.updateComponent(crossinline block: UpdateComponentRequest.Builder.() -> Unit): UpdateComponentResponse = updateComponent(UpdateComponentRequest.Builder().apply(block).build())

/**
 * Updates the monitoring configurations for the component. The configuration input parameter is an escaped JSON of the configuration and should match the schema of what is returned by `DescribeComponentConfigurationRecommendation`.
 */
public suspend inline fun ApplicationInsightsClient.updateComponentConfiguration(crossinline block: UpdateComponentConfigurationRequest.Builder.() -> Unit): UpdateComponentConfigurationResponse = updateComponentConfiguration(UpdateComponentConfigurationRequest.Builder().apply(block).build())

/**
 * Adds a log pattern to a `LogPatternSet`.
 */
public suspend inline fun ApplicationInsightsClient.updateLogPattern(crossinline block: UpdateLogPatternRequest.Builder.() -> Unit): UpdateLogPatternResponse = updateLogPattern(UpdateLogPatternRequest.Builder().apply(block).build())
