// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationinsights

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.applicationinsights.auth.AuthSchemeProviderAdapter
import aws.sdk.kotlin.services.applicationinsights.auth.IdentityProviderConfigAdapter
import aws.sdk.kotlin.services.applicationinsights.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.applicationinsights.model.*
import aws.sdk.kotlin.services.applicationinsights.transform.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.awsprotocol.json.AwsJsonProtocol
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.util.attributesOf
import aws.smithy.kotlin.runtime.util.putIfAbsent
import aws.smithy.kotlin.runtime.util.putIfAbsentNotNull


public const val ServiceApiVersion: String = "2018-11-25"

internal class DefaultApplicationInsightsClient(override val config: ApplicationInsightsClient.Config) : ApplicationInsightsClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = IdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(HttpAuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "applicationinsights")
        }
        toMap()
    }
    private val telemetryScope = "aws.sdk.kotlin.services.applicationinsights"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Adds an application that is created from a resource group.
     */
    override suspend fun createApplication(input: CreateApplicationRequest): CreateApplicationResponse {
        val op = SdkHttpOperation.build<CreateApplicationRequest, CreateApplicationResponse> {
            serializer = CreateApplicationOperationSerializer()
            deserializer = CreateApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateApplication"
                serviceName = ServiceId
            }
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a custom component by grouping similar standalone instances to monitor.
     */
    override suspend fun createComponent(input: CreateComponentRequest): CreateComponentResponse {
        val op = SdkHttpOperation.build<CreateComponentRequest, CreateComponentResponse> {
            serializer = CreateComponentOperationSerializer()
            deserializer = CreateComponentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateComponent"
                serviceName = ServiceId
            }
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds an log pattern to a `LogPatternSet`.
     */
    override suspend fun createLogPattern(input: CreateLogPatternRequest): CreateLogPatternResponse {
        val op = SdkHttpOperation.build<CreateLogPatternRequest, CreateLogPatternResponse> {
            serializer = CreateLogPatternOperationSerializer()
            deserializer = CreateLogPatternOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateLogPattern"
                serviceName = ServiceId
            }
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified application from monitoring. Does not delete the application.
     */
    override suspend fun deleteApplication(input: DeleteApplicationRequest): DeleteApplicationResponse {
        val op = SdkHttpOperation.build<DeleteApplicationRequest, DeleteApplicationResponse> {
            serializer = DeleteApplicationOperationSerializer()
            deserializer = DeleteApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteApplication"
                serviceName = ServiceId
            }
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Ungroups a custom component. When you ungroup custom components, all applicable monitors that are set up for the component are removed and the instances revert to their standalone status.
     */
    override suspend fun deleteComponent(input: DeleteComponentRequest): DeleteComponentResponse {
        val op = SdkHttpOperation.build<DeleteComponentRequest, DeleteComponentResponse> {
            serializer = DeleteComponentOperationSerializer()
            deserializer = DeleteComponentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteComponent"
                serviceName = ServiceId
            }
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified log pattern from a `LogPatternSet`.
     */
    override suspend fun deleteLogPattern(input: DeleteLogPatternRequest): DeleteLogPatternResponse {
        val op = SdkHttpOperation.build<DeleteLogPatternRequest, DeleteLogPatternResponse> {
            serializer = DeleteLogPatternOperationSerializer()
            deserializer = DeleteLogPatternOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteLogPattern"
                serviceName = ServiceId
            }
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the application.
     */
    override suspend fun describeApplication(input: DescribeApplicationRequest): DescribeApplicationResponse {
        val op = SdkHttpOperation.build<DescribeApplicationRequest, DescribeApplicationResponse> {
            serializer = DescribeApplicationOperationSerializer()
            deserializer = DescribeApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeApplication"
                serviceName = ServiceId
            }
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes a component and lists the resources that are grouped together in a component.
     */
    override suspend fun describeComponent(input: DescribeComponentRequest): DescribeComponentResponse {
        val op = SdkHttpOperation.build<DescribeComponentRequest, DescribeComponentResponse> {
            serializer = DescribeComponentOperationSerializer()
            deserializer = DescribeComponentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeComponent"
                serviceName = ServiceId
            }
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the monitoring configuration of the component.
     */
    override suspend fun describeComponentConfiguration(input: DescribeComponentConfigurationRequest): DescribeComponentConfigurationResponse {
        val op = SdkHttpOperation.build<DescribeComponentConfigurationRequest, DescribeComponentConfigurationResponse> {
            serializer = DescribeComponentConfigurationOperationSerializer()
            deserializer = DescribeComponentConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeComponentConfiguration"
                serviceName = ServiceId
            }
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the recommended monitoring configuration of the component.
     */
    override suspend fun describeComponentConfigurationRecommendation(input: DescribeComponentConfigurationRecommendationRequest): DescribeComponentConfigurationRecommendationResponse {
        val op = SdkHttpOperation.build<DescribeComponentConfigurationRecommendationRequest, DescribeComponentConfigurationRecommendationResponse> {
            serializer = DescribeComponentConfigurationRecommendationOperationSerializer()
            deserializer = DescribeComponentConfigurationRecommendationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeComponentConfigurationRecommendation"
                serviceName = ServiceId
            }
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describe a specific log pattern from a `LogPatternSet`.
     */
    override suspend fun describeLogPattern(input: DescribeLogPatternRequest): DescribeLogPatternResponse {
        val op = SdkHttpOperation.build<DescribeLogPatternRequest, DescribeLogPatternResponse> {
            serializer = DescribeLogPatternOperationSerializer()
            deserializer = DescribeLogPatternOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeLogPattern"
                serviceName = ServiceId
            }
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes an anomaly or error with the application.
     */
    override suspend fun describeObservation(input: DescribeObservationRequest): DescribeObservationResponse {
        val op = SdkHttpOperation.build<DescribeObservationRequest, DescribeObservationResponse> {
            serializer = DescribeObservationOperationSerializer()
            deserializer = DescribeObservationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeObservation"
                serviceName = ServiceId
            }
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes an application problem.
     */
    override suspend fun describeProblem(input: DescribeProblemRequest): DescribeProblemResponse {
        val op = SdkHttpOperation.build<DescribeProblemRequest, DescribeProblemResponse> {
            serializer = DescribeProblemOperationSerializer()
            deserializer = DescribeProblemOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeProblem"
                serviceName = ServiceId
            }
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the anomalies or errors associated with the problem.
     */
    override suspend fun describeProblemObservations(input: DescribeProblemObservationsRequest): DescribeProblemObservationsResponse {
        val op = SdkHttpOperation.build<DescribeProblemObservationsRequest, DescribeProblemObservationsResponse> {
            serializer = DescribeProblemObservationsOperationSerializer()
            deserializer = DescribeProblemObservationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeProblemObservations"
                serviceName = ServiceId
            }
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the IDs of the applications that you are monitoring.
     */
    override suspend fun listApplications(input: ListApplicationsRequest): ListApplicationsResponse {
        val op = SdkHttpOperation.build<ListApplicationsRequest, ListApplicationsResponse> {
            serializer = ListApplicationsOperationSerializer()
            deserializer = ListApplicationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListApplications"
                serviceName = ServiceId
            }
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the auto-grouped, standalone, and custom components of the application.
     */
    override suspend fun listComponents(input: ListComponentsRequest): ListComponentsResponse {
        val op = SdkHttpOperation.build<ListComponentsRequest, ListComponentsResponse> {
            serializer = ListComponentsOperationSerializer()
            deserializer = ListComponentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListComponents"
                serviceName = ServiceId
            }
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the INFO, WARN, and ERROR events for periodic configuration updates performed by Application Insights. Examples of events represented are:
     * + INFO: creating a new alarm or updating an alarm threshold.
     * + WARN: alarm not created due to insufficient data points used to predict thresholds.
     * + ERROR: alarm not created due to permission errors or exceeding quotas.
     */
    override suspend fun listConfigurationHistory(input: ListConfigurationHistoryRequest): ListConfigurationHistoryResponse {
        val op = SdkHttpOperation.build<ListConfigurationHistoryRequest, ListConfigurationHistoryResponse> {
            serializer = ListConfigurationHistoryOperationSerializer()
            deserializer = ListConfigurationHistoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListConfigurationHistory"
                serviceName = ServiceId
            }
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the log pattern sets in the specific application.
     */
    override suspend fun listLogPatternSets(input: ListLogPatternSetsRequest): ListLogPatternSetsResponse {
        val op = SdkHttpOperation.build<ListLogPatternSetsRequest, ListLogPatternSetsResponse> {
            serializer = ListLogPatternSetsOperationSerializer()
            deserializer = ListLogPatternSetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListLogPatternSets"
                serviceName = ServiceId
            }
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the log patterns in the specific log `LogPatternSet`.
     */
    override suspend fun listLogPatterns(input: ListLogPatternsRequest): ListLogPatternsResponse {
        val op = SdkHttpOperation.build<ListLogPatternsRequest, ListLogPatternsResponse> {
            serializer = ListLogPatternsOperationSerializer()
            deserializer = ListLogPatternsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListLogPatterns"
                serviceName = ServiceId
            }
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the problems with your application.
     */
    override suspend fun listProblems(input: ListProblemsRequest): ListProblemsResponse {
        val op = SdkHttpOperation.build<ListProblemsRequest, ListProblemsResponse> {
            serializer = ListProblemsOperationSerializer()
            deserializer = ListProblemsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListProblems"
                serviceName = ServiceId
            }
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieve a list of the tags (keys and values) that are associated with a specified application. A *tag* is a label that you optionally define and associate with an application. Each tag consists of a required *tag key* and an optional associated *tag value*. A tag key is a general label that acts as a category for more specific tag values. A tag value acts as a descriptor within a tag key.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListTagsForResource"
                serviceName = ServiceId
            }
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Add one or more tags (keys and values) to a specified application. A *tag* is a label that you optionally define and associate with an application. Tags can help you categorize and manage application in different ways, such as by purpose, owner, environment, or other criteria.
     *
     * Each tag consists of a required *tag key* and an associated *tag value*, both of which you define. A tag key is a general label that acts as a category for more specific tag values. A tag value acts as a descriptor within a tag key.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "TagResource"
                serviceName = ServiceId
            }
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Remove one or more tags (keys and values) from a specified application.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UntagResource"
                serviceName = ServiceId
            }
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the application.
     */
    override suspend fun updateApplication(input: UpdateApplicationRequest): UpdateApplicationResponse {
        val op = SdkHttpOperation.build<UpdateApplicationRequest, UpdateApplicationResponse> {
            serializer = UpdateApplicationOperationSerializer()
            deserializer = UpdateApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateApplication"
                serviceName = ServiceId
            }
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the custom component name and/or the list of resources that make up the component.
     */
    override suspend fun updateComponent(input: UpdateComponentRequest): UpdateComponentResponse {
        val op = SdkHttpOperation.build<UpdateComponentRequest, UpdateComponentResponse> {
            serializer = UpdateComponentOperationSerializer()
            deserializer = UpdateComponentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateComponent"
                serviceName = ServiceId
            }
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the monitoring configurations for the component. The configuration input parameter is an escaped JSON of the configuration and should match the schema of what is returned by `DescribeComponentConfigurationRecommendation`.
     */
    override suspend fun updateComponentConfiguration(input: UpdateComponentConfigurationRequest): UpdateComponentConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateComponentConfigurationRequest, UpdateComponentConfigurationResponse> {
            serializer = UpdateComponentConfigurationOperationSerializer()
            deserializer = UpdateComponentConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateComponentConfiguration"
                serviceName = ServiceId
            }
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds a log pattern to a `LogPatternSet`.
     */
    override suspend fun updateLogPattern(input: UpdateLogPatternRequest): UpdateLogPatternResponse {
        val op = SdkHttpOperation.build<UpdateLogPatternRequest, UpdateLogPatternResponse> {
            serializer = UpdateLogPatternOperationSerializer()
            deserializer = UpdateLogPatternOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateLogPattern"
                serviceName = ServiceId
            }
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("EC2WindowsBarleyService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsentNotNull(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "applicationinsights")
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
