// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationinsights.paginators

import aws.sdk.kotlin.services.applicationinsights.ApplicationInsightsClient
import aws.sdk.kotlin.services.applicationinsights.model.ListApplicationsRequest
import aws.sdk.kotlin.services.applicationinsights.model.ListApplicationsResponse
import aws.sdk.kotlin.services.applicationinsights.model.ListComponentsRequest
import aws.sdk.kotlin.services.applicationinsights.model.ListComponentsResponse
import aws.sdk.kotlin.services.applicationinsights.model.ListConfigurationHistoryRequest
import aws.sdk.kotlin.services.applicationinsights.model.ListConfigurationHistoryResponse
import aws.sdk.kotlin.services.applicationinsights.model.ListLogPatternSetsRequest
import aws.sdk.kotlin.services.applicationinsights.model.ListLogPatternSetsResponse
import aws.sdk.kotlin.services.applicationinsights.model.ListLogPatternsRequest
import aws.sdk.kotlin.services.applicationinsights.model.ListLogPatternsResponse
import aws.sdk.kotlin.services.applicationinsights.model.ListProblemsRequest
import aws.sdk.kotlin.services.applicationinsights.model.ListProblemsResponse
import aws.sdk.kotlin.services.applicationinsights.model.ListWorkloadsRequest
import aws.sdk.kotlin.services.applicationinsights.model.ListWorkloadsResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListApplicationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListApplicationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApplicationsResponse]
 */
public fun ApplicationInsightsClient.listApplicationsPaginated(initialRequest: ListApplicationsRequest): Flow<ListApplicationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listApplicationsPaginated.listApplications(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListApplicationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApplicationsResponse]
 */
public fun ApplicationInsightsClient.listApplicationsPaginated(block: ListApplicationsRequest.Builder.() -> Unit): Flow<ListApplicationsResponse> =
    listApplicationsPaginated(ListApplicationsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListComponentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListComponentsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListComponentsResponse]
 */
public fun ApplicationInsightsClient.listComponentsPaginated(initialRequest: ListComponentsRequest): Flow<ListComponentsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listComponentsPaginated.listComponents(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListComponentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListComponentsResponse]
 */
public fun ApplicationInsightsClient.listComponentsPaginated(block: ListComponentsRequest.Builder.() -> Unit): Flow<ListComponentsResponse> =
    listComponentsPaginated(ListComponentsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListConfigurationHistoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListConfigurationHistoryRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListConfigurationHistoryResponse]
 */
public fun ApplicationInsightsClient.listConfigurationHistoryPaginated(initialRequest: ListConfigurationHistoryRequest): Flow<ListConfigurationHistoryResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listConfigurationHistoryPaginated.listConfigurationHistory(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListConfigurationHistoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListConfigurationHistoryResponse]
 */
public fun ApplicationInsightsClient.listConfigurationHistoryPaginated(block: ListConfigurationHistoryRequest.Builder.() -> Unit): Flow<ListConfigurationHistoryResponse> =
    listConfigurationHistoryPaginated(ListConfigurationHistoryRequest.Builder().apply(block).build())

/**
 * Paginate over [ListLogPatternsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListLogPatternsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLogPatternsResponse]
 */
public fun ApplicationInsightsClient.listLogPatternsPaginated(initialRequest: ListLogPatternsRequest): Flow<ListLogPatternsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listLogPatternsPaginated.listLogPatterns(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListLogPatternsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLogPatternsResponse]
 */
public fun ApplicationInsightsClient.listLogPatternsPaginated(block: ListLogPatternsRequest.Builder.() -> Unit): Flow<ListLogPatternsResponse> =
    listLogPatternsPaginated(ListLogPatternsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListLogPatternSetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListLogPatternSetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLogPatternSetsResponse]
 */
public fun ApplicationInsightsClient.listLogPatternSetsPaginated(initialRequest: ListLogPatternSetsRequest): Flow<ListLogPatternSetsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listLogPatternSetsPaginated.listLogPatternSets(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListLogPatternSetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLogPatternSetsResponse]
 */
public fun ApplicationInsightsClient.listLogPatternSetsPaginated(block: ListLogPatternSetsRequest.Builder.() -> Unit): Flow<ListLogPatternSetsResponse> =
    listLogPatternSetsPaginated(ListLogPatternSetsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListProblemsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListProblemsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProblemsResponse]
 */
public fun ApplicationInsightsClient.listProblemsPaginated(initialRequest: ListProblemsRequest): Flow<ListProblemsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listProblemsPaginated.listProblems(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListProblemsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProblemsResponse]
 */
public fun ApplicationInsightsClient.listProblemsPaginated(block: ListProblemsRequest.Builder.() -> Unit): Flow<ListProblemsResponse> =
    listProblemsPaginated(ListProblemsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListWorkloadsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListWorkloadsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkloadsResponse]
 */
public fun ApplicationInsightsClient.listWorkloadsPaginated(initialRequest: ListWorkloadsRequest): Flow<ListWorkloadsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listWorkloadsPaginated.listWorkloads(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListWorkloadsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkloadsResponse]
 */
public fun ApplicationInsightsClient.listWorkloadsPaginated(block: ListWorkloadsRequest.Builder.() -> Unit): Flow<ListWorkloadsResponse> =
    listWorkloadsPaginated(ListWorkloadsRequest.Builder().apply(block).build())
