// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationinsights.transform

import aws.sdk.kotlin.services.applicationinsights.model.ApplicationInsightsException
import aws.sdk.kotlin.services.applicationinsights.model.DescribeWorkloadResponse
import aws.sdk.kotlin.services.applicationinsights.model.WorkloadConfiguration
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeWorkloadOperationDeserializer: HttpDeserialize<DescribeWorkloadResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeWorkloadResponse {
        if (!response.status.isSuccess()) {
            throwDescribeWorkloadError(context, response)
        }
        val builder = DescribeWorkloadResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeWorkloadOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeWorkloadError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ApplicationInsightsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ApplicationInsightsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeWorkloadOperationBody(builder: DescribeWorkloadResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val WORKLOADCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("WorkloadConfiguration"))
    val WORKLOADID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WorkloadId"))
    val WORKLOADREMARKS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WorkloadRemarks"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(WORKLOADCONFIGURATION_DESCRIPTOR)
        field(WORKLOADID_DESCRIPTOR)
        field(WORKLOADREMARKS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                WORKLOADCONFIGURATION_DESCRIPTOR.index -> builder.workloadConfiguration = deserializeWorkloadConfigurationDocument(deserializer)
                WORKLOADID_DESCRIPTOR.index -> builder.workloadId = deserializeString()
                WORKLOADREMARKS_DESCRIPTOR.index -> builder.workloadRemarks = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
