// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationinsights.transform

import aws.sdk.kotlin.services.applicationinsights.model.ApplicationInsightsException
import aws.sdk.kotlin.services.applicationinsights.model.UpdateWorkloadResponse
import aws.sdk.kotlin.services.applicationinsights.model.WorkloadConfiguration
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateWorkloadOperationDeserializer: HttpDeserialize<UpdateWorkloadResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateWorkloadResponse {
        if (!response.status.isSuccess()) {
            throwUpdateWorkloadError(context, response)
        }
        val builder = UpdateWorkloadResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateWorkloadOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateWorkloadError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ApplicationInsightsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ApplicationInsightsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateWorkloadOperationBody(builder: UpdateWorkloadResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val WORKLOADCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("WorkloadConfiguration"))
    val WORKLOADID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WorkloadId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(WORKLOADCONFIGURATION_DESCRIPTOR)
        field(WORKLOADID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                WORKLOADCONFIGURATION_DESCRIPTOR.index -> builder.workloadConfiguration = deserializeWorkloadConfigurationDocument(deserializer)
                WORKLOADID_DESCRIPTOR.index -> builder.workloadId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
