// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationinsights.model



/**
 * Describes a standalone resource or similarly grouped resources that the application is made
 * up of.
 */
class ApplicationComponent private constructor(builder: BuilderImpl) {
    /**
     * The name of the component.
     */
    val componentName: String? = builder.componentName
    /**
     * If logging is supported for the resource type, indicates whether the component has configured logs to be monitored.
     */
    val componentRemarks: String? = builder.componentRemarks
    /**
     * Workloads detected in the application component.
     */
    val detectedWorkload: Map<String, Map<String, String>>? = builder.detectedWorkload
    /**
     * Indicates whether the application component is monitored.
     */
    val monitor: Boolean? = builder.monitor
    /**
     * The operating system of the component.
     */
    val osType: OsType? = builder.osType
    /**
     * The resource type. Supported resource types include EC2 instances, Auto Scaling group, Classic ELB, Application ELB, and SQS Queue.
     */
    val resourceType: String? = builder.resourceType
    /**
     * The stack tier of the application component.
     */
    val tier: Tier? = builder.tier

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ApplicationComponent = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ApplicationComponent(")
        append("componentName=$componentName,")
        append("componentRemarks=$componentRemarks,")
        append("detectedWorkload=$detectedWorkload,")
        append("monitor=$monitor,")
        append("osType=$osType,")
        append("resourceType=$resourceType,")
        append("tier=$tier)")
    }

    override fun hashCode(): kotlin.Int {
        var result = componentName?.hashCode() ?: 0
        result = 31 * result + (componentRemarks?.hashCode() ?: 0)
        result = 31 * result + (detectedWorkload?.hashCode() ?: 0)
        result = 31 * result + (monitor?.hashCode() ?: 0)
        result = 31 * result + (osType?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (tier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ApplicationComponent

        if (componentName != other.componentName) return false
        if (componentRemarks != other.componentRemarks) return false
        if (detectedWorkload != other.detectedWorkload) return false
        if (monitor != other.monitor) return false
        if (osType != other.osType) return false
        if (resourceType != other.resourceType) return false
        if (tier != other.tier) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ApplicationComponent = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ApplicationComponent
        /**
         * The name of the component.
         */
        fun componentName(componentName: String): FluentBuilder
        /**
         * If logging is supported for the resource type, indicates whether the component has configured logs to be monitored.
         */
        fun componentRemarks(componentRemarks: String): FluentBuilder
        /**
         * Workloads detected in the application component.
         */
        fun detectedWorkload(detectedWorkload: Map<String, Map<String, String>>): FluentBuilder
        /**
         * Indicates whether the application component is monitored.
         */
        fun monitor(monitor: Boolean): FluentBuilder
        /**
         * The operating system of the component.
         */
        fun osType(osType: OsType): FluentBuilder
        /**
         * The resource type. Supported resource types include EC2 instances, Auto Scaling group, Classic ELB, Application ELB, and SQS Queue.
         */
        fun resourceType(resourceType: String): FluentBuilder
        /**
         * The stack tier of the application component.
         */
        fun tier(tier: Tier): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the component.
         */
        var componentName: String?
        /**
         * If logging is supported for the resource type, indicates whether the component has configured logs to be monitored.
         */
        var componentRemarks: String?
        /**
         * Workloads detected in the application component.
         */
        var detectedWorkload: Map<String, Map<String, String>>?
        /**
         * Indicates whether the application component is monitored.
         */
        var monitor: Boolean?
        /**
         * The operating system of the component.
         */
        var osType: OsType?
        /**
         * The resource type. Supported resource types include EC2 instances, Auto Scaling group, Classic ELB, Application ELB, and SQS Queue.
         */
        var resourceType: String?
        /**
         * The stack tier of the application component.
         */
        var tier: Tier?

        fun build(): ApplicationComponent
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var componentName: String? = null
        override var componentRemarks: String? = null
        override var detectedWorkload: Map<String, Map<String, String>>? = null
        override var monitor: Boolean? = null
        override var osType: OsType? = null
        override var resourceType: String? = null
        override var tier: Tier? = null

        constructor(x: ApplicationComponent) : this() {
            this.componentName = x.componentName
            this.componentRemarks = x.componentRemarks
            this.detectedWorkload = x.detectedWorkload
            this.monitor = x.monitor
            this.osType = x.osType
            this.resourceType = x.resourceType
            this.tier = x.tier
        }

        override fun build(): ApplicationComponent = ApplicationComponent(this)
        override fun componentName(componentName: String): FluentBuilder = apply { this.componentName = componentName }
        override fun componentRemarks(componentRemarks: String): FluentBuilder = apply { this.componentRemarks = componentRemarks }
        override fun detectedWorkload(detectedWorkload: Map<String, Map<String, String>>): FluentBuilder = apply { this.detectedWorkload = detectedWorkload }
        override fun monitor(monitor: Boolean): FluentBuilder = apply { this.monitor = monitor }
        override fun osType(osType: OsType): FluentBuilder = apply { this.osType = osType }
        override fun resourceType(resourceType: String): FluentBuilder = apply { this.resourceType = resourceType }
        override fun tier(tier: Tier): FluentBuilder = apply { this.tier = tier }
    }
}
