// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationinsights.model

import aws.smithy.kotlin.runtime.time.Instant

class ListProblemsRequest private constructor(builder: BuilderImpl) {
    /**
     * The time when the problem ended, in epoch seconds. If not specified, problems within the
     * past seven days are returned.
     */
    val endTime: Instant? = builder.endTime
    /**
     * The maximum number of results to return in a single call. To retrieve the remaining
     * results, make another call with the returned NextToken value.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The token to request the next page of results.
     */
    val nextToken: String? = builder.nextToken
    /**
     * The name of the resource group.
     */
    val resourceGroupName: String? = builder.resourceGroupName
    /**
     * The time when the problem was detected, in epoch
     * seconds. If you don't specify a time frame for the request, problems within the past seven days are returned.
     */
    val startTime: Instant? = builder.startTime

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListProblemsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListProblemsRequest(")
        append("endTime=$endTime,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("resourceGroupName=$resourceGroupName,")
        append("startTime=$startTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (resourceGroupName?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListProblemsRequest

        if (endTime != other.endTime) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (resourceGroupName != other.resourceGroupName) return false
        if (startTime != other.startTime) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListProblemsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListProblemsRequest
        /**
         * The time when the problem ended, in epoch seconds. If not specified, problems within the
         * past seven days are returned.
         */
        fun endTime(endTime: Instant): FluentBuilder
        /**
         * The maximum number of results to return in a single call. To retrieve the remaining
         * results, make another call with the returned NextToken value.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The token to request the next page of results.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * The name of the resource group.
         */
        fun resourceGroupName(resourceGroupName: String): FluentBuilder
        /**
         * The time when the problem was detected, in epoch
         * seconds. If you don't specify a time frame for the request, problems within the past seven days are returned.
         */
        fun startTime(startTime: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The time when the problem ended, in epoch seconds. If not specified, problems within the
         * past seven days are returned.
         */
        var endTime: Instant?
        /**
         * The maximum number of results to return in a single call. To retrieve the remaining
         * results, make another call with the returned NextToken value.
         */
        var maxResults: Int?
        /**
         * The token to request the next page of results.
         */
        var nextToken: String?
        /**
         * The name of the resource group.
         */
        var resourceGroupName: String?
        /**
         * The time when the problem was detected, in epoch
         * seconds. If you don't specify a time frame for the request, problems within the past seven days are returned.
         */
        var startTime: Instant?

        fun build(): ListProblemsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var endTime: Instant? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null
        override var resourceGroupName: String? = null
        override var startTime: Instant? = null

        constructor(x: ListProblemsRequest) : this() {
            this.endTime = x.endTime
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.resourceGroupName = x.resourceGroupName
            this.startTime = x.startTime
        }

        override fun build(): ListProblemsRequest = ListProblemsRequest(this)
        override fun endTime(endTime: Instant): FluentBuilder = apply { this.endTime = endTime }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun resourceGroupName(resourceGroupName: String): FluentBuilder = apply { this.resourceGroupName = resourceGroupName }
        override fun startTime(startTime: Instant): FluentBuilder = apply { this.startTime = startTime }
    }
}
