// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationinsights

import aws.sdk.kotlin.runtime.auth.AuthConfig
import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.endpoint.EndpointResolver
import aws.sdk.kotlin.runtime.region.RegionConfig
import aws.sdk.kotlin.services.applicationinsights.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * <fullname>Amazon CloudWatch Application Insights</fullname>
 * Amazon CloudWatch Application Insights is a service that
 * helps you detect common problems with your applications. It
 * enables you to pinpoint the source of issues in your applications (built with technologies
 * such as Microsoft IIS, .NET, and Microsoft SQL Server), by providing key insights into
 * detected problems.
 * After you onboard your application, CloudWatch Application Insights identifies,
 * recommends, and sets up metrics and logs. It continuously analyzes and
 * correlates your metrics and logs for unusual behavior to surface actionable problems with
 * your application. For example, if your application is slow and unresponsive and leading to
 * HTTP 500 errors in your Application Load Balancer (ALB), Application Insights informs you
 * that a memory pressure problem with your SQL Server database is occurring. It bases this
 * analysis on impactful metrics and log errors.
 */
interface ApplicationInsightsClient : SdkClient {

    override val serviceName: String
        get() = "Application Insights"
    /**
     * ApplicationInsightsClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.DslBuilder.() -> Unit = {}): ApplicationInsightsClient {
            val config = Config.BuilderImpl().apply(block).build()
            return DefaultApplicationInsightsClient(config)
        }
    }

    class Config private constructor(builder: BuilderImpl): AuthConfig, HttpClientConfig, RegionConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider? = builder.credentialsProvider
        val endpointResolver: EndpointResolver? = builder.endpointResolver
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val region: String? = builder.region
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        override val signingRegion: String? = builder.signingRegion

        interface FluentBuilder {
            fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder
            fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder
            fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder
            fun region(region: String): FluentBuilder
            fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder
            fun signingRegion(signingRegion: String): FluentBuilder
            fun build(): Config
        }

        interface DslBuilder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider?

            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: EndpointResolver?

            /**
             * Override the default HTTP client configuration (e.g. configure proxy behavior, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine?

            /**
             * AWS region to make requests to
             */
            var region: String?

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode

            /**
             * AWS region to be used for signing the request. This is not necessarily the same as `region`
             * in the case of global services like IAM
             */
            var signingRegion: String?

            fun build(): Config
        }

        internal class BuilderImpl() : FluentBuilder, DslBuilder {
            override var credentialsProvider: CredentialsProvider? = null
            override var endpointResolver: EndpointResolver? = null
            override var httpClientEngine: HttpClientEngine? = null
            override var region: String? = null
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default
            override var signingRegion: String? = null

            override fun build(): Config = Config(this)
            override fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder = apply { this.credentialsProvider = credentialsProvider }
            override fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder = apply { this.endpointResolver = endpointResolver }
            override fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder = apply { this.httpClientEngine = httpClientEngine }
            override fun region(region: String): FluentBuilder = apply { this.region = region }
            override fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder = apply { this.sdkLogMode = sdkLogMode }
            override fun signingRegion(signingRegion: String): FluentBuilder = apply { this.signingRegion = signingRegion }
        }
    }

    /**
     * Adds an application that is created from a resource group.
     */
    suspend fun createApplication(input: CreateApplicationRequest): CreateApplicationResponse

    /**
     * Adds an application that is created from a resource group.
     */
    suspend fun createApplication(block: CreateApplicationRequest.DslBuilder.() -> Unit) = createApplication(CreateApplicationRequest.builder().apply(block).build())

    /**
     * Creates a custom component by grouping similar standalone instances to monitor.
     */
    suspend fun createComponent(input: CreateComponentRequest): CreateComponentResponse

    /**
     * Creates a custom component by grouping similar standalone instances to monitor.
     */
    suspend fun createComponent(block: CreateComponentRequest.DslBuilder.() -> Unit) = createComponent(CreateComponentRequest.builder().apply(block).build())

    /**
     * Adds an log pattern to a LogPatternSet.
     */
    suspend fun createLogPattern(input: CreateLogPatternRequest): CreateLogPatternResponse

    /**
     * Adds an log pattern to a LogPatternSet.
     */
    suspend fun createLogPattern(block: CreateLogPatternRequest.DslBuilder.() -> Unit) = createLogPattern(CreateLogPatternRequest.builder().apply(block).build())

    /**
     * Removes the specified application from monitoring. Does not delete the application.
     */
    suspend fun deleteApplication(input: DeleteApplicationRequest): DeleteApplicationResponse

    /**
     * Removes the specified application from monitoring. Does not delete the application.
     */
    suspend fun deleteApplication(block: DeleteApplicationRequest.DslBuilder.() -> Unit) = deleteApplication(DeleteApplicationRequest.builder().apply(block).build())

    /**
     * Ungroups a custom component. When you ungroup custom components, all applicable
     * monitors that are set up for the component are removed and the instances revert to their standalone status.
     */
    suspend fun deleteComponent(input: DeleteComponentRequest): DeleteComponentResponse

    /**
     * Ungroups a custom component. When you ungroup custom components, all applicable
     * monitors that are set up for the component are removed and the instances revert to their standalone status.
     */
    suspend fun deleteComponent(block: DeleteComponentRequest.DslBuilder.() -> Unit) = deleteComponent(DeleteComponentRequest.builder().apply(block).build())

    /**
     * Removes the specified log pattern from a LogPatternSet.
     */
    suspend fun deleteLogPattern(input: DeleteLogPatternRequest): DeleteLogPatternResponse

    /**
     * Removes the specified log pattern from a LogPatternSet.
     */
    suspend fun deleteLogPattern(block: DeleteLogPatternRequest.DslBuilder.() -> Unit) = deleteLogPattern(DeleteLogPatternRequest.builder().apply(block).build())

    /**
     * Describes the application.
     */
    suspend fun describeApplication(input: DescribeApplicationRequest): DescribeApplicationResponse

    /**
     * Describes the application.
     */
    suspend fun describeApplication(block: DescribeApplicationRequest.DslBuilder.() -> Unit) = describeApplication(DescribeApplicationRequest.builder().apply(block).build())

    /**
     * Describes a component and lists the resources that are grouped together in a component.
     */
    suspend fun describeComponent(input: DescribeComponentRequest): DescribeComponentResponse

    /**
     * Describes a component and lists the resources that are grouped together in a component.
     */
    suspend fun describeComponent(block: DescribeComponentRequest.DslBuilder.() -> Unit) = describeComponent(DescribeComponentRequest.builder().apply(block).build())

    /**
     * Describes the monitoring configuration of the component.
     */
    suspend fun describeComponentConfiguration(input: DescribeComponentConfigurationRequest): DescribeComponentConfigurationResponse

    /**
     * Describes the monitoring configuration of the component.
     */
    suspend fun describeComponentConfiguration(block: DescribeComponentConfigurationRequest.DslBuilder.() -> Unit) = describeComponentConfiguration(DescribeComponentConfigurationRequest.builder().apply(block).build())

    /**
     * Describes the recommended monitoring configuration of the component.
     */
    suspend fun describeComponentConfigurationRecommendation(input: DescribeComponentConfigurationRecommendationRequest): DescribeComponentConfigurationRecommendationResponse

    /**
     * Describes the recommended monitoring configuration of the component.
     */
    suspend fun describeComponentConfigurationRecommendation(block: DescribeComponentConfigurationRecommendationRequest.DslBuilder.() -> Unit) = describeComponentConfigurationRecommendation(DescribeComponentConfigurationRecommendationRequest.builder().apply(block).build())

    /**
     * Describe a specific log pattern from a LogPatternSet.
     */
    suspend fun describeLogPattern(input: DescribeLogPatternRequest): DescribeLogPatternResponse

    /**
     * Describe a specific log pattern from a LogPatternSet.
     */
    suspend fun describeLogPattern(block: DescribeLogPatternRequest.DslBuilder.() -> Unit) = describeLogPattern(DescribeLogPatternRequest.builder().apply(block).build())

    /**
     * Describes an anomaly or error with the application.
     */
    suspend fun describeObservation(input: DescribeObservationRequest): DescribeObservationResponse

    /**
     * Describes an anomaly or error with the application.
     */
    suspend fun describeObservation(block: DescribeObservationRequest.DslBuilder.() -> Unit) = describeObservation(DescribeObservationRequest.builder().apply(block).build())

    /**
     * Describes an application problem.
     */
    suspend fun describeProblem(input: DescribeProblemRequest): DescribeProblemResponse

    /**
     * Describes an application problem.
     */
    suspend fun describeProblem(block: DescribeProblemRequest.DslBuilder.() -> Unit) = describeProblem(DescribeProblemRequest.builder().apply(block).build())

    /**
     * Describes the anomalies or errors associated with the problem.
     */
    suspend fun describeProblemObservations(input: DescribeProblemObservationsRequest): DescribeProblemObservationsResponse

    /**
     * Describes the anomalies or errors associated with the problem.
     */
    suspend fun describeProblemObservations(block: DescribeProblemObservationsRequest.DslBuilder.() -> Unit) = describeProblemObservations(DescribeProblemObservationsRequest.builder().apply(block).build())

    /**
     * Lists the IDs of the applications that you are monitoring.
     */
    suspend fun listApplications(input: ListApplicationsRequest): ListApplicationsResponse

    /**
     * Lists the IDs of the applications that you are monitoring.
     */
    suspend fun listApplications(block: ListApplicationsRequest.DslBuilder.() -> Unit) = listApplications(ListApplicationsRequest.builder().apply(block).build())

    /**
     * Lists the auto-grouped, standalone, and custom components of the application.
     */
    suspend fun listComponents(input: ListComponentsRequest): ListComponentsResponse

    /**
     * Lists the auto-grouped, standalone, and custom components of the application.
     */
    suspend fun listComponents(block: ListComponentsRequest.DslBuilder.() -> Unit) = listComponents(ListComponentsRequest.builder().apply(block).build())

    /**
     * Lists the INFO, WARN, and ERROR events for periodic configuration updates performed by Application Insights. Examples of events represented are:
     * INFO: creating a new alarm or updating an alarm threshold.
     * WARN: alarm not created due to insufficient data points used to predict thresholds.
     * ERROR: alarm not created due to permission errors or exceeding quotas.
     */
    suspend fun listConfigurationHistory(input: ListConfigurationHistoryRequest): ListConfigurationHistoryResponse

    /**
     * Lists the INFO, WARN, and ERROR events for periodic configuration updates performed by Application Insights. Examples of events represented are:
     * INFO: creating a new alarm or updating an alarm threshold.
     * WARN: alarm not created due to insufficient data points used to predict thresholds.
     * ERROR: alarm not created due to permission errors or exceeding quotas.
     */
    suspend fun listConfigurationHistory(block: ListConfigurationHistoryRequest.DslBuilder.() -> Unit) = listConfigurationHistory(ListConfigurationHistoryRequest.builder().apply(block).build())

    /**
     * Lists the log pattern sets in the specific application.
     */
    suspend fun listLogPatternSets(input: ListLogPatternSetsRequest): ListLogPatternSetsResponse

    /**
     * Lists the log pattern sets in the specific application.
     */
    suspend fun listLogPatternSets(block: ListLogPatternSetsRequest.DslBuilder.() -> Unit) = listLogPatternSets(ListLogPatternSetsRequest.builder().apply(block).build())

    /**
     * Lists the log patterns in the specific log LogPatternSet.
     */
    suspend fun listLogPatterns(input: ListLogPatternsRequest): ListLogPatternsResponse

    /**
     * Lists the log patterns in the specific log LogPatternSet.
     */
    suspend fun listLogPatterns(block: ListLogPatternsRequest.DslBuilder.() -> Unit) = listLogPatterns(ListLogPatternsRequest.builder().apply(block).build())

    /**
     * Lists the problems with your application.
     */
    suspend fun listProblems(input: ListProblemsRequest): ListProblemsResponse

    /**
     * Lists the problems with your application.
     */
    suspend fun listProblems(block: ListProblemsRequest.DslBuilder.() -> Unit) = listProblems(ListProblemsRequest.builder().apply(block).build())

    /**
     * Retrieve a list of the tags (keys and values) that are associated with a specified
     * application. A tag is a label that you optionally define and associate
     * with an application. Each tag consists of a required tag key and an
     * optional associated tag value. A tag key is a general label that
     * acts as a category for more specific tag values. A tag value acts as a descriptor within
     * a tag key.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Retrieve a list of the tags (keys and values) that are associated with a specified
     * application. A tag is a label that you optionally define and associate
     * with an application. Each tag consists of a required tag key and an
     * optional associated tag value. A tag key is a general label that
     * acts as a category for more specific tag values. A tag value acts as a descriptor within
     * a tag key.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.DslBuilder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.builder().apply(block).build())

    /**
     * Add one or more tags (keys and values) to a specified application. A
     * tag is a label that you optionally define and associate with an
     * application. Tags can help you categorize and manage application in different ways, such as
     * by purpose, owner, environment, or other criteria.
     * Each tag consists of a required tag key and an
     * associated tag value, both of which you define. A tag key is a
     * general label that acts as a category for more specific tag values. A tag value acts as
     * a descriptor within a tag key.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Add one or more tags (keys and values) to a specified application. A
     * tag is a label that you optionally define and associate with an
     * application. Tags can help you categorize and manage application in different ways, such as
     * by purpose, owner, environment, or other criteria.
     * Each tag consists of a required tag key and an
     * associated tag value, both of which you define. A tag key is a
     * general label that acts as a category for more specific tag values. A tag value acts as
     * a descriptor within a tag key.
     */
    suspend fun tagResource(block: TagResourceRequest.DslBuilder.() -> Unit) = tagResource(TagResourceRequest.builder().apply(block).build())

    /**
     * Remove one or more tags (keys and values) from a specified application.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Remove one or more tags (keys and values) from a specified application.
     */
    suspend fun untagResource(block: UntagResourceRequest.DslBuilder.() -> Unit) = untagResource(UntagResourceRequest.builder().apply(block).build())

    /**
     * Updates the application.
     */
    suspend fun updateApplication(input: UpdateApplicationRequest): UpdateApplicationResponse

    /**
     * Updates the application.
     */
    suspend fun updateApplication(block: UpdateApplicationRequest.DslBuilder.() -> Unit) = updateApplication(UpdateApplicationRequest.builder().apply(block).build())

    /**
     * Updates the custom component name and/or the list of resources that make up the
     * component.
     */
    suspend fun updateComponent(input: UpdateComponentRequest): UpdateComponentResponse

    /**
     * Updates the custom component name and/or the list of resources that make up the
     * component.
     */
    suspend fun updateComponent(block: UpdateComponentRequest.DslBuilder.() -> Unit) = updateComponent(UpdateComponentRequest.builder().apply(block).build())

    /**
     * Updates the monitoring configurations for the component. The configuration input parameter
     * is an escaped JSON of the configuration and should match the schema of what is returned
     * by DescribeComponentConfigurationRecommendation.
     */
    suspend fun updateComponentConfiguration(input: UpdateComponentConfigurationRequest): UpdateComponentConfigurationResponse

    /**
     * Updates the monitoring configurations for the component. The configuration input parameter
     * is an escaped JSON of the configuration and should match the schema of what is returned
     * by DescribeComponentConfigurationRecommendation.
     */
    suspend fun updateComponentConfiguration(block: UpdateComponentConfigurationRequest.DslBuilder.() -> Unit) = updateComponentConfiguration(UpdateComponentConfigurationRequest.builder().apply(block).build())

    /**
     * Adds a log pattern to a LogPatternSet.
     */
    suspend fun updateLogPattern(input: UpdateLogPatternRequest): UpdateLogPatternResponse

    /**
     * Adds a log pattern to a LogPatternSet.
     */
    suspend fun updateLogPattern(block: UpdateLogPatternRequest.DslBuilder.() -> Unit) = updateLogPattern(UpdateLogPatternRequest.builder().apply(block).build())
}
