// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationinsights.model



/**
 * Describes the status of the application.
 */
class ApplicationInfo private constructor(builder: BuilderImpl) {
    /**
     * Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as instance terminated, failed deployment, and others.
     */
    val cweMonitorEnabled: Boolean? = builder.cweMonitorEnabled
    /**
     * The lifecycle of the application.
     */
    val lifeCycle: String? = builder.lifeCycle
    /**
     * Indicates whether Application Insights will create opsItems for any problem detected by Application
     * Insights for an application.
     */
    val opsCenterEnabled: Boolean? = builder.opsCenterEnabled
    /**
     * The SNS topic provided to Application Insights that is associated to the created opsItems to receive SNS notifications
     * for opsItem updates.
     */
    val opsItemSnsTopicArn: String? = builder.opsItemSnsTopicArn
    /**
     * The issues on the user side that block Application Insights from successfully monitoring
     * an application. Example remarks include:
     * “Configuring application, detected 1 Errors, 3 Warnings”
     * “Configuring application, detected 1 Unconfigured Components”
     */
    val remarks: String? = builder.remarks
    /**
     * The name of the resource group used for the application.
     */
    val resourceGroupName: String? = builder.resourceGroupName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ApplicationInfo = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ApplicationInfo(")
        append("cweMonitorEnabled=$cweMonitorEnabled,")
        append("lifeCycle=$lifeCycle,")
        append("opsCenterEnabled=$opsCenterEnabled,")
        append("opsItemSnsTopicArn=$opsItemSnsTopicArn,")
        append("remarks=$remarks,")
        append("resourceGroupName=$resourceGroupName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cweMonitorEnabled?.hashCode() ?: 0
        result = 31 * result + (lifeCycle?.hashCode() ?: 0)
        result = 31 * result + (opsCenterEnabled?.hashCode() ?: 0)
        result = 31 * result + (opsItemSnsTopicArn?.hashCode() ?: 0)
        result = 31 * result + (remarks?.hashCode() ?: 0)
        result = 31 * result + (resourceGroupName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ApplicationInfo

        if (cweMonitorEnabled != other.cweMonitorEnabled) return false
        if (lifeCycle != other.lifeCycle) return false
        if (opsCenterEnabled != other.opsCenterEnabled) return false
        if (opsItemSnsTopicArn != other.opsItemSnsTopicArn) return false
        if (remarks != other.remarks) return false
        if (resourceGroupName != other.resourceGroupName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ApplicationInfo = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ApplicationInfo
        /**
         * Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as instance terminated, failed deployment, and others.
         */
        fun cweMonitorEnabled(cweMonitorEnabled: Boolean): FluentBuilder
        /**
         * The lifecycle of the application.
         */
        fun lifeCycle(lifeCycle: String): FluentBuilder
        /**
         * Indicates whether Application Insights will create opsItems for any problem detected by Application
         * Insights for an application.
         */
        fun opsCenterEnabled(opsCenterEnabled: Boolean): FluentBuilder
        /**
         * The SNS topic provided to Application Insights that is associated to the created opsItems to receive SNS notifications
         * for opsItem updates.
         */
        fun opsItemSnsTopicArn(opsItemSnsTopicArn: String): FluentBuilder
        /**
         * The issues on the user side that block Application Insights from successfully monitoring
         * an application. Example remarks include:
         * “Configuring application, detected 1 Errors, 3 Warnings”
         * “Configuring application, detected 1 Unconfigured Components”
         */
        fun remarks(remarks: String): FluentBuilder
        /**
         * The name of the resource group used for the application.
         */
        fun resourceGroupName(resourceGroupName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as instance terminated, failed deployment, and others.
         */
        var cweMonitorEnabled: Boolean?
        /**
         * The lifecycle of the application.
         */
        var lifeCycle: String?
        /**
         * Indicates whether Application Insights will create opsItems for any problem detected by Application
         * Insights for an application.
         */
        var opsCenterEnabled: Boolean?
        /**
         * The SNS topic provided to Application Insights that is associated to the created opsItems to receive SNS notifications
         * for opsItem updates.
         */
        var opsItemSnsTopicArn: String?
        /**
         * The issues on the user side that block Application Insights from successfully monitoring
         * an application. Example remarks include:
         * “Configuring application, detected 1 Errors, 3 Warnings”
         * “Configuring application, detected 1 Unconfigured Components”
         */
        var remarks: String?
        /**
         * The name of the resource group used for the application.
         */
        var resourceGroupName: String?

        fun build(): ApplicationInfo
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var cweMonitorEnabled: Boolean? = null
        override var lifeCycle: String? = null
        override var opsCenterEnabled: Boolean? = null
        override var opsItemSnsTopicArn: String? = null
        override var remarks: String? = null
        override var resourceGroupName: String? = null

        constructor(x: ApplicationInfo) : this() {
            this.cweMonitorEnabled = x.cweMonitorEnabled
            this.lifeCycle = x.lifeCycle
            this.opsCenterEnabled = x.opsCenterEnabled
            this.opsItemSnsTopicArn = x.opsItemSnsTopicArn
            this.remarks = x.remarks
            this.resourceGroupName = x.resourceGroupName
        }

        override fun build(): ApplicationInfo = ApplicationInfo(this)
        override fun cweMonitorEnabled(cweMonitorEnabled: Boolean): FluentBuilder = apply { this.cweMonitorEnabled = cweMonitorEnabled }
        override fun lifeCycle(lifeCycle: String): FluentBuilder = apply { this.lifeCycle = lifeCycle }
        override fun opsCenterEnabled(opsCenterEnabled: Boolean): FluentBuilder = apply { this.opsCenterEnabled = opsCenterEnabled }
        override fun opsItemSnsTopicArn(opsItemSnsTopicArn: String): FluentBuilder = apply { this.opsItemSnsTopicArn = opsItemSnsTopicArn }
        override fun remarks(remarks: String): FluentBuilder = apply { this.remarks = remarks }
        override fun resourceGroupName(resourceGroupName: String): FluentBuilder = apply { this.resourceGroupName = resourceGroupName }
    }
}
