// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationinsights.model

import aws.smithy.kotlin.runtime.time.Instant

class ListConfigurationHistoryRequest private constructor(builder: BuilderImpl) {
    /**
     * The end time of the event.
     */
    val endTime: Instant? = builder.endTime
    /**
     * The status of the configuration update event. Possible values include INFO, WARN, and ERROR.
     */
    val eventStatus: ConfigurationEventStatus? = builder.eventStatus
    /**
     * The maximum number of results returned by ListConfigurationHistory in
     * paginated output. When this parameter is used, ListConfigurationHistory
     * returns only MaxResults in a single page along with a NextToken
     * response element. The remaining results of the initial request can be seen by sending
     * another ListConfigurationHistory request with the returned
     * NextToken value. If this parameter is not used, then
     * ListConfigurationHistory returns all results.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The NextToken value returned from a previous paginated ListConfigurationHistory request where
     * MaxResults was used and the results exceeded the value of that parameter. Pagination
     * continues from the end of the previous results that returned the NextToken value. This
     * value is null when there are no more results to return.
     */
    val nextToken: String? = builder.nextToken
    /**
     * Resource group to which the application belongs.
     */
    val resourceGroupName: String? = builder.resourceGroupName
    /**
     * The start time of the event.
     */
    val startTime: Instant? = builder.startTime

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListConfigurationHistoryRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListConfigurationHistoryRequest(")
        append("endTime=$endTime,")
        append("eventStatus=$eventStatus,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("resourceGroupName=$resourceGroupName,")
        append("startTime=$startTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (eventStatus?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (resourceGroupName?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListConfigurationHistoryRequest

        if (endTime != other.endTime) return false
        if (eventStatus != other.eventStatus) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (resourceGroupName != other.resourceGroupName) return false
        if (startTime != other.startTime) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListConfigurationHistoryRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListConfigurationHistoryRequest
        /**
         * The end time of the event.
         */
        fun endTime(endTime: Instant): FluentBuilder
        /**
         * The status of the configuration update event. Possible values include INFO, WARN, and ERROR.
         */
        fun eventStatus(eventStatus: ConfigurationEventStatus): FluentBuilder
        /**
         * The maximum number of results returned by ListConfigurationHistory in
         * paginated output. When this parameter is used, ListConfigurationHistory
         * returns only MaxResults in a single page along with a NextToken
         * response element. The remaining results of the initial request can be seen by sending
         * another ListConfigurationHistory request with the returned
         * NextToken value. If this parameter is not used, then
         * ListConfigurationHistory returns all results.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The NextToken value returned from a previous paginated ListConfigurationHistory request where
         * MaxResults was used and the results exceeded the value of that parameter. Pagination
         * continues from the end of the previous results that returned the NextToken value. This
         * value is null when there are no more results to return.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * Resource group to which the application belongs.
         */
        fun resourceGroupName(resourceGroupName: String): FluentBuilder
        /**
         * The start time of the event.
         */
        fun startTime(startTime: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The end time of the event.
         */
        var endTime: Instant?
        /**
         * The status of the configuration update event. Possible values include INFO, WARN, and ERROR.
         */
        var eventStatus: ConfigurationEventStatus?
        /**
         * The maximum number of results returned by ListConfigurationHistory in
         * paginated output. When this parameter is used, ListConfigurationHistory
         * returns only MaxResults in a single page along with a NextToken
         * response element. The remaining results of the initial request can be seen by sending
         * another ListConfigurationHistory request with the returned
         * NextToken value. If this parameter is not used, then
         * ListConfigurationHistory returns all results.
         */
        var maxResults: Int?
        /**
         * The NextToken value returned from a previous paginated ListConfigurationHistory request where
         * MaxResults was used and the results exceeded the value of that parameter. Pagination
         * continues from the end of the previous results that returned the NextToken value. This
         * value is null when there are no more results to return.
         */
        var nextToken: String?
        /**
         * Resource group to which the application belongs.
         */
        var resourceGroupName: String?
        /**
         * The start time of the event.
         */
        var startTime: Instant?

        fun build(): ListConfigurationHistoryRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var endTime: Instant? = null
        override var eventStatus: ConfigurationEventStatus? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null
        override var resourceGroupName: String? = null
        override var startTime: Instant? = null

        constructor(x: ListConfigurationHistoryRequest) : this() {
            this.endTime = x.endTime
            this.eventStatus = x.eventStatus
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.resourceGroupName = x.resourceGroupName
            this.startTime = x.startTime
        }

        override fun build(): ListConfigurationHistoryRequest = ListConfigurationHistoryRequest(this)
        override fun endTime(endTime: Instant): FluentBuilder = apply { this.endTime = endTime }
        override fun eventStatus(eventStatus: ConfigurationEventStatus): FluentBuilder = apply { this.eventStatus = eventStatus }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun resourceGroupName(resourceGroupName: String): FluentBuilder = apply { this.resourceGroupName = resourceGroupName }
        override fun startTime(startTime: Instant): FluentBuilder = apply { this.startTime = startTime }
    }
}
