// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationinsights.model



/**
 * An object that defines the log patterns that belongs to a LogPatternSet.
 */
class LogPattern private constructor(builder: BuilderImpl) {
    /**
     * A regular expression that defines the log pattern. A log pattern can contain as many as 50 characters, and it cannot
     * be empty. The pattern must be DFA compatible. Patterns that utilize forward lookahead or backreference constructions are not supported.
     */
    val pattern: String? = builder.pattern
    /**
     * The name of the log pattern. A log pattern name can contain as many as 50 characters, and it cannot
     * be empty. The characters can be Unicode letters, digits, or one of the following symbols: period, dash, underscore.
     */
    val patternName: String? = builder.patternName
    /**
     * The name of the log pattern. A log pattern name can contain as many as 30 characters, and it cannot
     * be empty. The characters can be Unicode letters, digits, or one of the following symbols: period, dash, underscore.
     */
    val patternSetName: String? = builder.patternSetName
    /**
     * Rank of the log pattern. Must be a value between 1 and 1,000,000. The patterns are sorted by rank, so we recommend that you set your highest priority patterns with the lowest rank. A pattern of rank 1 will be the first to get matched to a log line. A pattern of rank 1,000,000 will be last to get matched. When you configure custom log patterns from the console, a Low severity pattern translates to a 750,000 rank. A Medium severity pattern translates to a 500,000 rank. And a High severity pattern translates to a 250,000 rank.
     * Rank values less than 1 or greater than 1,000,000 are reserved for AWS-provided patterns.
     */
    val rank: Int = builder.rank

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): LogPattern = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("LogPattern(")
        append("pattern=$pattern,")
        append("patternName=$patternName,")
        append("patternSetName=$patternSetName,")
        append("rank=$rank)")
    }

    override fun hashCode(): kotlin.Int {
        var result = pattern?.hashCode() ?: 0
        result = 31 * result + (patternName?.hashCode() ?: 0)
        result = 31 * result + (patternSetName?.hashCode() ?: 0)
        result = 31 * result + (rank)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as LogPattern

        if (pattern != other.pattern) return false
        if (patternName != other.patternName) return false
        if (patternSetName != other.patternSetName) return false
        if (rank != other.rank) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): LogPattern = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): LogPattern
        /**
         * A regular expression that defines the log pattern. A log pattern can contain as many as 50 characters, and it cannot
         * be empty. The pattern must be DFA compatible. Patterns that utilize forward lookahead or backreference constructions are not supported.
         */
        fun pattern(pattern: String): FluentBuilder
        /**
         * The name of the log pattern. A log pattern name can contain as many as 50 characters, and it cannot
         * be empty. The characters can be Unicode letters, digits, or one of the following symbols: period, dash, underscore.
         */
        fun patternName(patternName: String): FluentBuilder
        /**
         * The name of the log pattern. A log pattern name can contain as many as 30 characters, and it cannot
         * be empty. The characters can be Unicode letters, digits, or one of the following symbols: period, dash, underscore.
         */
        fun patternSetName(patternSetName: String): FluentBuilder
        /**
         * Rank of the log pattern. Must be a value between 1 and 1,000,000. The patterns are sorted by rank, so we recommend that you set your highest priority patterns with the lowest rank. A pattern of rank 1 will be the first to get matched to a log line. A pattern of rank 1,000,000 will be last to get matched. When you configure custom log patterns from the console, a Low severity pattern translates to a 750,000 rank. A Medium severity pattern translates to a 500,000 rank. And a High severity pattern translates to a 250,000 rank.
         * Rank values less than 1 or greater than 1,000,000 are reserved for AWS-provided patterns.
         */
        fun rank(rank: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A regular expression that defines the log pattern. A log pattern can contain as many as 50 characters, and it cannot
         * be empty. The pattern must be DFA compatible. Patterns that utilize forward lookahead or backreference constructions are not supported.
         */
        var pattern: String?
        /**
         * The name of the log pattern. A log pattern name can contain as many as 50 characters, and it cannot
         * be empty. The characters can be Unicode letters, digits, or one of the following symbols: period, dash, underscore.
         */
        var patternName: String?
        /**
         * The name of the log pattern. A log pattern name can contain as many as 30 characters, and it cannot
         * be empty. The characters can be Unicode letters, digits, or one of the following symbols: period, dash, underscore.
         */
        var patternSetName: String?
        /**
         * Rank of the log pattern. Must be a value between 1 and 1,000,000. The patterns are sorted by rank, so we recommend that you set your highest priority patterns with the lowest rank. A pattern of rank 1 will be the first to get matched to a log line. A pattern of rank 1,000,000 will be last to get matched. When you configure custom log patterns from the console, a Low severity pattern translates to a 750,000 rank. A Medium severity pattern translates to a 500,000 rank. And a High severity pattern translates to a 250,000 rank.
         * Rank values less than 1 or greater than 1,000,000 are reserved for AWS-provided patterns.
         */
        var rank: Int

        fun build(): LogPattern
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var pattern: String? = null
        override var patternName: String? = null
        override var patternSetName: String? = null
        override var rank: Int = 0

        constructor(x: LogPattern) : this() {
            this.pattern = x.pattern
            this.patternName = x.patternName
            this.patternSetName = x.patternSetName
            this.rank = x.rank
        }

        override fun build(): LogPattern = LogPattern(this)
        override fun pattern(pattern: String): FluentBuilder = apply { this.pattern = pattern }
        override fun patternName(patternName: String): FluentBuilder = apply { this.patternName = patternName }
        override fun patternSetName(patternSetName: String): FluentBuilder = apply { this.patternSetName = patternSetName }
        override fun rank(rank: Int): FluentBuilder = apply { this.rank = rank }
    }
}
