// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationinsights.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The event information.
 */
class ConfigurationEvent private constructor(builder: BuilderImpl) {
    /**
     * The details of the event in plain text.
     */
    val eventDetail: String? = builder.eventDetail
    /**
     * The name of the resource Application Insights attempted to configure.
     */
    val eventResourceName: String? = builder.eventResourceName
    /**
     * The resource type that Application Insights attempted to configure, for example, CLOUDWATCH_ALARM.
     */
    val eventResourceType: ConfigurationEventResourceType? = builder.eventResourceType
    /**
     * The status of the configuration update event. Possible values include INFO, WARN, and ERROR.
     */
    val eventStatus: ConfigurationEventStatus? = builder.eventStatus
    /**
     * The timestamp of the event.
     */
    val eventTime: Instant? = builder.eventTime
    /**
     * The resource monitored by Application Insights.
     */
    val monitoredResourceArn: String? = builder.monitoredResourceArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ConfigurationEvent = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ConfigurationEvent(")
        append("eventDetail=$eventDetail,")
        append("eventResourceName=$eventResourceName,")
        append("eventResourceType=$eventResourceType,")
        append("eventStatus=$eventStatus,")
        append("eventTime=$eventTime,")
        append("monitoredResourceArn=$monitoredResourceArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = eventDetail?.hashCode() ?: 0
        result = 31 * result + (eventResourceName?.hashCode() ?: 0)
        result = 31 * result + (eventResourceType?.hashCode() ?: 0)
        result = 31 * result + (eventStatus?.hashCode() ?: 0)
        result = 31 * result + (eventTime?.hashCode() ?: 0)
        result = 31 * result + (monitoredResourceArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ConfigurationEvent

        if (eventDetail != other.eventDetail) return false
        if (eventResourceName != other.eventResourceName) return false
        if (eventResourceType != other.eventResourceType) return false
        if (eventStatus != other.eventStatus) return false
        if (eventTime != other.eventTime) return false
        if (monitoredResourceArn != other.monitoredResourceArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ConfigurationEvent = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ConfigurationEvent
        /**
         * The details of the event in plain text.
         */
        fun eventDetail(eventDetail: String): FluentBuilder
        /**
         * The name of the resource Application Insights attempted to configure.
         */
        fun eventResourceName(eventResourceName: String): FluentBuilder
        /**
         * The resource type that Application Insights attempted to configure, for example, CLOUDWATCH_ALARM.
         */
        fun eventResourceType(eventResourceType: ConfigurationEventResourceType): FluentBuilder
        /**
         * The status of the configuration update event. Possible values include INFO, WARN, and ERROR.
         */
        fun eventStatus(eventStatus: ConfigurationEventStatus): FluentBuilder
        /**
         * The timestamp of the event.
         */
        fun eventTime(eventTime: Instant): FluentBuilder
        /**
         * The resource monitored by Application Insights.
         */
        fun monitoredResourceArn(monitoredResourceArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The details of the event in plain text.
         */
        var eventDetail: String?
        /**
         * The name of the resource Application Insights attempted to configure.
         */
        var eventResourceName: String?
        /**
         * The resource type that Application Insights attempted to configure, for example, CLOUDWATCH_ALARM.
         */
        var eventResourceType: ConfigurationEventResourceType?
        /**
         * The status of the configuration update event. Possible values include INFO, WARN, and ERROR.
         */
        var eventStatus: ConfigurationEventStatus?
        /**
         * The timestamp of the event.
         */
        var eventTime: Instant?
        /**
         * The resource monitored by Application Insights.
         */
        var monitoredResourceArn: String?

        fun build(): ConfigurationEvent
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var eventDetail: String? = null
        override var eventResourceName: String? = null
        override var eventResourceType: ConfigurationEventResourceType? = null
        override var eventStatus: ConfigurationEventStatus? = null
        override var eventTime: Instant? = null
        override var monitoredResourceArn: String? = null

        constructor(x: ConfigurationEvent) : this() {
            this.eventDetail = x.eventDetail
            this.eventResourceName = x.eventResourceName
            this.eventResourceType = x.eventResourceType
            this.eventStatus = x.eventStatus
            this.eventTime = x.eventTime
            this.monitoredResourceArn = x.monitoredResourceArn
        }

        override fun build(): ConfigurationEvent = ConfigurationEvent(this)
        override fun eventDetail(eventDetail: String): FluentBuilder = apply { this.eventDetail = eventDetail }
        override fun eventResourceName(eventResourceName: String): FluentBuilder = apply { this.eventResourceName = eventResourceName }
        override fun eventResourceType(eventResourceType: ConfigurationEventResourceType): FluentBuilder = apply { this.eventResourceType = eventResourceType }
        override fun eventStatus(eventStatus: ConfigurationEventStatus): FluentBuilder = apply { this.eventStatus = eventStatus }
        override fun eventTime(eventTime: Instant): FluentBuilder = apply { this.eventTime = eventTime }
        override fun monitoredResourceArn(monitoredResourceArn: String): FluentBuilder = apply { this.monitoredResourceArn = monitoredResourceArn }
    }
}
