// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationinsights.model



class CreateApplicationRequest private constructor(builder: BuilderImpl) {
    /**
     * Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as instance terminated, failed deployment, and others.
     */
    val cweMonitorEnabled: Boolean? = builder.cweMonitorEnabled
    /**
     * When set to true, creates opsItems for any problems detected on an application.
     */
    val opsCenterEnabled: Boolean? = builder.opsCenterEnabled
    /**
     * The SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to
     * receive notifications for updates to the opsItem.
     */
    val opsItemSnsTopicArn: String? = builder.opsItemSnsTopicArn
    /**
     * The name of the resource group.
     */
    val resourceGroupName: String? = builder.resourceGroupName
    /**
     * List of tags to add to the application.
     * tag key (Key) and an associated tag value (Value). The maximum
     * length of a tag key is 128 characters. The maximum length of a tag value is 256
     * characters.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateApplicationRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateApplicationRequest(")
        append("cweMonitorEnabled=$cweMonitorEnabled,")
        append("opsCenterEnabled=$opsCenterEnabled,")
        append("opsItemSnsTopicArn=$opsItemSnsTopicArn,")
        append("resourceGroupName=$resourceGroupName,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cweMonitorEnabled?.hashCode() ?: 0
        result = 31 * result + (opsCenterEnabled?.hashCode() ?: 0)
        result = 31 * result + (opsItemSnsTopicArn?.hashCode() ?: 0)
        result = 31 * result + (resourceGroupName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateApplicationRequest

        if (cweMonitorEnabled != other.cweMonitorEnabled) return false
        if (opsCenterEnabled != other.opsCenterEnabled) return false
        if (opsItemSnsTopicArn != other.opsItemSnsTopicArn) return false
        if (resourceGroupName != other.resourceGroupName) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateApplicationRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateApplicationRequest
        /**
         * Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as instance terminated, failed deployment, and others.
         */
        fun cweMonitorEnabled(cweMonitorEnabled: Boolean): FluentBuilder
        /**
         * When set to true, creates opsItems for any problems detected on an application.
         */
        fun opsCenterEnabled(opsCenterEnabled: Boolean): FluentBuilder
        /**
         * The SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to
         * receive notifications for updates to the opsItem.
         */
        fun opsItemSnsTopicArn(opsItemSnsTopicArn: String): FluentBuilder
        /**
         * The name of the resource group.
         */
        fun resourceGroupName(resourceGroupName: String): FluentBuilder
        /**
         * List of tags to add to the application.
         * tag key (Key) and an associated tag value (Value). The maximum
         * length of a tag key is 128 characters. The maximum length of a tag value is 256
         * characters.
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as instance terminated, failed deployment, and others.
         */
        var cweMonitorEnabled: Boolean?
        /**
         * When set to true, creates opsItems for any problems detected on an application.
         */
        var opsCenterEnabled: Boolean?
        /**
         * The SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to
         * receive notifications for updates to the opsItem.
         */
        var opsItemSnsTopicArn: String?
        /**
         * The name of the resource group.
         */
        var resourceGroupName: String?
        /**
         * List of tags to add to the application.
         * tag key (Key) and an associated tag value (Value). The maximum
         * length of a tag key is 128 characters. The maximum length of a tag value is 256
         * characters.
         */
        var tags: List<Tag>?

        fun build(): CreateApplicationRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var cweMonitorEnabled: Boolean? = null
        override var opsCenterEnabled: Boolean? = null
        override var opsItemSnsTopicArn: String? = null
        override var resourceGroupName: String? = null
        override var tags: List<Tag>? = null

        constructor(x: CreateApplicationRequest) : this() {
            this.cweMonitorEnabled = x.cweMonitorEnabled
            this.opsCenterEnabled = x.opsCenterEnabled
            this.opsItemSnsTopicArn = x.opsItemSnsTopicArn
            this.resourceGroupName = x.resourceGroupName
            this.tags = x.tags
        }

        override fun build(): CreateApplicationRequest = CreateApplicationRequest(this)
        override fun cweMonitorEnabled(cweMonitorEnabled: Boolean): FluentBuilder = apply { this.cweMonitorEnabled = cweMonitorEnabled }
        override fun opsCenterEnabled(opsCenterEnabled: Boolean): FluentBuilder = apply { this.opsCenterEnabled = opsCenterEnabled }
        override fun opsItemSnsTopicArn(opsItemSnsTopicArn: String): FluentBuilder = apply { this.opsItemSnsTopicArn = opsItemSnsTopicArn }
        override fun resourceGroupName(resourceGroupName: String): FluentBuilder = apply { this.resourceGroupName = resourceGroupName }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
