// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationinsights.model



class CreateLogPatternRequest private constructor(builder: BuilderImpl) {
    /**
     * The log pattern. The pattern must be DFA compatible. Patterns that utilize forward lookahead or backreference constructions are not supported.
     */
    val pattern: String? = builder.pattern
    /**
     * The name of the log pattern.
     */
    val patternName: String? = builder.patternName
    /**
     * The name of the log pattern set.
     */
    val patternSetName: String? = builder.patternSetName
    /**
     * Rank of the log pattern. Must be a value between 1 and 1,000,000. The patterns are sorted by rank, so we recommend that you set your highest priority patterns with the lowest rank. A pattern of rank 1 will be the first to get matched to a log line. A pattern of rank 1,000,000 will be last to get matched. When you configure custom log patterns from the console, a Low severity pattern translates to a 750,000 rank. A Medium severity pattern translates to a 500,000 rank. And a High severity pattern translates to a 250,000 rank.
     * Rank values less than 1 or greater than 1,000,000 are reserved for AWS-provided patterns.
     */
    val rank: Int = builder.rank
    /**
     * The name of the resource group.
     */
    val resourceGroupName: String? = builder.resourceGroupName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateLogPatternRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateLogPatternRequest(")
        append("pattern=$pattern,")
        append("patternName=$patternName,")
        append("patternSetName=$patternSetName,")
        append("rank=$rank,")
        append("resourceGroupName=$resourceGroupName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = pattern?.hashCode() ?: 0
        result = 31 * result + (patternName?.hashCode() ?: 0)
        result = 31 * result + (patternSetName?.hashCode() ?: 0)
        result = 31 * result + (rank)
        result = 31 * result + (resourceGroupName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateLogPatternRequest

        if (pattern != other.pattern) return false
        if (patternName != other.patternName) return false
        if (patternSetName != other.patternSetName) return false
        if (rank != other.rank) return false
        if (resourceGroupName != other.resourceGroupName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateLogPatternRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateLogPatternRequest
        /**
         * The log pattern. The pattern must be DFA compatible. Patterns that utilize forward lookahead or backreference constructions are not supported.
         */
        fun pattern(pattern: String): FluentBuilder
        /**
         * The name of the log pattern.
         */
        fun patternName(patternName: String): FluentBuilder
        /**
         * The name of the log pattern set.
         */
        fun patternSetName(patternSetName: String): FluentBuilder
        /**
         * Rank of the log pattern. Must be a value between 1 and 1,000,000. The patterns are sorted by rank, so we recommend that you set your highest priority patterns with the lowest rank. A pattern of rank 1 will be the first to get matched to a log line. A pattern of rank 1,000,000 will be last to get matched. When you configure custom log patterns from the console, a Low severity pattern translates to a 750,000 rank. A Medium severity pattern translates to a 500,000 rank. And a High severity pattern translates to a 250,000 rank.
         * Rank values less than 1 or greater than 1,000,000 are reserved for AWS-provided patterns.
         */
        fun rank(rank: Int): FluentBuilder
        /**
         * The name of the resource group.
         */
        fun resourceGroupName(resourceGroupName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The log pattern. The pattern must be DFA compatible. Patterns that utilize forward lookahead or backreference constructions are not supported.
         */
        var pattern: String?
        /**
         * The name of the log pattern.
         */
        var patternName: String?
        /**
         * The name of the log pattern set.
         */
        var patternSetName: String?
        /**
         * Rank of the log pattern. Must be a value between 1 and 1,000,000. The patterns are sorted by rank, so we recommend that you set your highest priority patterns with the lowest rank. A pattern of rank 1 will be the first to get matched to a log line. A pattern of rank 1,000,000 will be last to get matched. When you configure custom log patterns from the console, a Low severity pattern translates to a 750,000 rank. A Medium severity pattern translates to a 500,000 rank. And a High severity pattern translates to a 250,000 rank.
         * Rank values less than 1 or greater than 1,000,000 are reserved for AWS-provided patterns.
         */
        var rank: Int
        /**
         * The name of the resource group.
         */
        var resourceGroupName: String?

        fun build(): CreateLogPatternRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var pattern: String? = null
        override var patternName: String? = null
        override var patternSetName: String? = null
        override var rank: Int = 0
        override var resourceGroupName: String? = null

        constructor(x: CreateLogPatternRequest) : this() {
            this.pattern = x.pattern
            this.patternName = x.patternName
            this.patternSetName = x.patternSetName
            this.rank = x.rank
            this.resourceGroupName = x.resourceGroupName
        }

        override fun build(): CreateLogPatternRequest = CreateLogPatternRequest(this)
        override fun pattern(pattern: String): FluentBuilder = apply { this.pattern = pattern }
        override fun patternName(patternName: String): FluentBuilder = apply { this.patternName = patternName }
        override fun patternSetName(patternSetName: String): FluentBuilder = apply { this.patternSetName = patternSetName }
        override fun rank(rank: Int): FluentBuilder = apply { this.rank = rank }
        override fun resourceGroupName(resourceGroupName: String): FluentBuilder = apply { this.resourceGroupName = resourceGroupName }
    }
}
