// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationinsights.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an anomaly or error with the application.
 */
class Observation private constructor(builder: BuilderImpl) {
    /**
     * The detail type of the CloudWatch Event-based observation, for example, EC2
     * Instance State-change Notification.
     */
    val cloudWatchEventDetailType: String? = builder.cloudWatchEventDetailType
    /**
     * The ID of the CloudWatch Event-based observation related to the detected problem.
     */
    val cloudWatchEventId: String? = builder.cloudWatchEventId
    /**
     * The source of the CloudWatch Event.
     */
    val cloudWatchEventSource: CloudWatchEventSource? = builder.cloudWatchEventSource
    /**
     * The CodeDeploy application to which the deployment belongs.
     */
    val codeDeployApplication: String? = builder.codeDeployApplication
    /**
     * The deployment group to which the CodeDeploy deployment belongs.
     */
    val codeDeployDeploymentGroup: String? = builder.codeDeployDeploymentGroup
    /**
     * The deployment ID of the CodeDeploy-based observation related to the detected problem.
     */
    val codeDeployDeploymentId: String? = builder.codeDeployDeploymentId
    /**
     * The instance group to which the CodeDeploy instance belongs.
     */
    val codeDeployInstanceGroupId: String? = builder.codeDeployInstanceGroupId
    /**
     * The status of the CodeDeploy deployment, for example SUCCESS or  FAILURE.
     */
    val codeDeployState: String? = builder.codeDeployState
    /**
     * The cause of an EBS CloudWatch event.
     */
    val ebsCause: String? = builder.ebsCause
    /**
     * The type of EBS CloudWatch event, such as createVolume, deleteVolume or attachVolume.
     */
    val ebsEvent: String? = builder.ebsEvent
    /**
     * The request ID of an EBS CloudWatch event.
     */
    val ebsRequestId: String? = builder.ebsRequestId
    /**
     * The result of an EBS CloudWatch event, such as failed or succeeded.
     */
    val ebsResult: String? = builder.ebsResult
    /**
     * The state of the instance, such as STOPPING or TERMINATING.
     */
    val ec2State: String? = builder.ec2State
    /**
     * The time when the observation ended, in epoch seconds.
     */
    val endTime: Instant? = builder.endTime
    /**
     * The Amazon Resource Name (ARN) of the AWS Health Event-based observation.
     */
    val healthEventArn: String? = builder.healthEventArn
    /**
     * The description of the AWS Health event provided by the service, such as Amazon EC2.
     */
    val healthEventDescription: String? = builder.healthEventDescription
    /**
     * The category of the AWS Health event, such as issue.
     */
    val healthEventTypeCategory: String? = builder.healthEventTypeCategory
    /**
     * The type of the AWS Health event, for example,
     * AWS_EC2_POWER_CONNECTIVITY_ISSUE.
     */
    val healthEventTypeCode: String? = builder.healthEventTypeCode
    /**
     * The service to which the AWS Health Event belongs, such as EC2.
     */
    val healthService: String? = builder.healthService
    /**
     * The ID of the observation type.
     */
    val id: String? = builder.id
    /**
     * The timestamp in the CloudWatch Logs that specifies when the matched line occurred.
     */
    val lineTime: Instant? = builder.lineTime
    /**
     * The log filter of the observation.
     */
    val logFilter: LogFilter? = builder.logFilter
    /**
     * The log group name.
     */
    val logGroup: String? = builder.logGroup
    /**
     * The log text of the observation.
     */
    val logText: String? = builder.logText
    /**
     * The name of the observation metric.
     */
    val metricName: String? = builder.metricName
    /**
     * The namespace of the observation metric.
     */
    val metricNamespace: String? = builder.metricNamespace
    /**
     * The category of an RDS event.
     */
    val rdsEventCategories: String? = builder.rdsEventCategories
    /**
     * The message of an RDS event.
     */
    val rdsEventMessage: String? = builder.rdsEventMessage
    /**
     * The name of the S3 CloudWatch Event-based observation.
     */
    val s3EventName: String? = builder.s3EventName
    /**
     * The source resource ARN of the observation.
     */
    val sourceArn: String? = builder.sourceArn
    /**
     * The source type of the observation.
     */
    val sourceType: String? = builder.sourceType
    /**
     * The time when the observation was  first detected, in epoch seconds.
     */
    val startTime: Instant? = builder.startTime
    /**
     * The Amazon Resource Name (ARN)  of the step function-based observation.
     */
    val statesArn: String? = builder.statesArn
    /**
     * The Amazon Resource Name (ARN) of the step function execution-based observation.
     */
    val statesExecutionArn: String? = builder.statesExecutionArn
    /**
     * The input to the step function-based observation.
     */
    val statesInput: String? = builder.statesInput
    /**
     * The status of the step function-related observation.
     */
    val statesStatus: String? = builder.statesStatus
    /**
     * The unit of the source observation metric.
     */
    val unit: String? = builder.unit
    /**
     * The value of the source observation metric.
     */
    val value: Double? = builder.value
    /**
     * The X-Ray request error percentage for this node.
     */
    val xRayErrorPercent: Int? = builder.xRayErrorPercent
    /**
     * The X-Ray request fault percentage for this node.
     */
    val xRayFaultPercent: Int? = builder.xRayFaultPercent
    /**
     * The name of the X-Ray node.
     */
    val xRayNodeName: String? = builder.xRayNodeName
    /**
     * The type of the  X-Ray node.
     */
    val xRayNodeType: String? = builder.xRayNodeType
    /**
     * The X-Ray node request average latency for this node.
     */
    val xRayRequestAverageLatency: Long? = builder.xRayRequestAverageLatency
    /**
     * The X-Ray request count for this node.
     */
    val xRayRequestCount: Int? = builder.xRayRequestCount
    /**
     * The X-Ray request throttle percentage for this node.
     */
    val xRayThrottlePercent: Int? = builder.xRayThrottlePercent

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Observation = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Observation(")
        append("cloudWatchEventDetailType=$cloudWatchEventDetailType,")
        append("cloudWatchEventId=$cloudWatchEventId,")
        append("cloudWatchEventSource=$cloudWatchEventSource,")
        append("codeDeployApplication=$codeDeployApplication,")
        append("codeDeployDeploymentGroup=$codeDeployDeploymentGroup,")
        append("codeDeployDeploymentId=$codeDeployDeploymentId,")
        append("codeDeployInstanceGroupId=$codeDeployInstanceGroupId,")
        append("codeDeployState=$codeDeployState,")
        append("ebsCause=$ebsCause,")
        append("ebsEvent=$ebsEvent,")
        append("ebsRequestId=$ebsRequestId,")
        append("ebsResult=$ebsResult,")
        append("ec2State=$ec2State,")
        append("endTime=$endTime,")
        append("healthEventArn=$healthEventArn,")
        append("healthEventDescription=$healthEventDescription,")
        append("healthEventTypeCategory=$healthEventTypeCategory,")
        append("healthEventTypeCode=$healthEventTypeCode,")
        append("healthService=$healthService,")
        append("id=$id,")
        append("lineTime=$lineTime,")
        append("logFilter=$logFilter,")
        append("logGroup=$logGroup,")
        append("logText=$logText,")
        append("metricName=$metricName,")
        append("metricNamespace=$metricNamespace,")
        append("rdsEventCategories=$rdsEventCategories,")
        append("rdsEventMessage=$rdsEventMessage,")
        append("s3EventName=$s3EventName,")
        append("sourceArn=$sourceArn,")
        append("sourceType=$sourceType,")
        append("startTime=$startTime,")
        append("statesArn=$statesArn,")
        append("statesExecutionArn=$statesExecutionArn,")
        append("statesInput=$statesInput,")
        append("statesStatus=$statesStatus,")
        append("unit=$unit,")
        append("value=$value,")
        append("xRayErrorPercent=$xRayErrorPercent,")
        append("xRayFaultPercent=$xRayFaultPercent,")
        append("xRayNodeName=$xRayNodeName,")
        append("xRayNodeType=$xRayNodeType,")
        append("xRayRequestAverageLatency=$xRayRequestAverageLatency,")
        append("xRayRequestCount=$xRayRequestCount,")
        append("xRayThrottlePercent=$xRayThrottlePercent)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudWatchEventDetailType?.hashCode() ?: 0
        result = 31 * result + (cloudWatchEventId?.hashCode() ?: 0)
        result = 31 * result + (cloudWatchEventSource?.hashCode() ?: 0)
        result = 31 * result + (codeDeployApplication?.hashCode() ?: 0)
        result = 31 * result + (codeDeployDeploymentGroup?.hashCode() ?: 0)
        result = 31 * result + (codeDeployDeploymentId?.hashCode() ?: 0)
        result = 31 * result + (codeDeployInstanceGroupId?.hashCode() ?: 0)
        result = 31 * result + (codeDeployState?.hashCode() ?: 0)
        result = 31 * result + (ebsCause?.hashCode() ?: 0)
        result = 31 * result + (ebsEvent?.hashCode() ?: 0)
        result = 31 * result + (ebsRequestId?.hashCode() ?: 0)
        result = 31 * result + (ebsResult?.hashCode() ?: 0)
        result = 31 * result + (ec2State?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (healthEventArn?.hashCode() ?: 0)
        result = 31 * result + (healthEventDescription?.hashCode() ?: 0)
        result = 31 * result + (healthEventTypeCategory?.hashCode() ?: 0)
        result = 31 * result + (healthEventTypeCode?.hashCode() ?: 0)
        result = 31 * result + (healthService?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lineTime?.hashCode() ?: 0)
        result = 31 * result + (logFilter?.hashCode() ?: 0)
        result = 31 * result + (logGroup?.hashCode() ?: 0)
        result = 31 * result + (logText?.hashCode() ?: 0)
        result = 31 * result + (metricName?.hashCode() ?: 0)
        result = 31 * result + (metricNamespace?.hashCode() ?: 0)
        result = 31 * result + (rdsEventCategories?.hashCode() ?: 0)
        result = 31 * result + (rdsEventMessage?.hashCode() ?: 0)
        result = 31 * result + (s3EventName?.hashCode() ?: 0)
        result = 31 * result + (sourceArn?.hashCode() ?: 0)
        result = 31 * result + (sourceType?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (statesArn?.hashCode() ?: 0)
        result = 31 * result + (statesExecutionArn?.hashCode() ?: 0)
        result = 31 * result + (statesInput?.hashCode() ?: 0)
        result = 31 * result + (statesStatus?.hashCode() ?: 0)
        result = 31 * result + (unit?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        result = 31 * result + (xRayErrorPercent ?: 0)
        result = 31 * result + (xRayFaultPercent ?: 0)
        result = 31 * result + (xRayNodeName?.hashCode() ?: 0)
        result = 31 * result + (xRayNodeType?.hashCode() ?: 0)
        result = 31 * result + (xRayRequestAverageLatency?.hashCode() ?: 0)
        result = 31 * result + (xRayRequestCount ?: 0)
        result = 31 * result + (xRayThrottlePercent ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Observation

        if (cloudWatchEventDetailType != other.cloudWatchEventDetailType) return false
        if (cloudWatchEventId != other.cloudWatchEventId) return false
        if (cloudWatchEventSource != other.cloudWatchEventSource) return false
        if (codeDeployApplication != other.codeDeployApplication) return false
        if (codeDeployDeploymentGroup != other.codeDeployDeploymentGroup) return false
        if (codeDeployDeploymentId != other.codeDeployDeploymentId) return false
        if (codeDeployInstanceGroupId != other.codeDeployInstanceGroupId) return false
        if (codeDeployState != other.codeDeployState) return false
        if (ebsCause != other.ebsCause) return false
        if (ebsEvent != other.ebsEvent) return false
        if (ebsRequestId != other.ebsRequestId) return false
        if (ebsResult != other.ebsResult) return false
        if (ec2State != other.ec2State) return false
        if (endTime != other.endTime) return false
        if (healthEventArn != other.healthEventArn) return false
        if (healthEventDescription != other.healthEventDescription) return false
        if (healthEventTypeCategory != other.healthEventTypeCategory) return false
        if (healthEventTypeCode != other.healthEventTypeCode) return false
        if (healthService != other.healthService) return false
        if (id != other.id) return false
        if (lineTime != other.lineTime) return false
        if (logFilter != other.logFilter) return false
        if (logGroup != other.logGroup) return false
        if (logText != other.logText) return false
        if (metricName != other.metricName) return false
        if (metricNamespace != other.metricNamespace) return false
        if (rdsEventCategories != other.rdsEventCategories) return false
        if (rdsEventMessage != other.rdsEventMessage) return false
        if (s3EventName != other.s3EventName) return false
        if (sourceArn != other.sourceArn) return false
        if (sourceType != other.sourceType) return false
        if (startTime != other.startTime) return false
        if (statesArn != other.statesArn) return false
        if (statesExecutionArn != other.statesExecutionArn) return false
        if (statesInput != other.statesInput) return false
        if (statesStatus != other.statesStatus) return false
        if (unit != other.unit) return false
        if (value != other.value) return false
        if (xRayErrorPercent != other.xRayErrorPercent) return false
        if (xRayFaultPercent != other.xRayFaultPercent) return false
        if (xRayNodeName != other.xRayNodeName) return false
        if (xRayNodeType != other.xRayNodeType) return false
        if (xRayRequestAverageLatency != other.xRayRequestAverageLatency) return false
        if (xRayRequestCount != other.xRayRequestCount) return false
        if (xRayThrottlePercent != other.xRayThrottlePercent) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Observation = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Observation
        /**
         * The detail type of the CloudWatch Event-based observation, for example, EC2
         * Instance State-change Notification.
         */
        fun cloudWatchEventDetailType(cloudWatchEventDetailType: String): FluentBuilder
        /**
         * The ID of the CloudWatch Event-based observation related to the detected problem.
         */
        fun cloudWatchEventId(cloudWatchEventId: String): FluentBuilder
        /**
         * The source of the CloudWatch Event.
         */
        fun cloudWatchEventSource(cloudWatchEventSource: CloudWatchEventSource): FluentBuilder
        /**
         * The CodeDeploy application to which the deployment belongs.
         */
        fun codeDeployApplication(codeDeployApplication: String): FluentBuilder
        /**
         * The deployment group to which the CodeDeploy deployment belongs.
         */
        fun codeDeployDeploymentGroup(codeDeployDeploymentGroup: String): FluentBuilder
        /**
         * The deployment ID of the CodeDeploy-based observation related to the detected problem.
         */
        fun codeDeployDeploymentId(codeDeployDeploymentId: String): FluentBuilder
        /**
         * The instance group to which the CodeDeploy instance belongs.
         */
        fun codeDeployInstanceGroupId(codeDeployInstanceGroupId: String): FluentBuilder
        /**
         * The status of the CodeDeploy deployment, for example SUCCESS or  FAILURE.
         */
        fun codeDeployState(codeDeployState: String): FluentBuilder
        /**
         * The cause of an EBS CloudWatch event.
         */
        fun ebsCause(ebsCause: String): FluentBuilder
        /**
         * The type of EBS CloudWatch event, such as createVolume, deleteVolume or attachVolume.
         */
        fun ebsEvent(ebsEvent: String): FluentBuilder
        /**
         * The request ID of an EBS CloudWatch event.
         */
        fun ebsRequestId(ebsRequestId: String): FluentBuilder
        /**
         * The result of an EBS CloudWatch event, such as failed or succeeded.
         */
        fun ebsResult(ebsResult: String): FluentBuilder
        /**
         * The state of the instance, such as STOPPING or TERMINATING.
         */
        fun ec2State(ec2State: String): FluentBuilder
        /**
         * The time when the observation ended, in epoch seconds.
         */
        fun endTime(endTime: Instant): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the AWS Health Event-based observation.
         */
        fun healthEventArn(healthEventArn: String): FluentBuilder
        /**
         * The description of the AWS Health event provided by the service, such as Amazon EC2.
         */
        fun healthEventDescription(healthEventDescription: String): FluentBuilder
        /**
         * The category of the AWS Health event, such as issue.
         */
        fun healthEventTypeCategory(healthEventTypeCategory: String): FluentBuilder
        /**
         * The type of the AWS Health event, for example,
         * AWS_EC2_POWER_CONNECTIVITY_ISSUE.
         */
        fun healthEventTypeCode(healthEventTypeCode: String): FluentBuilder
        /**
         * The service to which the AWS Health Event belongs, such as EC2.
         */
        fun healthService(healthService: String): FluentBuilder
        /**
         * The ID of the observation type.
         */
        fun id(id: String): FluentBuilder
        /**
         * The timestamp in the CloudWatch Logs that specifies when the matched line occurred.
         */
        fun lineTime(lineTime: Instant): FluentBuilder
        /**
         * The log filter of the observation.
         */
        fun logFilter(logFilter: LogFilter): FluentBuilder
        /**
         * The log group name.
         */
        fun logGroup(logGroup: String): FluentBuilder
        /**
         * The log text of the observation.
         */
        fun logText(logText: String): FluentBuilder
        /**
         * The name of the observation metric.
         */
        fun metricName(metricName: String): FluentBuilder
        /**
         * The namespace of the observation metric.
         */
        fun metricNamespace(metricNamespace: String): FluentBuilder
        /**
         * The category of an RDS event.
         */
        fun rdsEventCategories(rdsEventCategories: String): FluentBuilder
        /**
         * The message of an RDS event.
         */
        fun rdsEventMessage(rdsEventMessage: String): FluentBuilder
        /**
         * The name of the S3 CloudWatch Event-based observation.
         */
        fun s3EventName(s3EventName: String): FluentBuilder
        /**
         * The source resource ARN of the observation.
         */
        fun sourceArn(sourceArn: String): FluentBuilder
        /**
         * The source type of the observation.
         */
        fun sourceType(sourceType: String): FluentBuilder
        /**
         * The time when the observation was  first detected, in epoch seconds.
         */
        fun startTime(startTime: Instant): FluentBuilder
        /**
         * The Amazon Resource Name (ARN)  of the step function-based observation.
         */
        fun statesArn(statesArn: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the step function execution-based observation.
         */
        fun statesExecutionArn(statesExecutionArn: String): FluentBuilder
        /**
         * The input to the step function-based observation.
         */
        fun statesInput(statesInput: String): FluentBuilder
        /**
         * The status of the step function-related observation.
         */
        fun statesStatus(statesStatus: String): FluentBuilder
        /**
         * The unit of the source observation metric.
         */
        fun unit(unit: String): FluentBuilder
        /**
         * The value of the source observation metric.
         */
        fun value(value: Double): FluentBuilder
        /**
         * The X-Ray request error percentage for this node.
         */
        fun xRayErrorPercent(xRayErrorPercent: Int): FluentBuilder
        /**
         * The X-Ray request fault percentage for this node.
         */
        fun xRayFaultPercent(xRayFaultPercent: Int): FluentBuilder
        /**
         * The name of the X-Ray node.
         */
        fun xRayNodeName(xRayNodeName: String): FluentBuilder
        /**
         * The type of the  X-Ray node.
         */
        fun xRayNodeType(xRayNodeType: String): FluentBuilder
        /**
         * The X-Ray node request average latency for this node.
         */
        fun xRayRequestAverageLatency(xRayRequestAverageLatency: Long): FluentBuilder
        /**
         * The X-Ray request count for this node.
         */
        fun xRayRequestCount(xRayRequestCount: Int): FluentBuilder
        /**
         * The X-Ray request throttle percentage for this node.
         */
        fun xRayThrottlePercent(xRayThrottlePercent: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The detail type of the CloudWatch Event-based observation, for example, EC2
         * Instance State-change Notification.
         */
        var cloudWatchEventDetailType: String?
        /**
         * The ID of the CloudWatch Event-based observation related to the detected problem.
         */
        var cloudWatchEventId: String?
        /**
         * The source of the CloudWatch Event.
         */
        var cloudWatchEventSource: CloudWatchEventSource?
        /**
         * The CodeDeploy application to which the deployment belongs.
         */
        var codeDeployApplication: String?
        /**
         * The deployment group to which the CodeDeploy deployment belongs.
         */
        var codeDeployDeploymentGroup: String?
        /**
         * The deployment ID of the CodeDeploy-based observation related to the detected problem.
         */
        var codeDeployDeploymentId: String?
        /**
         * The instance group to which the CodeDeploy instance belongs.
         */
        var codeDeployInstanceGroupId: String?
        /**
         * The status of the CodeDeploy deployment, for example SUCCESS or  FAILURE.
         */
        var codeDeployState: String?
        /**
         * The cause of an EBS CloudWatch event.
         */
        var ebsCause: String?
        /**
         * The type of EBS CloudWatch event, such as createVolume, deleteVolume or attachVolume.
         */
        var ebsEvent: String?
        /**
         * The request ID of an EBS CloudWatch event.
         */
        var ebsRequestId: String?
        /**
         * The result of an EBS CloudWatch event, such as failed or succeeded.
         */
        var ebsResult: String?
        /**
         * The state of the instance, such as STOPPING or TERMINATING.
         */
        var ec2State: String?
        /**
         * The time when the observation ended, in epoch seconds.
         */
        var endTime: Instant?
        /**
         * The Amazon Resource Name (ARN) of the AWS Health Event-based observation.
         */
        var healthEventArn: String?
        /**
         * The description of the AWS Health event provided by the service, such as Amazon EC2.
         */
        var healthEventDescription: String?
        /**
         * The category of the AWS Health event, such as issue.
         */
        var healthEventTypeCategory: String?
        /**
         * The type of the AWS Health event, for example,
         * AWS_EC2_POWER_CONNECTIVITY_ISSUE.
         */
        var healthEventTypeCode: String?
        /**
         * The service to which the AWS Health Event belongs, such as EC2.
         */
        var healthService: String?
        /**
         * The ID of the observation type.
         */
        var id: String?
        /**
         * The timestamp in the CloudWatch Logs that specifies when the matched line occurred.
         */
        var lineTime: Instant?
        /**
         * The log filter of the observation.
         */
        var logFilter: LogFilter?
        /**
         * The log group name.
         */
        var logGroup: String?
        /**
         * The log text of the observation.
         */
        var logText: String?
        /**
         * The name of the observation metric.
         */
        var metricName: String?
        /**
         * The namespace of the observation metric.
         */
        var metricNamespace: String?
        /**
         * The category of an RDS event.
         */
        var rdsEventCategories: String?
        /**
         * The message of an RDS event.
         */
        var rdsEventMessage: String?
        /**
         * The name of the S3 CloudWatch Event-based observation.
         */
        var s3EventName: String?
        /**
         * The source resource ARN of the observation.
         */
        var sourceArn: String?
        /**
         * The source type of the observation.
         */
        var sourceType: String?
        /**
         * The time when the observation was  first detected, in epoch seconds.
         */
        var startTime: Instant?
        /**
         * The Amazon Resource Name (ARN)  of the step function-based observation.
         */
        var statesArn: String?
        /**
         * The Amazon Resource Name (ARN) of the step function execution-based observation.
         */
        var statesExecutionArn: String?
        /**
         * The input to the step function-based observation.
         */
        var statesInput: String?
        /**
         * The status of the step function-related observation.
         */
        var statesStatus: String?
        /**
         * The unit of the source observation metric.
         */
        var unit: String?
        /**
         * The value of the source observation metric.
         */
        var value: Double?
        /**
         * The X-Ray request error percentage for this node.
         */
        var xRayErrorPercent: Int?
        /**
         * The X-Ray request fault percentage for this node.
         */
        var xRayFaultPercent: Int?
        /**
         * The name of the X-Ray node.
         */
        var xRayNodeName: String?
        /**
         * The type of the  X-Ray node.
         */
        var xRayNodeType: String?
        /**
         * The X-Ray node request average latency for this node.
         */
        var xRayRequestAverageLatency: Long?
        /**
         * The X-Ray request count for this node.
         */
        var xRayRequestCount: Int?
        /**
         * The X-Ray request throttle percentage for this node.
         */
        var xRayThrottlePercent: Int?

        fun build(): Observation
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var cloudWatchEventDetailType: String? = null
        override var cloudWatchEventId: String? = null
        override var cloudWatchEventSource: CloudWatchEventSource? = null
        override var codeDeployApplication: String? = null
        override var codeDeployDeploymentGroup: String? = null
        override var codeDeployDeploymentId: String? = null
        override var codeDeployInstanceGroupId: String? = null
        override var codeDeployState: String? = null
        override var ebsCause: String? = null
        override var ebsEvent: String? = null
        override var ebsRequestId: String? = null
        override var ebsResult: String? = null
        override var ec2State: String? = null
        override var endTime: Instant? = null
        override var healthEventArn: String? = null
        override var healthEventDescription: String? = null
        override var healthEventTypeCategory: String? = null
        override var healthEventTypeCode: String? = null
        override var healthService: String? = null
        override var id: String? = null
        override var lineTime: Instant? = null
        override var logFilter: LogFilter? = null
        override var logGroup: String? = null
        override var logText: String? = null
        override var metricName: String? = null
        override var metricNamespace: String? = null
        override var rdsEventCategories: String? = null
        override var rdsEventMessage: String? = null
        override var s3EventName: String? = null
        override var sourceArn: String? = null
        override var sourceType: String? = null
        override var startTime: Instant? = null
        override var statesArn: String? = null
        override var statesExecutionArn: String? = null
        override var statesInput: String? = null
        override var statesStatus: String? = null
        override var unit: String? = null
        override var value: Double? = null
        override var xRayErrorPercent: Int? = null
        override var xRayFaultPercent: Int? = null
        override var xRayNodeName: String? = null
        override var xRayNodeType: String? = null
        override var xRayRequestAverageLatency: Long? = null
        override var xRayRequestCount: Int? = null
        override var xRayThrottlePercent: Int? = null

        constructor(x: Observation) : this() {
            this.cloudWatchEventDetailType = x.cloudWatchEventDetailType
            this.cloudWatchEventId = x.cloudWatchEventId
            this.cloudWatchEventSource = x.cloudWatchEventSource
            this.codeDeployApplication = x.codeDeployApplication
            this.codeDeployDeploymentGroup = x.codeDeployDeploymentGroup
            this.codeDeployDeploymentId = x.codeDeployDeploymentId
            this.codeDeployInstanceGroupId = x.codeDeployInstanceGroupId
            this.codeDeployState = x.codeDeployState
            this.ebsCause = x.ebsCause
            this.ebsEvent = x.ebsEvent
            this.ebsRequestId = x.ebsRequestId
            this.ebsResult = x.ebsResult
            this.ec2State = x.ec2State
            this.endTime = x.endTime
            this.healthEventArn = x.healthEventArn
            this.healthEventDescription = x.healthEventDescription
            this.healthEventTypeCategory = x.healthEventTypeCategory
            this.healthEventTypeCode = x.healthEventTypeCode
            this.healthService = x.healthService
            this.id = x.id
            this.lineTime = x.lineTime
            this.logFilter = x.logFilter
            this.logGroup = x.logGroup
            this.logText = x.logText
            this.metricName = x.metricName
            this.metricNamespace = x.metricNamespace
            this.rdsEventCategories = x.rdsEventCategories
            this.rdsEventMessage = x.rdsEventMessage
            this.s3EventName = x.s3EventName
            this.sourceArn = x.sourceArn
            this.sourceType = x.sourceType
            this.startTime = x.startTime
            this.statesArn = x.statesArn
            this.statesExecutionArn = x.statesExecutionArn
            this.statesInput = x.statesInput
            this.statesStatus = x.statesStatus
            this.unit = x.unit
            this.value = x.value
            this.xRayErrorPercent = x.xRayErrorPercent
            this.xRayFaultPercent = x.xRayFaultPercent
            this.xRayNodeName = x.xRayNodeName
            this.xRayNodeType = x.xRayNodeType
            this.xRayRequestAverageLatency = x.xRayRequestAverageLatency
            this.xRayRequestCount = x.xRayRequestCount
            this.xRayThrottlePercent = x.xRayThrottlePercent
        }

        override fun build(): Observation = Observation(this)
        override fun cloudWatchEventDetailType(cloudWatchEventDetailType: String): FluentBuilder = apply { this.cloudWatchEventDetailType = cloudWatchEventDetailType }
        override fun cloudWatchEventId(cloudWatchEventId: String): FluentBuilder = apply { this.cloudWatchEventId = cloudWatchEventId }
        override fun cloudWatchEventSource(cloudWatchEventSource: CloudWatchEventSource): FluentBuilder = apply { this.cloudWatchEventSource = cloudWatchEventSource }
        override fun codeDeployApplication(codeDeployApplication: String): FluentBuilder = apply { this.codeDeployApplication = codeDeployApplication }
        override fun codeDeployDeploymentGroup(codeDeployDeploymentGroup: String): FluentBuilder = apply { this.codeDeployDeploymentGroup = codeDeployDeploymentGroup }
        override fun codeDeployDeploymentId(codeDeployDeploymentId: String): FluentBuilder = apply { this.codeDeployDeploymentId = codeDeployDeploymentId }
        override fun codeDeployInstanceGroupId(codeDeployInstanceGroupId: String): FluentBuilder = apply { this.codeDeployInstanceGroupId = codeDeployInstanceGroupId }
        override fun codeDeployState(codeDeployState: String): FluentBuilder = apply { this.codeDeployState = codeDeployState }
        override fun ebsCause(ebsCause: String): FluentBuilder = apply { this.ebsCause = ebsCause }
        override fun ebsEvent(ebsEvent: String): FluentBuilder = apply { this.ebsEvent = ebsEvent }
        override fun ebsRequestId(ebsRequestId: String): FluentBuilder = apply { this.ebsRequestId = ebsRequestId }
        override fun ebsResult(ebsResult: String): FluentBuilder = apply { this.ebsResult = ebsResult }
        override fun ec2State(ec2State: String): FluentBuilder = apply { this.ec2State = ec2State }
        override fun endTime(endTime: Instant): FluentBuilder = apply { this.endTime = endTime }
        override fun healthEventArn(healthEventArn: String): FluentBuilder = apply { this.healthEventArn = healthEventArn }
        override fun healthEventDescription(healthEventDescription: String): FluentBuilder = apply { this.healthEventDescription = healthEventDescription }
        override fun healthEventTypeCategory(healthEventTypeCategory: String): FluentBuilder = apply { this.healthEventTypeCategory = healthEventTypeCategory }
        override fun healthEventTypeCode(healthEventTypeCode: String): FluentBuilder = apply { this.healthEventTypeCode = healthEventTypeCode }
        override fun healthService(healthService: String): FluentBuilder = apply { this.healthService = healthService }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun lineTime(lineTime: Instant): FluentBuilder = apply { this.lineTime = lineTime }
        override fun logFilter(logFilter: LogFilter): FluentBuilder = apply { this.logFilter = logFilter }
        override fun logGroup(logGroup: String): FluentBuilder = apply { this.logGroup = logGroup }
        override fun logText(logText: String): FluentBuilder = apply { this.logText = logText }
        override fun metricName(metricName: String): FluentBuilder = apply { this.metricName = metricName }
        override fun metricNamespace(metricNamespace: String): FluentBuilder = apply { this.metricNamespace = metricNamespace }
        override fun rdsEventCategories(rdsEventCategories: String): FluentBuilder = apply { this.rdsEventCategories = rdsEventCategories }
        override fun rdsEventMessage(rdsEventMessage: String): FluentBuilder = apply { this.rdsEventMessage = rdsEventMessage }
        override fun s3EventName(s3EventName: String): FluentBuilder = apply { this.s3EventName = s3EventName }
        override fun sourceArn(sourceArn: String): FluentBuilder = apply { this.sourceArn = sourceArn }
        override fun sourceType(sourceType: String): FluentBuilder = apply { this.sourceType = sourceType }
        override fun startTime(startTime: Instant): FluentBuilder = apply { this.startTime = startTime }
        override fun statesArn(statesArn: String): FluentBuilder = apply { this.statesArn = statesArn }
        override fun statesExecutionArn(statesExecutionArn: String): FluentBuilder = apply { this.statesExecutionArn = statesExecutionArn }
        override fun statesInput(statesInput: String): FluentBuilder = apply { this.statesInput = statesInput }
        override fun statesStatus(statesStatus: String): FluentBuilder = apply { this.statesStatus = statesStatus }
        override fun unit(unit: String): FluentBuilder = apply { this.unit = unit }
        override fun value(value: Double): FluentBuilder = apply { this.value = value }
        override fun xRayErrorPercent(xRayErrorPercent: Int): FluentBuilder = apply { this.xRayErrorPercent = xRayErrorPercent }
        override fun xRayFaultPercent(xRayFaultPercent: Int): FluentBuilder = apply { this.xRayFaultPercent = xRayFaultPercent }
        override fun xRayNodeName(xRayNodeName: String): FluentBuilder = apply { this.xRayNodeName = xRayNodeName }
        override fun xRayNodeType(xRayNodeType: String): FluentBuilder = apply { this.xRayNodeType = xRayNodeType }
        override fun xRayRequestAverageLatency(xRayRequestAverageLatency: Long): FluentBuilder = apply { this.xRayRequestAverageLatency = xRayRequestAverageLatency }
        override fun xRayRequestCount(xRayRequestCount: Int): FluentBuilder = apply { this.xRayRequestCount = xRayRequestCount }
        override fun xRayThrottlePercent(xRayThrottlePercent: Int): FluentBuilder = apply { this.xRayThrottlePercent = xRayThrottlePercent }
    }
}
