// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationinsights.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a problem that is detected by correlating observations.
 */
class Problem private constructor(builder: BuilderImpl) {
    /**
     * The resource affected by the problem.
     */
    val affectedResource: String? = builder.affectedResource
    /**
     * The time when the problem ended, in epoch seconds.
     */
    val endTime: Instant? = builder.endTime
    /**
     * Feedback provided by the user about the problem.
     */
    val feedback: Map<String, FeedbackValue>? = builder.feedback
    /**
     * The ID of the problem.
     */
    val id: String? = builder.id
    /**
     * A detailed analysis of the problem using machine learning.
     */
    val insights: String? = builder.insights
    /**
     * The name of the resource group affected by the problem.
     */
    val resourceGroupName: String? = builder.resourceGroupName
    /**
     * A measure of the level of impact of the problem.
     */
    val severityLevel: SeverityLevel? = builder.severityLevel
    /**
     * The time when the problem started, in epoch seconds.
     */
    val startTime: Instant? = builder.startTime
    /**
     * The status of the problem.
     */
    val status: Status? = builder.status
    /**
     * The name of the problem.
     */
    val title: String? = builder.title

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Problem = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Problem(")
        append("affectedResource=$affectedResource,")
        append("endTime=$endTime,")
        append("feedback=$feedback,")
        append("id=$id,")
        append("insights=$insights,")
        append("resourceGroupName=$resourceGroupName,")
        append("severityLevel=$severityLevel,")
        append("startTime=$startTime,")
        append("status=$status,")
        append("title=$title)")
    }

    override fun hashCode(): kotlin.Int {
        var result = affectedResource?.hashCode() ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (feedback?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (insights?.hashCode() ?: 0)
        result = 31 * result + (resourceGroupName?.hashCode() ?: 0)
        result = 31 * result + (severityLevel?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Problem

        if (affectedResource != other.affectedResource) return false
        if (endTime != other.endTime) return false
        if (feedback != other.feedback) return false
        if (id != other.id) return false
        if (insights != other.insights) return false
        if (resourceGroupName != other.resourceGroupName) return false
        if (severityLevel != other.severityLevel) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false
        if (title != other.title) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Problem = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Problem
        /**
         * The resource affected by the problem.
         */
        fun affectedResource(affectedResource: String): FluentBuilder
        /**
         * The time when the problem ended, in epoch seconds.
         */
        fun endTime(endTime: Instant): FluentBuilder
        /**
         * Feedback provided by the user about the problem.
         */
        fun feedback(feedback: Map<String, FeedbackValue>): FluentBuilder
        /**
         * The ID of the problem.
         */
        fun id(id: String): FluentBuilder
        /**
         * A detailed analysis of the problem using machine learning.
         */
        fun insights(insights: String): FluentBuilder
        /**
         * The name of the resource group affected by the problem.
         */
        fun resourceGroupName(resourceGroupName: String): FluentBuilder
        /**
         * A measure of the level of impact of the problem.
         */
        fun severityLevel(severityLevel: SeverityLevel): FluentBuilder
        /**
         * The time when the problem started, in epoch seconds.
         */
        fun startTime(startTime: Instant): FluentBuilder
        /**
         * The status of the problem.
         */
        fun status(status: Status): FluentBuilder
        /**
         * The name of the problem.
         */
        fun title(title: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The resource affected by the problem.
         */
        var affectedResource: String?
        /**
         * The time when the problem ended, in epoch seconds.
         */
        var endTime: Instant?
        /**
         * Feedback provided by the user about the problem.
         */
        var feedback: Map<String, FeedbackValue>?
        /**
         * The ID of the problem.
         */
        var id: String?
        /**
         * A detailed analysis of the problem using machine learning.
         */
        var insights: String?
        /**
         * The name of the resource group affected by the problem.
         */
        var resourceGroupName: String?
        /**
         * A measure of the level of impact of the problem.
         */
        var severityLevel: SeverityLevel?
        /**
         * The time when the problem started, in epoch seconds.
         */
        var startTime: Instant?
        /**
         * The status of the problem.
         */
        var status: Status?
        /**
         * The name of the problem.
         */
        var title: String?

        fun build(): Problem
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var affectedResource: String? = null
        override var endTime: Instant? = null
        override var feedback: Map<String, FeedbackValue>? = null
        override var id: String? = null
        override var insights: String? = null
        override var resourceGroupName: String? = null
        override var severityLevel: SeverityLevel? = null
        override var startTime: Instant? = null
        override var status: Status? = null
        override var title: String? = null

        constructor(x: Problem) : this() {
            this.affectedResource = x.affectedResource
            this.endTime = x.endTime
            this.feedback = x.feedback
            this.id = x.id
            this.insights = x.insights
            this.resourceGroupName = x.resourceGroupName
            this.severityLevel = x.severityLevel
            this.startTime = x.startTime
            this.status = x.status
            this.title = x.title
        }

        override fun build(): Problem = Problem(this)
        override fun affectedResource(affectedResource: String): FluentBuilder = apply { this.affectedResource = affectedResource }
        override fun endTime(endTime: Instant): FluentBuilder = apply { this.endTime = endTime }
        override fun feedback(feedback: Map<String, FeedbackValue>): FluentBuilder = apply { this.feedback = feedback }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun insights(insights: String): FluentBuilder = apply { this.insights = insights }
        override fun resourceGroupName(resourceGroupName: String): FluentBuilder = apply { this.resourceGroupName = resourceGroupName }
        override fun severityLevel(severityLevel: SeverityLevel): FluentBuilder = apply { this.severityLevel = severityLevel }
        override fun startTime(startTime: Instant): FluentBuilder = apply { this.startTime = startTime }
        override fun status(status: Status): FluentBuilder = apply { this.status = status }
        override fun title(title: String): FluentBuilder = apply { this.title = title }
    }
}
