// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationinsights.model



class UpdateComponentConfigurationRequest private constructor(builder: BuilderImpl) {
    /**
     * The configuration settings of the component. The value is the escaped JSON of the configuration. For
     * more information about the JSON format, see <a href="https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/working-with-json.html">Working with JSON.
     * You can send a request to DescribeComponentConfigurationRecommendation to see the recommended configuration for a component. For the complete
     * format of the component configuration file, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/component-config.html">Component Configuration.
     */
    val componentConfiguration: String? = builder.componentConfiguration
    /**
     * The name of the component.
     */
    val componentName: String? = builder.componentName
    /**
     * Indicates whether the application component is monitored.
     */
    val monitor: Boolean? = builder.monitor
    /**
     * The name of the resource group.
     */
    val resourceGroupName: String? = builder.resourceGroupName
    /**
     * The tier of the application component. Supported tiers include DOT_NET_WORKER,
     * DOT_NET_WEB, DOT_NET_CORE, SQL_SERVER, and DEFAULT.
     */
    val tier: Tier? = builder.tier

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpdateComponentConfigurationRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateComponentConfigurationRequest(")
        append("componentConfiguration=$componentConfiguration,")
        append("componentName=$componentName,")
        append("monitor=$monitor,")
        append("resourceGroupName=$resourceGroupName,")
        append("tier=$tier)")
    }

    override fun hashCode(): kotlin.Int {
        var result = componentConfiguration?.hashCode() ?: 0
        result = 31 * result + (componentName?.hashCode() ?: 0)
        result = 31 * result + (monitor?.hashCode() ?: 0)
        result = 31 * result + (resourceGroupName?.hashCode() ?: 0)
        result = 31 * result + (tier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateComponentConfigurationRequest

        if (componentConfiguration != other.componentConfiguration) return false
        if (componentName != other.componentName) return false
        if (monitor != other.monitor) return false
        if (resourceGroupName != other.resourceGroupName) return false
        if (tier != other.tier) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpdateComponentConfigurationRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpdateComponentConfigurationRequest
        /**
         * The configuration settings of the component. The value is the escaped JSON of the configuration. For
         * more information about the JSON format, see <a href="https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/working-with-json.html">Working with JSON.
         * You can send a request to DescribeComponentConfigurationRecommendation to see the recommended configuration for a component. For the complete
         * format of the component configuration file, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/component-config.html">Component Configuration.
         */
        fun componentConfiguration(componentConfiguration: String): FluentBuilder
        /**
         * The name of the component.
         */
        fun componentName(componentName: String): FluentBuilder
        /**
         * Indicates whether the application component is monitored.
         */
        fun monitor(monitor: Boolean): FluentBuilder
        /**
         * The name of the resource group.
         */
        fun resourceGroupName(resourceGroupName: String): FluentBuilder
        /**
         * The tier of the application component. Supported tiers include DOT_NET_WORKER,
         * DOT_NET_WEB, DOT_NET_CORE, SQL_SERVER, and DEFAULT.
         */
        fun tier(tier: Tier): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The configuration settings of the component. The value is the escaped JSON of the configuration. For
         * more information about the JSON format, see <a href="https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/working-with-json.html">Working with JSON.
         * You can send a request to DescribeComponentConfigurationRecommendation to see the recommended configuration for a component. For the complete
         * format of the component configuration file, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/component-config.html">Component Configuration.
         */
        var componentConfiguration: String?
        /**
         * The name of the component.
         */
        var componentName: String?
        /**
         * Indicates whether the application component is monitored.
         */
        var monitor: Boolean?
        /**
         * The name of the resource group.
         */
        var resourceGroupName: String?
        /**
         * The tier of the application component. Supported tiers include DOT_NET_WORKER,
         * DOT_NET_WEB, DOT_NET_CORE, SQL_SERVER, and DEFAULT.
         */
        var tier: Tier?

        fun build(): UpdateComponentConfigurationRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var componentConfiguration: String? = null
        override var componentName: String? = null
        override var monitor: Boolean? = null
        override var resourceGroupName: String? = null
        override var tier: Tier? = null

        constructor(x: UpdateComponentConfigurationRequest) : this() {
            this.componentConfiguration = x.componentConfiguration
            this.componentName = x.componentName
            this.monitor = x.monitor
            this.resourceGroupName = x.resourceGroupName
            this.tier = x.tier
        }

        override fun build(): UpdateComponentConfigurationRequest = UpdateComponentConfigurationRequest(this)
        override fun componentConfiguration(componentConfiguration: String): FluentBuilder = apply { this.componentConfiguration = componentConfiguration }
        override fun componentName(componentName: String): FluentBuilder = apply { this.componentName = componentName }
        override fun monitor(monitor: Boolean): FluentBuilder = apply { this.monitor = monitor }
        override fun resourceGroupName(resourceGroupName: String): FluentBuilder = apply { this.resourceGroupName = resourceGroupName }
        override fun tier(tier: Tier): FluentBuilder = apply { this.tier = tier }
    }
}
