// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationinsights.model



/**
 * Describes the status of the application.
 */
class ApplicationInfo private constructor(builder: Builder) {
    /**
     * Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as instance terminated, failed deployment, and others.
     */
    val cweMonitorEnabled: kotlin.Boolean? = builder.cweMonitorEnabled
    /**
     * The lifecycle of the application.
     */
    val lifeCycle: kotlin.String? = builder.lifeCycle
    /**
     * Indicates whether Application Insights will create opsItems for any problem detected by Application
     * Insights for an application.
     */
    val opsCenterEnabled: kotlin.Boolean? = builder.opsCenterEnabled
    /**
     * The SNS topic provided to Application Insights that is associated to the created opsItems to receive SNS notifications
     * for opsItem updates.
     */
    val opsItemSnsTopicArn: kotlin.String? = builder.opsItemSnsTopicArn
    /**
     * The issues on the user side that block Application Insights from successfully monitoring
     * an application. Example remarks include:
     * “Configuring application, detected 1 Errors, 3 Warnings”
     * “Configuring application, detected 1 Unconfigured Components”
     */
    val remarks: kotlin.String? = builder.remarks
    /**
     * The name of the resource group used for the application.
     */
    val resourceGroupName: kotlin.String? = builder.resourceGroupName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.applicationinsights.model.ApplicationInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ApplicationInfo(")
        append("cweMonitorEnabled=$cweMonitorEnabled,")
        append("lifeCycle=$lifeCycle,")
        append("opsCenterEnabled=$opsCenterEnabled,")
        append("opsItemSnsTopicArn=$opsItemSnsTopicArn,")
        append("remarks=$remarks,")
        append("resourceGroupName=$resourceGroupName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cweMonitorEnabled?.hashCode() ?: 0
        result = 31 * result + (lifeCycle?.hashCode() ?: 0)
        result = 31 * result + (opsCenterEnabled?.hashCode() ?: 0)
        result = 31 * result + (opsItemSnsTopicArn?.hashCode() ?: 0)
        result = 31 * result + (remarks?.hashCode() ?: 0)
        result = 31 * result + (resourceGroupName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ApplicationInfo

        if (cweMonitorEnabled != other.cweMonitorEnabled) return false
        if (lifeCycle != other.lifeCycle) return false
        if (opsCenterEnabled != other.opsCenterEnabled) return false
        if (opsItemSnsTopicArn != other.opsItemSnsTopicArn) return false
        if (remarks != other.remarks) return false
        if (resourceGroupName != other.resourceGroupName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.applicationinsights.model.ApplicationInfo = Builder(this).apply(block).build()

    class Builder {
        /**
         * Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as instance terminated, failed deployment, and others.
         */
        var cweMonitorEnabled: kotlin.Boolean? = null
        /**
         * The lifecycle of the application.
         */
        var lifeCycle: kotlin.String? = null
        /**
         * Indicates whether Application Insights will create opsItems for any problem detected by Application
         * Insights for an application.
         */
        var opsCenterEnabled: kotlin.Boolean? = null
        /**
         * The SNS topic provided to Application Insights that is associated to the created opsItems to receive SNS notifications
         * for opsItem updates.
         */
        var opsItemSnsTopicArn: kotlin.String? = null
        /**
         * The issues on the user side that block Application Insights from successfully monitoring
         * an application. Example remarks include:
         * “Configuring application, detected 1 Errors, 3 Warnings”
         * “Configuring application, detected 1 Unconfigured Components”
         */
        var remarks: kotlin.String? = null
        /**
         * The name of the resource group used for the application.
         */
        var resourceGroupName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.applicationinsights.model.ApplicationInfo) : this() {
            this.cweMonitorEnabled = x.cweMonitorEnabled
            this.lifeCycle = x.lifeCycle
            this.opsCenterEnabled = x.opsCenterEnabled
            this.opsItemSnsTopicArn = x.opsItemSnsTopicArn
            this.remarks = x.remarks
            this.resourceGroupName = x.resourceGroupName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.applicationinsights.model.ApplicationInfo = ApplicationInfo(this)
    }
}
