// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationinsights

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.client.AwsClientConfig
import aws.sdk.kotlin.runtime.config.AwsClientConfigLoadOptions
import aws.sdk.kotlin.runtime.config.fromEnvironment
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.services.applicationinsights.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.applicationinsights.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * <fullname>Amazon CloudWatch Application Insights</fullname>
 * Amazon CloudWatch Application Insights is a service that
 * helps you detect common problems with your applications. It
 * enables you to pinpoint the source of issues in your applications (built with technologies
 * such as Microsoft IIS, .NET, and Microsoft SQL Server), by providing key insights into
 * detected problems.
 * After you onboard your application, CloudWatch Application Insights identifies,
 * recommends, and sets up metrics and logs. It continuously analyzes and
 * correlates your metrics and logs for unusual behavior to surface actionable problems with
 * your application. For example, if your application is slow and unresponsive and leading to
 * HTTP 500 errors in your Application Load Balancer (ALB), Application Insights informs you
 * that a memory pressure problem with your SQL Server database is occurring. It bases this
 * analysis on impactful metrics and log errors.
 */
interface ApplicationInsightsClient : SdkClient {

    override val serviceName: String
        get() = "Application Insights"
    /**
     * ApplicationInsightsClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(sharedConfig: AwsClientConfig? = null, block: Config.Builder.() -> Unit = {}): ApplicationInsightsClient {
            val config = Config.Builder().apply {
                region = sharedConfig?.region
                credentialsProvider = sharedConfig?.credentialsProvider
                sdkLogMode = sharedConfig?.sdkLogMode ?: SdkLogMode.Default
            }.apply(block).build()
            return DefaultApplicationInsightsClient(config)
        }

        operator fun invoke(config: Config): ApplicationInsightsClient = DefaultApplicationInsightsClient(config)

        /**
         * Construct a [ApplicationInsightsClient] by resolving the configuration from the current environment.
         * NOTE: If you are using multiple AWS service clients you may wish to share the configuration among them
         * by constructing a [aws.sdk.kotlin.runtime.client.AwsClientConfig] and passing it to each client at construction.
         */
        suspend fun fromEnvironment(block: AwsClientConfigLoadOptions.() -> Unit = {}): ApplicationInsightsClient {
            val sharedConfig = AwsClientConfig.fromEnvironment(block)
            return ApplicationInsightsClient(sharedConfig)
        }
    }

    class Config private constructor(builder: Builder): AwsClientConfig, HttpClientConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Adds an application that is created from a resource group.
     */
    suspend fun createApplication(input: CreateApplicationRequest): CreateApplicationResponse

    /**
     * Adds an application that is created from a resource group.
     */
    suspend fun createApplication(block: CreateApplicationRequest.Builder.() -> Unit) = createApplication(CreateApplicationRequest.Builder().apply(block).build())

    /**
     * Creates a custom component by grouping similar standalone instances to monitor.
     */
    suspend fun createComponent(input: CreateComponentRequest): CreateComponentResponse

    /**
     * Creates a custom component by grouping similar standalone instances to monitor.
     */
    suspend fun createComponent(block: CreateComponentRequest.Builder.() -> Unit) = createComponent(CreateComponentRequest.Builder().apply(block).build())

    /**
     * Adds an log pattern to a LogPatternSet.
     */
    suspend fun createLogPattern(input: CreateLogPatternRequest): CreateLogPatternResponse

    /**
     * Adds an log pattern to a LogPatternSet.
     */
    suspend fun createLogPattern(block: CreateLogPatternRequest.Builder.() -> Unit) = createLogPattern(CreateLogPatternRequest.Builder().apply(block).build())

    /**
     * Removes the specified application from monitoring. Does not delete the application.
     */
    suspend fun deleteApplication(input: DeleteApplicationRequest): DeleteApplicationResponse

    /**
     * Removes the specified application from monitoring. Does not delete the application.
     */
    suspend fun deleteApplication(block: DeleteApplicationRequest.Builder.() -> Unit) = deleteApplication(DeleteApplicationRequest.Builder().apply(block).build())

    /**
     * Ungroups a custom component. When you ungroup custom components, all applicable
     * monitors that are set up for the component are removed and the instances revert to their standalone status.
     */
    suspend fun deleteComponent(input: DeleteComponentRequest): DeleteComponentResponse

    /**
     * Ungroups a custom component. When you ungroup custom components, all applicable
     * monitors that are set up for the component are removed and the instances revert to their standalone status.
     */
    suspend fun deleteComponent(block: DeleteComponentRequest.Builder.() -> Unit) = deleteComponent(DeleteComponentRequest.Builder().apply(block).build())

    /**
     * Removes the specified log pattern from a LogPatternSet.
     */
    suspend fun deleteLogPattern(input: DeleteLogPatternRequest): DeleteLogPatternResponse

    /**
     * Removes the specified log pattern from a LogPatternSet.
     */
    suspend fun deleteLogPattern(block: DeleteLogPatternRequest.Builder.() -> Unit) = deleteLogPattern(DeleteLogPatternRequest.Builder().apply(block).build())

    /**
     * Describes the application.
     */
    suspend fun describeApplication(input: DescribeApplicationRequest): DescribeApplicationResponse

    /**
     * Describes the application.
     */
    suspend fun describeApplication(block: DescribeApplicationRequest.Builder.() -> Unit) = describeApplication(DescribeApplicationRequest.Builder().apply(block).build())

    /**
     * Describes a component and lists the resources that are grouped together in a component.
     */
    suspend fun describeComponent(input: DescribeComponentRequest): DescribeComponentResponse

    /**
     * Describes a component and lists the resources that are grouped together in a component.
     */
    suspend fun describeComponent(block: DescribeComponentRequest.Builder.() -> Unit) = describeComponent(DescribeComponentRequest.Builder().apply(block).build())

    /**
     * Describes the monitoring configuration of the component.
     */
    suspend fun describeComponentConfiguration(input: DescribeComponentConfigurationRequest): DescribeComponentConfigurationResponse

    /**
     * Describes the monitoring configuration of the component.
     */
    suspend fun describeComponentConfiguration(block: DescribeComponentConfigurationRequest.Builder.() -> Unit) = describeComponentConfiguration(DescribeComponentConfigurationRequest.Builder().apply(block).build())

    /**
     * Describes the recommended monitoring configuration of the component.
     */
    suspend fun describeComponentConfigurationRecommendation(input: DescribeComponentConfigurationRecommendationRequest): DescribeComponentConfigurationRecommendationResponse

    /**
     * Describes the recommended monitoring configuration of the component.
     */
    suspend fun describeComponentConfigurationRecommendation(block: DescribeComponentConfigurationRecommendationRequest.Builder.() -> Unit) = describeComponentConfigurationRecommendation(DescribeComponentConfigurationRecommendationRequest.Builder().apply(block).build())

    /**
     * Describe a specific log pattern from a LogPatternSet.
     */
    suspend fun describeLogPattern(input: DescribeLogPatternRequest): DescribeLogPatternResponse

    /**
     * Describe a specific log pattern from a LogPatternSet.
     */
    suspend fun describeLogPattern(block: DescribeLogPatternRequest.Builder.() -> Unit) = describeLogPattern(DescribeLogPatternRequest.Builder().apply(block).build())

    /**
     * Describes an anomaly or error with the application.
     */
    suspend fun describeObservation(input: DescribeObservationRequest): DescribeObservationResponse

    /**
     * Describes an anomaly or error with the application.
     */
    suspend fun describeObservation(block: DescribeObservationRequest.Builder.() -> Unit) = describeObservation(DescribeObservationRequest.Builder().apply(block).build())

    /**
     * Describes an application problem.
     */
    suspend fun describeProblem(input: DescribeProblemRequest): DescribeProblemResponse

    /**
     * Describes an application problem.
     */
    suspend fun describeProblem(block: DescribeProblemRequest.Builder.() -> Unit) = describeProblem(DescribeProblemRequest.Builder().apply(block).build())

    /**
     * Describes the anomalies or errors associated with the problem.
     */
    suspend fun describeProblemObservations(input: DescribeProblemObservationsRequest): DescribeProblemObservationsResponse

    /**
     * Describes the anomalies or errors associated with the problem.
     */
    suspend fun describeProblemObservations(block: DescribeProblemObservationsRequest.Builder.() -> Unit) = describeProblemObservations(DescribeProblemObservationsRequest.Builder().apply(block).build())

    /**
     * Lists the IDs of the applications that you are monitoring.
     */
    suspend fun listApplications(input: ListApplicationsRequest): ListApplicationsResponse

    /**
     * Lists the IDs of the applications that you are monitoring.
     */
    suspend fun listApplications(block: ListApplicationsRequest.Builder.() -> Unit) = listApplications(ListApplicationsRequest.Builder().apply(block).build())

    /**
     * Lists the auto-grouped, standalone, and custom components of the application.
     */
    suspend fun listComponents(input: ListComponentsRequest): ListComponentsResponse

    /**
     * Lists the auto-grouped, standalone, and custom components of the application.
     */
    suspend fun listComponents(block: ListComponentsRequest.Builder.() -> Unit) = listComponents(ListComponentsRequest.Builder().apply(block).build())

    /**
     * Lists the INFO, WARN, and ERROR events for periodic configuration updates performed by Application Insights. Examples of events represented are:
     * INFO: creating a new alarm or updating an alarm threshold.
     * WARN: alarm not created due to insufficient data points used to predict thresholds.
     * ERROR: alarm not created due to permission errors or exceeding quotas.
     */
    suspend fun listConfigurationHistory(input: ListConfigurationHistoryRequest): ListConfigurationHistoryResponse

    /**
     * Lists the INFO, WARN, and ERROR events for periodic configuration updates performed by Application Insights. Examples of events represented are:
     * INFO: creating a new alarm or updating an alarm threshold.
     * WARN: alarm not created due to insufficient data points used to predict thresholds.
     * ERROR: alarm not created due to permission errors or exceeding quotas.
     */
    suspend fun listConfigurationHistory(block: ListConfigurationHistoryRequest.Builder.() -> Unit) = listConfigurationHistory(ListConfigurationHistoryRequest.Builder().apply(block).build())

    /**
     * Lists the log pattern sets in the specific application.
     */
    suspend fun listLogPatternSets(input: ListLogPatternSetsRequest): ListLogPatternSetsResponse

    /**
     * Lists the log pattern sets in the specific application.
     */
    suspend fun listLogPatternSets(block: ListLogPatternSetsRequest.Builder.() -> Unit) = listLogPatternSets(ListLogPatternSetsRequest.Builder().apply(block).build())

    /**
     * Lists the log patterns in the specific log LogPatternSet.
     */
    suspend fun listLogPatterns(input: ListLogPatternsRequest): ListLogPatternsResponse

    /**
     * Lists the log patterns in the specific log LogPatternSet.
     */
    suspend fun listLogPatterns(block: ListLogPatternsRequest.Builder.() -> Unit) = listLogPatterns(ListLogPatternsRequest.Builder().apply(block).build())

    /**
     * Lists the problems with your application.
     */
    suspend fun listProblems(input: ListProblemsRequest): ListProblemsResponse

    /**
     * Lists the problems with your application.
     */
    suspend fun listProblems(block: ListProblemsRequest.Builder.() -> Unit) = listProblems(ListProblemsRequest.Builder().apply(block).build())

    /**
     * Retrieve a list of the tags (keys and values) that are associated with a specified
     * application. A tag is a label that you optionally define and associate
     * with an application. Each tag consists of a required tag key and an
     * optional associated tag value. A tag key is a general label that
     * acts as a category for more specific tag values. A tag value acts as a descriptor within
     * a tag key.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Retrieve a list of the tags (keys and values) that are associated with a specified
     * application. A tag is a label that you optionally define and associate
     * with an application. Each tag consists of a required tag key and an
     * optional associated tag value. A tag key is a general label that
     * acts as a category for more specific tag values. A tag value acts as a descriptor within
     * a tag key.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Add one or more tags (keys and values) to a specified application. A
     * tag is a label that you optionally define and associate with an
     * application. Tags can help you categorize and manage application in different ways, such as
     * by purpose, owner, environment, or other criteria.
     * Each tag consists of a required tag key and an
     * associated tag value, both of which you define. A tag key is a
     * general label that acts as a category for more specific tag values. A tag value acts as
     * a descriptor within a tag key.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Add one or more tags (keys and values) to a specified application. A
     * tag is a label that you optionally define and associate with an
     * application. Tags can help you categorize and manage application in different ways, such as
     * by purpose, owner, environment, or other criteria.
     * Each tag consists of a required tag key and an
     * associated tag value, both of which you define. A tag key is a
     * general label that acts as a category for more specific tag values. A tag value acts as
     * a descriptor within a tag key.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Remove one or more tags (keys and values) from a specified application.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Remove one or more tags (keys and values) from a specified application.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Updates the application.
     */
    suspend fun updateApplication(input: UpdateApplicationRequest): UpdateApplicationResponse

    /**
     * Updates the application.
     */
    suspend fun updateApplication(block: UpdateApplicationRequest.Builder.() -> Unit) = updateApplication(UpdateApplicationRequest.Builder().apply(block).build())

    /**
     * Updates the custom component name and/or the list of resources that make up the
     * component.
     */
    suspend fun updateComponent(input: UpdateComponentRequest): UpdateComponentResponse

    /**
     * Updates the custom component name and/or the list of resources that make up the
     * component.
     */
    suspend fun updateComponent(block: UpdateComponentRequest.Builder.() -> Unit) = updateComponent(UpdateComponentRequest.Builder().apply(block).build())

    /**
     * Updates the monitoring configurations for the component. The configuration input parameter
     * is an escaped JSON of the configuration and should match the schema of what is returned
     * by DescribeComponentConfigurationRecommendation.
     */
    suspend fun updateComponentConfiguration(input: UpdateComponentConfigurationRequest): UpdateComponentConfigurationResponse

    /**
     * Updates the monitoring configurations for the component. The configuration input parameter
     * is an escaped JSON of the configuration and should match the schema of what is returned
     * by DescribeComponentConfigurationRecommendation.
     */
    suspend fun updateComponentConfiguration(block: UpdateComponentConfigurationRequest.Builder.() -> Unit) = updateComponentConfiguration(UpdateComponentConfigurationRequest.Builder().apply(block).build())

    /**
     * Adds a log pattern to a LogPatternSet.
     */
    suspend fun updateLogPattern(input: UpdateLogPatternRequest): UpdateLogPatternResponse

    /**
     * Adds a log pattern to a LogPatternSet.
     */
    suspend fun updateLogPattern(block: UpdateLogPatternRequest.Builder.() -> Unit) = updateLogPattern(UpdateLogPatternRequest.Builder().apply(block).build())
}
