/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.runtime.auth.credentials;

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsNotLoadedException;
import aws.sdk.kotlin.runtime.auth.credentials.ImdsCredentialsProvider;
import aws.sdk.kotlin.runtime.auth.credentials.JsonCredentialsDeserializerKt;
import aws.sdk.kotlin.runtime.auth.credentials.JsonCredentialsResponse;
import aws.sdk.kotlin.runtime.auth.credentials.ProviderConfigurationException;
import aws.sdk.kotlin.runtime.config.AwsSdkSetting;
import aws.sdk.kotlin.runtime.config.imds.EC2MetadataError;
import aws.sdk.kotlin.runtime.config.imds.InstanceMetadataProvider;
import aws.smithy.kotlin.runtime.auth.awscredentials.CloseableCredentialsProvider;
import aws.smithy.kotlin.runtime.auth.awscredentials.Credentials;
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderException;
import aws.smithy.kotlin.runtime.config.EnvironmentSettingKt;
import aws.smithy.kotlin.runtime.http.HttpStatusCode;
import aws.smithy.kotlin.runtime.serde.Deserializer;
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer;
import aws.smithy.kotlin.runtime.telemetry.logging.CoroutineContextLogExtKt;
import aws.smithy.kotlin.runtime.telemetry.logging.LogLevel;
import aws.smithy.kotlin.runtime.time.Clock;
import aws.smithy.kotlin.runtime.time.Instant;
import aws.smithy.kotlin.runtime.util.Attributes;
import aws.smithy.kotlin.runtime.util.PlatformEnvironProvider;
import aws.smithy.kotlin.runtime.util.PlatformProvider;
import java.io.IOException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B5\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0011\u0010\u0014\u001a\u00020\u0003H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J\u0019\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019J\u001f\u0010\u001a\u001a\u0004\u0018\u00010\u00112\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001dH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001eR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001f"}, d2={"Laws/sdk/kotlin/runtime/auth/credentials/ImdsCredentialsProvider;", "Laws/smithy/kotlin/runtime/auth/awscredentials/CloseableCredentialsProvider;", "profileOverride", "", "client", "Lkotlin/Lazy;", "Laws/sdk/kotlin/runtime/config/imds/InstanceMetadataProvider;", "platformProvider", "Laws/smithy/kotlin/runtime/util/PlatformEnvironProvider;", "clock", "Laws/smithy/kotlin/runtime/time/Clock;", "(Ljava/lang/String;Lkotlin/Lazy;Laws/smithy/kotlin/runtime/util/PlatformEnvironProvider;Laws/smithy/kotlin/runtime/time/Clock;)V", "mu", "Lkotlinx/coroutines/sync/Mutex;", "nextRefresh", "Laws/smithy/kotlin/runtime/time/Instant;", "previousCredentials", "Laws/smithy/kotlin/runtime/auth/awscredentials/Credentials;", "close", "", "loadProfile", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "resolve", "attributes", "Laws/smithy/kotlin/runtime/util/Attributes;", "(Laws/smithy/kotlin/runtime/util/Attributes;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "useCachedCredentials", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Ljava/lang/Exception;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "aws-config"})
@SourceDebugExtension(value={"SMAP\nImdsCredentialsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImdsCredentialsProvider.kt\naws/sdk/kotlin/runtime/auth/credentials/ImdsCredentialsProvider\n+ 2 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 CoroutineContextLogExt.kt\naws/smithy/kotlin/runtime/telemetry/logging/CoroutineContextLogExtKt\n*L\n1#1,156:1\n120#2,8:157\n129#2:166\n120#2,10:173\n120#2,10:189\n1#3:165\n1#3:170\n1#3:186\n145#4,2:167\n100#4:169\n101#4,2:171\n167#4,2:183\n100#4:185\n101#4,2:187\n*S KotlinDebug\n*F\n+ 1 ImdsCredentialsProvider.kt\naws/sdk/kotlin/runtime/auth/credentials/ImdsCredentialsProvider\n*L\n73#1:157,8\n73#1:166\n117#1:173,10\n149#1:189,10\n98#1:170\n139#1:186\n98#1:167,2\n98#1:169\n98#1:171,2\n139#1:183,2\n139#1:185\n139#1:187,2\n*E\n"})
public final class ImdsCredentialsProvider
implements CloseableCredentialsProvider {
    @Nullable
    private final String profileOverride;
    @NotNull
    private final Lazy<InstanceMetadataProvider> client;
    @NotNull
    private final PlatformEnvironProvider platformProvider;
    @NotNull
    private final Clock clock;
    @Nullable
    private Credentials previousCredentials;
    @Nullable
    private Instant nextRefresh;
    @NotNull
    private final Mutex mu;

    public ImdsCredentialsProvider(@Nullable String profileOverride, @NotNull Lazy<? extends InstanceMetadataProvider> client2, @NotNull PlatformEnvironProvider platformProvider, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(client2, (String)"client");
        Intrinsics.checkNotNullParameter((Object)platformProvider, (String)"platformProvider");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.profileOverride = profileOverride;
        this.client = client2;
        this.platformProvider = platformProvider;
        this.clock = clock;
        this.mu = MutexKt.Mutex$default((boolean)false, (int)1, null);
    }

    public /* synthetic */ ImdsCredentialsProvider(String string, Lazy lazy, PlatformEnvironProvider platformEnvironProvider, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            lazy = LazyKt.lazy((Function0)1.INSTANCE);
        }
        if ((n & 4) != 0) {
            platformEnvironProvider = (PlatformEnvironProvider)PlatformProvider.Companion.getSystem();
        }
        if ((n & 8) != 0) {
            clock = (Clock)Clock.System.INSTANCE;
        }
        this(string, (Lazy<? extends InstanceMetadataProvider>)lazy, platformEnvironProvider, clock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public Object resolve(@NotNull Attributes var1_1, @NotNull Continuation<? super Credentials> var2_2) {
        if (!(var2_2 instanceof resolve.1)) ** GOTO lbl-1000
        var18_3 = var2_2;
        if ((var18_3.label & -2147483648) != 0) {
            var18_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ ImdsCredentialsProvider this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.resolve(null, (Continuation<? super Credentials>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var19_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (Intrinsics.areEqual((Object)EnvironmentSettingKt.resolve(AwsSdkSetting.INSTANCE.getAwsEc2MetadataDisabled(), (PlatformEnvironProvider)this.platformProvider), (Object)Boxing.boxBoolean((boolean)true))) {
                    throw new CredentialsNotLoadedException("AWS EC2 metadata is explicitly disabled; credentials not loaded", null, 2, null);
                }
                $this$withLock_u24default$iv = this.mu;
                owner$iv = null;
                $i$f$withLock = false;
                $continuation.L$0 = this;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock((Object)owner$iv, (Continuation)$continuation);
                if (v0 == var19_5) {
                    return var19_5;
                }
                ** GOTO lbl32
            }
            case 1: {
                $i$f$withLock = false;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                this = (ImdsCredentialsProvider)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl32:
                // 2 sources

                try {
                    $i$a$-withLock$default-ImdsCredentialsProvider$resolve$2 = false;
                    if (this.previousCredentials != null) {
                        $i$a$-run-ImdsCredentialsProvider$resolve$2$1 = false;
                        v1 /* !! */  = this.nextRefresh;
                        if (v1 /* !! */  != null) {
                            it = var9_19 = v1 /* !! */ ;
                            $i$a$-takeIf-ImdsCredentialsProvider$resolve$2$1$1 = false;
                            v1 /* !! */  = this.clock.now().compareTo(it) < 0 != false ? var9_19 : null;
                            if (v1 /* !! */  != null) {
                                $i$a$-run-ImdsCredentialsProvider$resolve$2$1$2 = false;
                                v2 = this.previousCredentials;
                                Intrinsics.checkNotNull((Object)v2);
                                var13_27 = v2;
                                return var13_27;
                            }
                        }
                        v3 = null;
                    } else {
                        v3 = null;
                    }
                    var12_30 = v3;
                }
                finally {
                    $this$withLock_u24default$iv.unlock((Object)owner$iv);
                }
                try {
                    v4 = this.profileOverride;
                    if (v4 == null) {
                        $continuation.L$0 = this;
                        $continuation.L$1 = null;
                        $continuation.label = 2;
                        v5 = this.loadProfile((Continuation<? super String>)$continuation);
                    }
                    ** GOTO lbl84
                }
                catch (Exception ex) {
                    $continuation.L$0 = ex;
                    $continuation.L$1 = null;
                    $continuation.label = 3;
                    v6 = this.useCachedCredentials(ex, (Continuation<? super Credentials>)$continuation);
                    if (v6 == var19_5) {
                        return var19_5;
                    }
                    ** GOTO lbl90
                }
                v7 = v5;
                if (v5 == var19_5) {
                    return var19_5;
                }
                ** GOTO lbl83
            }
            case 2: {
                this = (ImdsCredentialsProvider)$continuation.L$0;
                {
                    ResultKt.throwOnFailure((Object)$result);
                    v7 = $result;
lbl83:
                    // 2 sources

                    v4 = (String)v7;
lbl84:
                    // 2 sources

                    owner$iv = v4;
                    ** GOTO lbl93
                }
            }
            case 3: {
                ex = (Exception)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v6 = $result;
lbl90:
                // 2 sources

                v8 = (Credentials)v6;
                if (v8 != null) return v8;
                throw new CredentialsProviderException("failed to load instance profile", (Throwable)ex);
            }
lbl93:
            // 1 sources

            profileName = owner$iv;
            try {
                $continuation.L$0 = this;
                $continuation.L$1 = null;
                $continuation.label = 4;
                v9 = ((InstanceMetadataProvider)this.client.getValue()).get("/latest/meta-data/iam/security-credentials/" + profileName, (Continuation<? super String>)$continuation);
            }
            catch (Exception ex) {
                $continuation.L$0 = ex;
                $continuation.L$1 = null;
                $continuation.label = 5;
                v10 = this.useCachedCredentials(ex, (Continuation<? super Credentials>)$continuation);
                if (v10 == var19_5) {
                    return var19_5;
                }
                ** GOTO lbl124
            }
            v11 = v9;
            if (v9 == var19_5) {
                return var19_5;
            }
            ** GOTO lbl118
            case 4: {
                this = (ImdsCredentialsProvider)$continuation.L$0;
                {
                    ResultKt.throwOnFailure((Object)$result);
                    v11 = $result;
lbl118:
                    // 2 sources

                    ex = (String)v11;
                    ** GOTO lbl127
                }
            }
            case 5: {
                ex = (Exception)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v10 = $result;
lbl124:
                // 2 sources

                v12 = (Credentials)v10;
                if (v12 != null) return v12;
                throw new CredentialsProviderException("failed to load credentials", (Throwable)ex);
            }
lbl127:
            // 1 sources

            payload = ex;
            deserializer = new JsonDeserializer(StringsKt.encodeToByteArray((String)payload));
            $continuation.L$0 = this;
            $continuation.label = 6;
            v13 = JsonCredentialsDeserializerKt.deserializeJsonCredentials((Deserializer)deserializer, (Continuation<? super JsonCredentialsResponse>)$continuation);
            if (v13 == var19_5) {
                return var19_5;
            }
            ** GOTO lbl139
            case 6: {
                this = (ImdsCredentialsProvider)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v13 = $result;
lbl139:
                // 2 sources

                if (!((resp = (JsonCredentialsResponse)v13) instanceof JsonCredentialsResponse.SessionCredentials)) break;
                if (((JsonCredentialsResponse.SessionCredentials)resp).getExpiration() != null && ((JsonCredentialsResponse.SessionCredentials)resp).getExpiration().compareTo(this.clock.now()) < 0) {
                    $this$warn_u24default$iv = $continuation.getContext();
                    content$iv = resolve.3.INSTANCE;
                    ex$iv = null;
                    $i$f$warn = false;
                    $i$a$-run-ImdsCredentialsProvider$resolve$2$1$2 = $this$warn_u24default$iv;
                    level$iv$iv = LogLevel.Warning;
                    $i$f$log = false;
                    v14 = Reflection.getOrCreateKotlinClass(ImdsCredentialsProvider.class).getQualifiedName();
                    if (v14 == null) {
                        $i$a$-requireNotNull-CoroutineContextLogExtKt$log$sourceComponent$1$iv$iv = false;
                        $i$a$-requireNotNull-CoroutineContextLogExtKt$log$sourceComponent$1$iv$iv = "log<T> cannot be used on an anonymous object";
                        throw new IllegalArgumentException($i$a$-requireNotNull-CoroutineContextLogExtKt$log$sourceComponent$1$iv$iv.toString());
                    }
                    sourceComponent$iv$iv = v14;
                    CoroutineContextLogExtKt.log((CoroutineContext)$this$log$iv$iv, (LogLevel)level$iv$iv, (String)sourceComponent$iv$iv, ex$iv, (Function0)content$iv);
                    v15 = this.clock.now().plus-LRDsOJo(DurationKt.toDuration((int)900, (DurationUnit)DurationUnit.SECONDS));
                } else {
                    v15 = null;
                }
                this.nextRefresh = v15;
                it = var8_18 = (creds = new Credentials(((JsonCredentialsResponse.SessionCredentials)resp).getAccessKeyId(), ((JsonCredentialsResponse.SessionCredentials)resp).getSecretAccessKey(), ((JsonCredentialsResponse.SessionCredentials)resp).getSessionToken(), ((JsonCredentialsResponse.SessionCredentials)resp).getExpiration(), "IMDSv2"));
                $i$a$-also-ImdsCredentialsProvider$resolve$4 = false;
                $this$log$iv$iv = this.mu;
                $completion$iv = $continuation;
                owner$iv = null;
                $i$f$withLock = false;
                $continuation.L$0 = this;
                $continuation.L$1 = var8_18;
                $continuation.L$2 = it;
                $continuation.L$3 = $this$withLock_u24default$iv;
                $continuation.label = 7;
                v16 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$completion$iv);
                if (v16 == var19_5) {
                    return var19_5;
                }
                ** GOTO lbl188
            }
            case 7: {
                $i$a$-also-ImdsCredentialsProvider$resolve$4 = false;
                $i$f$withLock = false;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$3;
                it = (Credentials)$continuation.L$2;
                var8_18 = (Credentials)$continuation.L$1;
                this = (ImdsCredentialsProvider)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v16 = $result;
lbl188:
                // 2 sources

                try {
                    $i$a$-withLock$default-ImdsCredentialsProvider$resolve$4$1 = false;
                    this.previousCredentials = it;
                    var16_39 = Unit.INSTANCE;
                    return var8_18;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
            }
        }
        if (resp instanceof JsonCredentialsResponse.Error == false) throw new NoWhenBranchMatchedException();
        if (Intrinsics.areEqual((Object)((JsonCredentialsResponse.Error)resp).getCode(), (Object)"AssumeRoleUnauthorizedAccess") == false) throw new CredentialsProviderException("Error retrieving credentials from IMDS: code=" + ((JsonCredentialsResponse.Error)resp).getCode() + "; " + ((JsonCredentialsResponse.Error)resp).getMessage(), null, 2, null);
        throw new ProviderConfigurationException("Incorrect IMDS/IAM configuration: [" + ((JsonCredentialsResponse.Error)resp).getCode() + "] " + ((JsonCredentialsResponse.Error)resp).getMessage() + ". Hint: Does this role have a trust relationship with EC2?", null, 2, null);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public void close() {
        if (this.client.isInitialized()) {
            ((InstanceMetadataProvider)this.client.getValue()).close();
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Object loadProfile(Continuation<? super String> var1_1) {
        if (!(var1_1 instanceof loadProfile.1)) ** GOTO lbl-1000
        var14_2 = var1_1;
        if ((var14_2.label & -2147483648) != 0) {
            var14_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                /* synthetic */ Object result;
                final /* synthetic */ ImdsCredentialsProvider this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ImdsCredentialsProvider.access$loadProfile(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var15_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = ((InstanceMetadataProvider)this.client.getValue()).get("/latest/meta-data/iam/security-credentials", (Continuation<? super String>)$continuation);
                ** if (v0 != var15_4) goto lbl18
lbl17:
                // 1 sources

                return var15_4;
lbl18:
                // 1 sources

                ** GOTO lbl24
            }
            case 1: {
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl24:
                    // 2 sources

                    var2_5 = (String)v0;
                }
                catch (EC2MetadataError ex) {
                    if (ex.getStatusCode() == HttpStatusCode.Companion.getNotFound().getValue()) {
                        $this$info_u24default$iv = $continuation.getContext();
                        content$iv = loadProfile.2.INSTANCE;
                        ex$iv = null;
                        $i$f$info = false;
                        var8_11 = $this$info_u24default$iv;
                        level$iv$iv = LogLevel.Info;
                        $i$f$log = false;
                        v1 = Reflection.getOrCreateKotlinClass(ImdsCredentialsProvider.class).getQualifiedName();
                        if (v1 == null) {
                            $i$a$-requireNotNull-CoroutineContextLogExtKt$log$sourceComponent$1$iv$iv = false;
                            var11_15 = "log<T> cannot be used on an anonymous object";
                            throw new IllegalArgumentException(var11_15.toString());
                        }
                        sourceComponent$iv$iv = v1;
                        CoroutineContextLogExtKt.log((CoroutineContext)$this$log$iv$iv, (LogLevel)level$iv$iv, (String)sourceComponent$iv$iv, ex$iv, (Function0)content$iv);
                    }
                    throw ex;
                }
                return var2_5;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object useCachedCredentials(Exception var1_1, Continuation<? super Credentials> var2_2) {
        if (!(var2_2 instanceof useCachedCredentials.1)) ** GOTO lbl-1000
        var11_3 = var2_2;
        if ((var11_3.label & -2147483648) != 0) {
            var11_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ ImdsCredentialsProvider this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ImdsCredentialsProvider.access$useCachedCredentials(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!(ex instanceof IOException) && (!(ex instanceof EC2MetadataError) || ((EC2MetadataError)ex).getStatusCode() != HttpStatusCode.Companion.getInternalServerError().getValue())) break;
                $this$withLock_u24default$iv = this.mu;
                owner$iv = null;
                $i$f$withLock = false;
                $continuation.L$0 = this;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var12_5) {
                    return var12_5;
                }
                ** GOTO lbl32
            }
            case 1: {
                $i$f$withLock = false;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                this = (ImdsCredentialsProvider)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl32:
                // 2 sources

                try {
                    $i$a$-withLock$default-ImdsCredentialsProvider$useCachedCredentials$2 = false;
                    v1 = this.previousCredentials;
                    if (v1 != null) {
                        var7_11 = v1;
                        $i$a$-apply-ImdsCredentialsProvider$useCachedCredentials$2$1 = false;
                        this.nextRefresh = this.clock.now().plus-LRDsOJo(DurationKt.toDuration((int)900, (DurationUnit)DurationUnit.SECONDS));
                        v2 = var7_11;
                    } else {
                        v2 = null;
                    }
                    var9_13 = v2;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return var9_13;
            }
        }
        return null;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public ImdsCredentialsProvider() {
        this(null, null, null, null, 15, null);
    }

    public static final /* synthetic */ Object access$loadProfile(ImdsCredentialsProvider $this, Continuation $completion) {
        return $this.loadProfile((Continuation<? super String>)$completion);
    }

    public static final /* synthetic */ Object access$useCachedCredentials(ImdsCredentialsProvider $this, Exception ex, Continuation $completion) {
        return $this.useCachedCredentials(ex, (Continuation<? super Credentials>)$completion);
    }
}

