/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.runtime.auth.credentials.profile;

import aws.sdk.kotlin.runtime.auth.credentials.ProviderConfigurationException;
import aws.sdk.kotlin.runtime.auth.credentials.profile.LeafProvider;
import aws.sdk.kotlin.runtime.auth.credentials.profile.NextProfile;
import aws.sdk.kotlin.runtime.auth.credentials.profile.ProfileChainKt;
import aws.sdk.kotlin.runtime.auth.credentials.profile.RoleArn;
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig;
import aws.sdk.kotlin.runtime.config.profile.ConfigSection;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Laws/sdk/kotlin/runtime/auth/credentials/profile/ProfileChain;", "", "leaf", "Laws/sdk/kotlin/runtime/auth/credentials/profile/LeafProvider;", "roles", "", "Laws/sdk/kotlin/runtime/auth/credentials/profile/RoleArn;", "(Laws/sdk/kotlin/runtime/auth/credentials/profile/LeafProvider;Ljava/util/List;)V", "getLeaf", "()Laws/sdk/kotlin/runtime/auth/credentials/profile/LeafProvider;", "getRoles", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "aws-config"})
public final class ProfileChain {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LeafProvider leaf;
    @NotNull
    private final List<RoleArn> roles;

    public ProfileChain(@NotNull LeafProvider leaf, @NotNull List<RoleArn> roles) {
        Intrinsics.checkNotNullParameter((Object)leaf, (String)"leaf");
        Intrinsics.checkNotNullParameter(roles, (String)"roles");
        this.leaf = leaf;
        this.roles = roles;
    }

    @NotNull
    public final LeafProvider getLeaf() {
        return this.leaf;
    }

    @NotNull
    public final List<RoleArn> getRoles() {
        return this.roles;
    }

    @NotNull
    public final LeafProvider component1() {
        return this.leaf;
    }

    @NotNull
    public final List<RoleArn> component2() {
        return this.roles;
    }

    @NotNull
    public final ProfileChain copy(@NotNull LeafProvider leaf, @NotNull List<RoleArn> roles) {
        Intrinsics.checkNotNullParameter((Object)leaf, (String)"leaf");
        Intrinsics.checkNotNullParameter(roles, (String)"roles");
        return new ProfileChain(leaf, roles);
    }

    public static /* synthetic */ ProfileChain copy$default(ProfileChain profileChain, LeafProvider leafProvider, List list, int n, Object object) {
        if ((n & 1) != 0) {
            leafProvider = profileChain.leaf;
        }
        if ((n & 2) != 0) {
            list = profileChain.roles;
        }
        return profileChain.copy(leafProvider, list);
    }

    @NotNull
    public String toString() {
        return "ProfileChain(leaf=" + this.leaf + ", roles=" + this.roles + ')';
    }

    public int hashCode() {
        int result = this.leaf.hashCode();
        result = result * 31 + ((Object)this.roles).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProfileChain)) {
            return false;
        }
        ProfileChain profileChain = (ProfileChain)other;
        if (!Intrinsics.areEqual((Object)this.leaf, (Object)profileChain.leaf)) {
            return false;
        }
        return Intrinsics.areEqual(this.roles, profileChain.roles);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007\u00a8\u0006\b"}, d2={"Laws/sdk/kotlin/runtime/auth/credentials/profile/ProfileChain$Companion;", "", "()V", "resolve", "Laws/sdk/kotlin/runtime/auth/credentials/profile/ProfileChain;", "config", "Laws/sdk/kotlin/runtime/config/profile/AwsSharedConfig;", "resolve$aws_config", "aws-config"})
    @SourceDebugExtension(value={"SMAP\nProfileChain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfileChain.kt\naws/sdk/kotlin/runtime/auth/credentials/profile/ProfileChain$Companion\n+ 2 ProfileChain.kt\naws/sdk/kotlin/runtime/auth/credentials/profile/ProfileChainKt\n*L\n1#1,320:1\n90#2:321\n*S KotlinDebug\n*F\n+ 1 ProfileChain.kt\naws/sdk/kotlin/runtime/auth/credentials/profile/ProfileChain$Companion\n*L\n43#1:321\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ProfileChain resolve$aws_config(@NotNull AwsSharedConfig config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Set visited = new LinkedHashSet();
            List chain2 = new ArrayList();
            String sourceProfileName = null;
            sourceProfileName = config.getActiveProfile().getName();
            LeafProvider leaf = null;
            while (true) {
                ConfigSection profile2;
                void $this$getOrThrow$iv;
                Map<String, ConfigSection> map = config.getProfiles();
                String name$iv = sourceProfileName;
                boolean $i$f$getOrThrow = false;
                if ((ConfigSection)$this$getOrThrow$iv.get(name$iv) == null) {
                    boolean bl = false;
                    DefaultConstructorMarker defaultConstructorMarker = null;
                    int n = 2;
                    Throwable throwable = null;
                    String string = visited.isEmpty() ? "could not find source profile " + sourceProfileName : "could not find source profile " + sourceProfileName + " referenced from " + (String)CollectionsKt.last((Iterable)visited);
                    throw new ProviderConfigurationException(string, throwable, n, defaultConstructorMarker);
                }
                if (!visited.add(sourceProfileName)) {
                    throw new ProviderConfigurationException("profile formed an infinite loop: " + CollectionsKt.joinToString$default((Iterable)visited, (CharSequence)" -> ", null, null, (int)0, null, null, (int)62, null) + " -> " + sourceProfileName, null, 2, null);
                }
                if (visited.size() > 1 && (leaf = ProfileChainKt.access$staticCredsOrNull(profile2)) != null) break;
                RoleArn roleArn = ProfileChainKt.access$roleArnOrNull(profile2);
                if (roleArn == null) {
                    leaf = ProfileChainKt.access$leafProvider(profile2, config);
                    break;
                }
                chain2.add(roleArn);
                NextProfile nextProfile = ProfileChainKt.access$chainProvider(profile2);
                if (nextProfile instanceof NextProfile.SelfReference) {
                    leaf = ProfileChainKt.access$leafProvider(profile2, config);
                    break;
                }
                if (!(nextProfile instanceof NextProfile.Named)) continue;
                sourceProfileName = ((NextProfile.Named)nextProfile).getName();
            }
            CollectionsKt.reverse((List)chain2);
            LeafProvider leafProvider = leaf;
            if (leafProvider == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            return new ProfileChain(leafProvider, chain2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

