/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.runtime.auth.credentials.profile;

import aws.sdk.kotlin.runtime.auth.credentials.ProviderConfigurationException;
import aws.sdk.kotlin.runtime.auth.credentials.profile.LeafProvider;
import aws.sdk.kotlin.runtime.auth.credentials.profile.LeafProviderResult;
import aws.sdk.kotlin.runtime.auth.credentials.profile.NextProfile;
import aws.sdk.kotlin.runtime.auth.credentials.profile.RoleArn;
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig;
import aws.sdk.kotlin.runtime.config.profile.ConfigSection;
import aws.smithy.kotlin.runtime.auth.awscredentials.Credentials;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0010\u0010\u0010\u001a\u00020\u0011*\u00060\u0012j\u0002`\u0013H\u0002\u001a7\u0010\u0014\u001a\u00060\u0012j\u0002`\u0013*\u0012\u0012\u0004\u0012\u00020\u0001\u0012\b\u0012\u00060\u0012j\u0002`\u00130\u00152\u0006\u0010\u0016\u001a\u00020\u00012\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u0018H\u0082\b\u001a\u0018\u0010\u0019\u001a\u00020\u001a*\u00060\u0012j\u0002`\u00132\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u001a\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e*\u00060\u0012j\u0002`\u0013H\u0002\u001a!\u0010\u001f\u001a\u0004\u0018\u00010\u001e*\u0004\u0018\u00010\u001e2\u000e\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u0018H\u0082\b\u001a\u0012\u0010!\u001a\u0004\u0018\u00010\u001e*\u00060\u0012j\u0002`\u0013H\u0002\u001a\u0012\u0010\"\u001a\u0004\u0018\u00010#*\u00060\u0012j\u0002`\u0013H\u0002\u001a\u001a\u0010$\u001a\u0004\u0018\u00010\u001e*\u00060\u0012j\u0002`\u00132\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u001a\u0010\u0010%\u001a\u00020\u001e*\u00060\u0012j\u0002`\u0013H\u0002\u001a\u0012\u0010&\u001a\u0004\u0018\u00010\u001a*\u00060\u0012j\u0002`\u0013H\u0002\u001a\f\u0010'\u001a\u00020\u001a*\u00020\u001eH\u0002\u001a\u001d\u0010(\u001a\u00020\u001e*\u0004\u0018\u00010\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001e0\u0018H\u0082\b\u001a\u0012\u0010)\u001a\u0004\u0018\u00010\u001e*\u00060\u0012j\u0002`\u0013H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"AWS_ACCESS_KEY_ID", "", "AWS_SECRET_ACCESS_KEY", "AWS_SESSION_TOKEN", "CREDENTIAL_PROCESS", "CREDENTIAL_SOURCE", "EXTERNAL_ID", "ROLE_ARN", "ROLE_SESSION_NAME", "SOURCE_PROFILE", "SSO_ACCOUNT_ID", "SSO_REGION", "SSO_ROLE_NAME", "SSO_SESSION", "SSO_START_URL", "WEB_IDENTITY_TOKEN_FILE", "chainProvider", "Laws/sdk/kotlin/runtime/auth/credentials/profile/NextProfile;", "Laws/sdk/kotlin/runtime/config/profile/ConfigSection;", "Laws/sdk/kotlin/runtime/config/profile/AwsProfile;", "getOrThrow", "", "name", "lazyMessage", "Lkotlin/Function0;", "leafProvider", "Laws/sdk/kotlin/runtime/auth/credentials/profile/LeafProvider;", "config", "Laws/sdk/kotlin/runtime/config/profile/AwsSharedConfig;", "legacySsoCreds", "Laws/sdk/kotlin/runtime/auth/credentials/profile/LeafProviderResult;", "orElse", "fn", "processCreds", "roleArnOrNull", "Laws/sdk/kotlin/runtime/auth/credentials/profile/RoleArn;", "ssoSessionCreds", "staticCreds", "staticCredsOrNull", "unwrap", "unwrapOrElse", "webIdentityTokenCreds", "aws-config"})
@SourceDebugExtension(value={"SMAP\nProfileChain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfileChain.kt\naws/sdk/kotlin/runtime/auth/credentials/profile/ProfileChainKt\n*L\n1#1,320:1\n177#1,4:321\n177#1,4:325\n177#1,4:329\n169#1,4:333\n*S KotlinDebug\n*F\n+ 1 ProfileChain.kt\naws/sdk/kotlin/runtime/auth/credentials/profile/ProfileChainKt\n*L\n314#1:321,4\n315#1:325,4\n316#1:329,4\n317#1:333,4\n*E\n"})
public final class ProfileChainKt {
    @NotNull
    public static final String ROLE_ARN = "role_arn";
    @NotNull
    public static final String EXTERNAL_ID = "external_id";
    @NotNull
    public static final String ROLE_SESSION_NAME = "role_session_name";
    @NotNull
    public static final String CREDENTIAL_SOURCE = "credential_source";
    @NotNull
    public static final String SOURCE_PROFILE = "source_profile";
    @NotNull
    public static final String WEB_IDENTITY_TOKEN_FILE = "web_identity_token_file";
    @NotNull
    public static final String AWS_ACCESS_KEY_ID = "aws_access_key_id";
    @NotNull
    public static final String AWS_SECRET_ACCESS_KEY = "aws_secret_access_key";
    @NotNull
    public static final String AWS_SESSION_TOKEN = "aws_session_token";
    @NotNull
    public static final String SSO_START_URL = "sso_start_url";
    @NotNull
    public static final String SSO_REGION = "sso_region";
    @NotNull
    public static final String SSO_ACCOUNT_ID = "sso_account_id";
    @NotNull
    public static final String SSO_ROLE_NAME = "sso_role_name";
    @NotNull
    public static final String SSO_SESSION = "sso_session";
    @NotNull
    public static final String CREDENTIAL_PROCESS = "credential_process";

    private static final ConfigSection getOrThrow(Map<String, ConfigSection> $this$getOrThrow, String name, Function0<String> lazyMessage) {
        boolean $i$f$getOrThrow = false;
        ConfigSection configSection = $this$getOrThrow.get(name);
        if (configSection == null) {
            throw new ProviderConfigurationException((String)lazyMessage.invoke(), null, 2, null);
        }
        return configSection;
    }

    private static final RoleArn roleArnOrNull(ConfigSection $this$roleArnOrNull) {
        if ($this$roleArnOrNull.contains(WEB_IDENTITY_TOKEN_FILE)) {
            return null;
        }
        String string = ConfigSection.getOrNull$default($this$roleArnOrNull, ROLE_ARN, null, 2, null);
        if (string == null) {
            return null;
        }
        String roleArn = string;
        return new RoleArn(roleArn, ConfigSection.getOrNull$default($this$roleArnOrNull, ROLE_SESSION_NAME, null, 2, null), ConfigSection.getOrNull$default($this$roleArnOrNull, EXTERNAL_ID, null, 2, null));
    }

    private static final LeafProvider unwrap(LeafProviderResult $this$unwrap) {
        LeafProviderResult leafProviderResult = $this$unwrap;
        if (!(leafProviderResult instanceof LeafProviderResult.Ok)) {
            if (leafProviderResult instanceof LeafProviderResult.Err) {
                throw new ProviderConfigurationException(((LeafProviderResult.Err)$this$unwrap).getErrorMessage(), null, 2, null);
            }
            throw new NoWhenBranchMatchedException();
        }
        return ((LeafProviderResult.Ok)$this$unwrap).getProvider();
    }

    private static final LeafProviderResult unwrapOrElse(LeafProviderResult $this$unwrapOrElse, Function0<? extends LeafProviderResult> fn) {
        boolean $i$f$unwrapOrElse = false;
        return $this$unwrapOrElse == null ? (LeafProviderResult)fn.invoke() : $this$unwrapOrElse;
    }

    private static final LeafProviderResult orElse(LeafProviderResult $this$orElse, Function0<? extends LeafProviderResult> fn) {
        boolean $i$f$orElse = false;
        return $this$orElse == null ? (LeafProviderResult)fn.invoke() : $this$orElse;
    }

    private static final LeafProviderResult webIdentityTokenCreds(ConfigSection $this$webIdentityTokenCreds) {
        String roleArn = ConfigSection.getOrNull$default($this$webIdentityTokenCreds, ROLE_ARN, null, 2, null);
        String tokenFile = ConfigSection.getOrNull$default($this$webIdentityTokenCreds, WEB_IDENTITY_TOKEN_FILE, null, 2, null);
        String sessionName = ConfigSection.getOrNull$default($this$webIdentityTokenCreds, ROLE_SESSION_NAME, null, 2, null);
        return tokenFile == null ? null : (roleArn == null ? (LeafProviderResult)new LeafProviderResult.Err("profile (" + $this$webIdentityTokenCreds.getName() + ") missing `role_arn`") : (LeafProviderResult)new LeafProviderResult.Ok(new LeafProvider.WebIdentityTokenRole(roleArn, tokenFile, sessionName)));
    }

    private static final LeafProviderResult legacySsoCreds(ConfigSection $this$legacySsoCreds) {
        if (!$this$legacySsoCreds.contains(SSO_ACCOUNT_ID) && !$this$legacySsoCreds.contains(SSO_ROLE_NAME)) {
            return null;
        }
        String string = ConfigSection.getOrNull$default($this$legacySsoCreds, SSO_START_URL, null, 2, null);
        if (string == null) {
            return new LeafProviderResult.Err("profile (" + $this$legacySsoCreds.getName() + ") missing `sso_start_url`");
        }
        String startUrl = string;
        String string2 = ConfigSection.getOrNull$default($this$legacySsoCreds, SSO_REGION, null, 2, null);
        if (string2 == null) {
            return new LeafProviderResult.Err("profile (" + $this$legacySsoCreds.getName() + ") missing `sso_region`");
        }
        String ssoRegion = string2;
        String string3 = ConfigSection.getOrNull$default($this$legacySsoCreds, SSO_ACCOUNT_ID, null, 2, null);
        if (string3 == null) {
            return new LeafProviderResult.Err("profile (" + $this$legacySsoCreds.getName() + ") missing `sso_account_id`");
        }
        String accountId = string3;
        String string4 = ConfigSection.getOrNull$default($this$legacySsoCreds, SSO_ROLE_NAME, null, 2, null);
        if (string4 == null) {
            return new LeafProviderResult.Err("profile (" + $this$legacySsoCreds.getName() + ") missing `sso_role_name`");
        }
        String roleName = string4;
        return new LeafProviderResult.Ok(new LeafProvider.LegacySso(startUrl, ssoRegion, accountId, roleName));
    }

    private static final LeafProviderResult ssoSessionCreds(ConfigSection $this$ssoSessionCreds, AwsSharedConfig config) {
        String string = ConfigSection.getOrNull$default($this$ssoSessionCreds, SSO_SESSION, null, 2, null);
        if (string == null) {
            return null;
        }
        String sessionName = string;
        ConfigSection configSection = config.getSsoSessions().get(sessionName);
        if (configSection == null) {
            return new LeafProviderResult.Err("profile (" + $this$ssoSessionCreds.getName() + ") references non-existing sso_session = `" + sessionName + '`');
        }
        ConfigSection session = configSection;
        String string2 = ConfigSection.getOrNull$default(session, SSO_START_URL, null, 2, null);
        if (string2 == null) {
            return new LeafProviderResult.Err("sso-session (" + sessionName + ") missing `sso_start_url`");
        }
        String startUrl = string2;
        String string3 = ConfigSection.getOrNull$default(session, SSO_REGION, null, 2, null);
        if (string3 == null) {
            return new LeafProviderResult.Err("sso-session (" + sessionName + ") missing `sso_region`");
        }
        String ssoRegion = string3;
        String string4 = ConfigSection.getOrNull$default($this$ssoSessionCreds, SSO_ACCOUNT_ID, null, 2, null);
        if (string4 == null) {
            return new LeafProviderResult.Err("profile (" + $this$ssoSessionCreds.getName() + ") missing `sso_account_id`");
        }
        String accountId = string4;
        String string5 = ConfigSection.getOrNull$default($this$ssoSessionCreds, SSO_ROLE_NAME, null, 2, null);
        if (string5 == null) {
            return new LeafProviderResult.Err("profile (" + $this$ssoSessionCreds.getName() + ") missing `sso_role_name`");
        }
        String roleName = string5;
        String sessionSsoRegion = ConfigSection.getOrNull$default(session, SSO_REGION, null, 2, null);
        String profileSsoRegion = ConfigSection.getOrNull$default($this$ssoSessionCreds, SSO_REGION, null, 2, null);
        if (sessionSsoRegion != null && profileSsoRegion != null && !Intrinsics.areEqual((Object)sessionSsoRegion, (Object)profileSsoRegion)) {
            return new LeafProviderResult.Err("sso-session (" + sessionName + ") sso_region = `" + sessionSsoRegion + "` does not match profile (" + $this$ssoSessionCreds.getName() + ") sso_region = `" + profileSsoRegion + '`');
        }
        String sessionStartUrl = ConfigSection.getOrNull$default(session, SSO_START_URL, null, 2, null);
        String profileStartUrl = ConfigSection.getOrNull$default($this$ssoSessionCreds, SSO_START_URL, null, 2, null);
        if (sessionStartUrl != null && profileStartUrl != null && !Intrinsics.areEqual((Object)sessionStartUrl, (Object)profileStartUrl)) {
            return new LeafProviderResult.Err("sso-session (" + sessionName + ") sso_start_url = `" + sessionStartUrl + "` does not match profile (" + $this$ssoSessionCreds.getName() + ") sso_start_url = `" + profileStartUrl + '`');
        }
        return new LeafProviderResult.Ok(new LeafProvider.SsoSession(sessionName, startUrl, ssoRegion, accountId, roleName));
    }

    private static final LeafProviderResult processCreds(ConfigSection $this$processCreds) {
        if (!$this$processCreds.contains(CREDENTIAL_PROCESS)) {
            return null;
        }
        String string = ConfigSection.getOrNull$default($this$processCreds, CREDENTIAL_PROCESS, null, 2, null);
        if (string == null) {
            return new LeafProviderResult.Err("profile (" + $this$processCreds.getName() + ") missing `credential_process`");
        }
        String credentialProcess = string;
        return new LeafProviderResult.Ok(new LeafProvider.Process(credentialProcess));
    }

    private static final LeafProviderResult staticCreds(ConfigSection $this$staticCreds) {
        LeafProviderResult leafProviderResult;
        String accessKeyId = ConfigSection.getOrNull$default($this$staticCreds, AWS_ACCESS_KEY_ID, null, 2, null);
        String secretKey = ConfigSection.getOrNull$default($this$staticCreds, AWS_SECRET_ACCESS_KEY, null, 2, null);
        if (accessKeyId == null && secretKey == null) {
            leafProviderResult = new LeafProviderResult.Err("profile (" + $this$staticCreds.getName() + ") did not contain credential information");
        } else if (accessKeyId == null) {
            leafProviderResult = new LeafProviderResult.Err("profile (" + $this$staticCreds.getName() + ") missing `aws_access_key_id`");
        } else if (secretKey == null) {
            leafProviderResult = new LeafProviderResult.Err("profile (" + $this$staticCreds.getName() + ") missing `aws_secret_access_key`");
        } else {
            String sessionToken = ConfigSection.getOrNull$default($this$staticCreds, AWS_SESSION_TOKEN, null, 2, null);
            LeafProvider.AccessKey provider = new LeafProvider.AccessKey(new Credentials(accessKeyId, secretKey, sessionToken, null, null, 24, null));
            leafProviderResult = new LeafProviderResult.Ok(provider);
        }
        return leafProviderResult;
    }

    private static final LeafProvider staticCredsOrNull(ConfigSection $this$staticCredsOrNull) {
        LeafProviderResult result = ProfileChainKt.staticCreds($this$staticCredsOrNull);
        return result instanceof LeafProviderResult.Ok ? ((LeafProviderResult.Ok)result).getProvider() : null;
    }

    private static final NextProfile chainProvider(ConfigSection $this$chainProvider) {
        String sourceProfile = ConfigSection.getOrNull$default($this$chainProvider, SOURCE_PROFILE, null, 2, null);
        String credSource = ConfigSection.getOrNull$default($this$chainProvider, CREDENTIAL_SOURCE, null, 2, null);
        if (sourceProfile != null && credSource != null) {
            throw new ProviderConfigurationException("profile (" + $this$chainProvider.getName() + ") contained both `source_profile` and `credential_source`. Only one or the other can be defined.", null, 2, null);
        }
        if (sourceProfile == null && credSource == null) {
            throw new ProviderConfigurationException("profile (" + $this$chainProvider.getName() + ") must contain `source_profile` or `credential_source` but neither were defined", null, 2, null);
        }
        return sourceProfile != null && credSource == null ? (Intrinsics.areEqual((Object)sourceProfile, (Object)$this$chainProvider.getName()) ? (NextProfile)NextProfile.SelfReference.INSTANCE : (NextProfile)new NextProfile.Named(sourceProfile)) : (NextProfile)NextProfile.SelfReference.INSTANCE;
    }

    private static final LeafProvider leafProvider(ConfigSection $this$leafProvider, AwsSharedConfig config) {
        LeafProviderResult leafProviderResult;
        LeafProviderResult leafProviderResult2;
        LeafProviderResult leafProviderResult3;
        LeafProviderResult leafProviderResult4;
        String credSource = ConfigSection.getOrNull$default($this$leafProvider, CREDENTIAL_SOURCE, null, 2, null);
        if (credSource != null) {
            return new LeafProvider.NamedSource(credSource);
        }
        LeafProviderResult $this$orElse$iv = ProfileChainKt.webIdentityTokenCreds($this$leafProvider);
        boolean $i$f$orElse = false;
        if ($this$orElse$iv == null) {
            boolean bl = false;
            leafProviderResult4 = ProfileChainKt.ssoSessionCreds($this$leafProvider, config);
        } else {
            leafProviderResult4 = $this$orElse$iv;
        }
        $this$orElse$iv = leafProviderResult4;
        $i$f$orElse = false;
        if ($this$orElse$iv == null) {
            boolean bl = false;
            leafProviderResult3 = ProfileChainKt.legacySsoCreds($this$leafProvider);
        } else {
            leafProviderResult3 = $this$orElse$iv;
        }
        $this$orElse$iv = leafProviderResult3;
        $i$f$orElse = false;
        if ($this$orElse$iv == null) {
            boolean bl = false;
            leafProviderResult2 = ProfileChainKt.processCreds($this$leafProvider);
        } else {
            leafProviderResult2 = $this$orElse$iv;
        }
        LeafProviderResult $this$unwrapOrElse$iv = leafProviderResult2;
        boolean $i$f$unwrapOrElse = false;
        if ($this$unwrapOrElse$iv == null) {
            boolean bl = false;
            leafProviderResult = ProfileChainKt.staticCreds($this$leafProvider);
        } else {
            leafProviderResult = $this$unwrapOrElse$iv;
        }
        return ProfileChainKt.unwrap(leafProviderResult);
    }

    public static final /* synthetic */ LeafProvider access$staticCredsOrNull(ConfigSection $receiver) {
        return ProfileChainKt.staticCredsOrNull($receiver);
    }

    public static final /* synthetic */ RoleArn access$roleArnOrNull(ConfigSection $receiver) {
        return ProfileChainKt.roleArnOrNull($receiver);
    }

    public static final /* synthetic */ LeafProvider access$leafProvider(ConfigSection $receiver, AwsSharedConfig config) {
        return ProfileChainKt.leafProvider($receiver, config);
    }

    public static final /* synthetic */ NextProfile access$chainProvider(ConfigSection $receiver) {
        return ProfileChainKt.chainProvider($receiver);
    }
}

