/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.runtime.config.profile;

import aws.sdk.kotlin.runtime.InternalSdkApi;
import aws.sdk.kotlin.runtime.config.profile.AwsConfigurationSource;
import aws.sdk.kotlin.runtime.config.profile.ConfigSection;
import aws.sdk.kotlin.runtime.config.profile.ConfigSectionType;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@InternalSdkApi
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B7\b\u0000\u0012&\u0010\u0002\u001a\"\u0012\u0004\u0012\u00020\u0004\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003j\u0002`\u00070\u0003j\u0002`\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bR\u0015\u0010\f\u001a\u00060\u0006j\u0002`\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u00060\u0006j\u0002`\r0\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R.\u0010\u0002\u001a\"\u0012\u0004\u0012\u00020\u0004\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003j\u0002`\u00070\u0003j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u00060\u0006j\u0002`\u00140\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0012\u00a8\u0006\u0016"}, d2={"Laws/sdk/kotlin/runtime/config/profile/AwsSharedConfig;", "", "sections", "", "Laws/sdk/kotlin/runtime/config/profile/ConfigSectionType;", "", "Laws/sdk/kotlin/runtime/config/profile/ConfigSection;", "Laws/sdk/kotlin/runtime/config/profile/SectionMap;", "Laws/sdk/kotlin/runtime/config/profile/TypedSectionMap;", "source", "Laws/sdk/kotlin/runtime/config/profile/AwsConfigurationSource;", "(Ljava/util/Map;Laws/sdk/kotlin/runtime/config/profile/AwsConfigurationSource;)V", "activeProfile", "Laws/sdk/kotlin/runtime/config/profile/AwsProfile;", "getActiveProfile", "()Laws/sdk/kotlin/runtime/config/profile/ConfigSection;", "profiles", "getProfiles", "()Ljava/util/Map;", "ssoSessions", "Laws/sdk/kotlin/runtime/config/profile/SsoSessionConfig;", "getSsoSessions", "aws-config"})
public final class AwsSharedConfig {
    @NotNull
    private final Map<ConfigSectionType, Map<String, ConfigSection>> sections;
    @NotNull
    private final AwsConfigurationSource source;

    public AwsSharedConfig(@NotNull Map<ConfigSectionType, ? extends Map<String, ConfigSection>> sections, @NotNull AwsConfigurationSource source) {
        Intrinsics.checkNotNullParameter(sections, (String)"sections");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.sections = sections;
        this.source = source;
    }

    @NotNull
    public final Map<String, ConfigSection> getProfiles() {
        Map map = this.sections.get((Object)ConfigSectionType.PROFILE);
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    @NotNull
    public final Map<String, ConfigSection> getSsoSessions() {
        Map map = this.sections.get((Object)ConfigSectionType.SSO_SESSION);
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    @NotNull
    public final ConfigSection getActiveProfile() {
        ConfigSection configSection = this.getProfiles().get(this.source.getProfile());
        if (configSection == null) {
            configSection = new ConfigSection(this.source.getProfile(), MapsKt.emptyMap(), null, 4, null);
        }
        return configSection;
    }
}

