/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.runtime.config.profile;

import aws.sdk.kotlin.runtime.config.profile.ConfigSectionType;
import aws.sdk.kotlin.runtime.config.profile.FileLine;
import aws.sdk.kotlin.runtime.config.profile.FileLineKt;
import aws.sdk.kotlin.runtime.config.profile.TextKt;
import aws.sdk.kotlin.runtime.config.profile.Token;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0000\u001a&\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0000\u001a&\u0010\t\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0000\u001a&\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0000\u001a&\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0000*\u00a2\u0001\b\u0000\u0010\r\"M\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0002\u0012\u0015\u0012\u0013\u0018\u00010\u0001\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0004\u0012\u0015\u0012\u0013\u0018\u00010\u0006\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000e2M\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0002\u0012\u0015\u0012\u0013\u0018\u00010\u0001\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0004\u0012\u0015\u0012\u0013\u0018\u00010\u0006\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000e\u00a8\u0006\u0012"}, d2={"configurationSection", "Laws/sdk/kotlin/runtime/config/profile/Token$Section;", "input", "Laws/sdk/kotlin/runtime/config/profile/FileLine;", "currentSection", "lastProperty", "Laws/sdk/kotlin/runtime/config/profile/Token$Property;", "continuation", "Laws/sdk/kotlin/runtime/config/profile/Token$Continuation;", "credentialProfile", "property", "subProperty", "Laws/sdk/kotlin/runtime/config/profile/Token$SubProperty;", "ParseFn", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "Laws/sdk/kotlin/runtime/config/profile/Token;", "aws-config"})
public final class ParseFnKt {
    @Nullable
    public static final Token.Section configurationSection(@NotNull FileLine input, @Nullable Token.Section currentSection, @Nullable Token.Property lastProperty) {
        String name;
        String string;
        ConfigSectionType sectionType;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (!FileLineKt.isSection(input)) {
            return null;
        }
        List<String> parts = TextKt.splitWhitespace(StringsKt.dropLast((String)StringsKt.drop((String)TextKt.stripComments(TextKt.stripInlineComments(input.getContent())), (int)1), (int)1), 2);
        boolean hasSectionPrefix = !Intrinsics.areEqual((Object)CollectionsKt.firstOrNull(parts), (Object)"default");
        switch (parts.get(0)) {
            case "sso-session": {
                ConfigSectionType configSectionType = ConfigSectionType.SSO_SESSION;
                break;
            }
            case "services": {
                ConfigSectionType configSectionType = ConfigSectionType.SERVICES;
                break;
            }
            case "default": 
            case "profile": {
                ConfigSectionType configSectionType = ConfigSectionType.PROFILE;
                break;
            }
            default: {
                ConfigSectionType configSectionType = sectionType = ConfigSectionType.UNKNOWN;
            }
        }
        if ((string = (String)CollectionsKt.lastOrNull(parts)) == null) {
            string = name = "";
        }
        boolean isValid = parts.size() == 1 && Intrinsics.areEqual((Object)parts.get(0), (Object)"default") || parts.size() == 2 && ((CharSequence)name).length() > 0 && hasSectionPrefix && TextKt.isValidIdentifier(parts.get(1));
        return new Token.Section(name, sectionType, hasSectionPrefix, isValid);
    }

    @Nullable
    public static final Token.Section credentialProfile(@NotNull FileLine input, @Nullable Token.Section currentSection, @Nullable Token.Property lastProperty) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (!FileLineKt.isProfile(input)) {
            return null;
        }
        String name = ((Object)StringsKt.trim((CharSequence)StringsKt.dropLast((String)StringsKt.drop((String)TextKt.stripComments(TextKt.stripInlineComments(input.getContent())), (int)1), (int)1))).toString();
        return new Token.Section(name, ConfigSectionType.PROFILE, false, TextKt.isValidIdentifier(name));
    }

    @Nullable
    public static final Token.Property property(@NotNull FileLine input, @Nullable Token.Section currentSection, @Nullable Token.Property lastProperty) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (!FileLineKt.isProperty(input)) {
            return null;
        }
        if (currentSection == null) {
            return null;
        }
        Pair<String, String> pair = TextKt.splitProperty(input.getContent());
        String key = (String)pair.component1();
        String value = (String)pair.component2();
        return new Token.Property(key, TextKt.stripInlineComments(value));
    }

    @Nullable
    public static final Token.Continuation continuation(@NotNull FileLine input, @Nullable Token.Section currentSection, @Nullable Token.Property lastProperty) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (!FileLineKt.isContinuation(input)) {
            return null;
        }
        if (lastProperty == null || ((CharSequence)lastProperty.getValue()).length() == 0) {
            return null;
        }
        return new Token.Continuation(((Object)StringsKt.trim((CharSequence)input.getContent())).toString());
    }

    @Nullable
    public static final Token.SubProperty subProperty(@NotNull FileLine input, @Nullable Token.Section currentSection, @Nullable Token.Property lastProperty) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (!FileLineKt.isSubProperty(input)) {
            return null;
        }
        if (lastProperty == null || ((CharSequence)lastProperty.getValue()).length() > 0) {
            return null;
        }
        Pair<String, String> pair = TextKt.splitProperty(input.getContent());
        String key = (String)pair.component1();
        String value = (String)pair.component2();
        return new Token.SubProperty(key, value);
    }
}

